/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.ide.wst.common.utils;

import java.util.Map;
import org.eclipse.ant.core.AntRunner;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jst.j2ee.web.componentcore.util.WebArtifactEdit;
import org.eclipse.stardust.ide.wst.common.IModuleConfigurator;
import org.eclipse.stardust.ide.wst.common.IWebModuleConfigurator;
import org.eclipse.wst.common.componentcore.ArtifactEdit;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.internal.util.ComponentUtilities;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;

public class FacetSetupUtils {
    public static final String ADMINPORTAL_FACET = "ag.carnot.bpm.wst.adminportal.wst-facet";
    public static final String IPPPORTAL_FACET = "org.eclipse.stardust.ide.wst.facet.portal.wst-facet";
    public static final String DIAGRAM_FACET = "com.infinity.bpm.ide.wst.facet.diagrams.wst-facet";

    public static void executeAntTarget(IProject project, IPath antFile, String target, Map<String, String> properties) {
        AntRunner runner = new AntRunner();
        runner.setBuildFileLocation(antFile.toOSString());
        runner.setExecutionTargets(new String[]{target});
        runner.addUserProperties(properties);
        try {
            runner.run();
        }
        catch (CoreException ce) {
            ce.printStackTrace();
        }
    }

    public static void configureModule(IProject project, IModuleConfigurator configurator) {
        IVirtualComponent webComponent = ComponentCore.createComponent((IProject)project);
        ArtifactEdit artifact = ComponentUtilities.getArtifactEditForWrite((IVirtualComponent)webComponent);
        try {
            configurator.performConfiguration(artifact);
        }
        finally {
            artifact.dispose();
        }
    }

    public static void configureWebModule(IProject project, IWebModuleConfigurator configurator) {
        WebArtifactEdit artifact = WebArtifactEdit.getWebArtifactEditForWrite((IProject)project);
        try {
            configurator.performConfiguration(artifact);
            artifact.saveIfNecessary(null);
        }
        finally {
            artifact.dispose();
        }
    }

    public static boolean isFacetInstalled(IProject project, String facetId) {
        IFacetedProject projectFacet = null;
        try {
            projectFacet = ProjectFacetsManager.create((IProject)project);
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        if (projectFacet != null && facetId != null) {
            for (IProjectFacetVersion facetVersion : projectFacet.getProjectFacets()) {
                if (!facetId.equals(facetVersion.getProjectFacet().getId())) continue;
                return true;
            }
        }
        return false;
    }
}

