/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.ide.wst.common.utils;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.stardust.ide.wst.common.Common_Messages;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.ui.IStartup;
import org.eclipse.wst.common.project.facet.core.FacetedProjectFramework;

public class UpgradeFacets
implements IStartup {
    public static void upgradeProject(boolean doUpgrade) {
        boolean upgradeRequired = false;
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IProject[] projects = root.getProjects();
        int i = 0;
        while (i < projects.length) {
            IFile facetsXML;
            IFile file;
            IFolder folder;
            IProject project = projects[i];
            boolean isFacetedProject = false;
            try {
                if (project.hasNature("org.eclipse.wst.common.project.facet.core.nature")) {
                    isFacetedProject = FacetedProjectFramework.hasProjectFacet((IProject)project, (String)"ag.carnot.bpm.wst.jackrabbit.server.wst-facet");
                    isFacetedProject |= FacetedProjectFramework.hasProjectFacet((IProject)project, (String)"ag.carnot.bpm.wst.jackrabbit.client.wst-facet");
                    isFacetedProject |= FacetedProjectFramework.hasProjectFacet((IProject)project, (String)"ag.carnot.bpm.wst.diagrams.wst-facet");
                    isFacetedProject |= FacetedProjectFramework.hasProjectFacet((IProject)project, (String)"com.infinity.bpm.ide.wst.portals.wst-facet");
                }
            }
            catch (CoreException coreException) {}
            if (isFacetedProject && (folder = project.getFolder(".settings")).exists() && !(file = folder.getFile(".upgradeFacets")).exists() && (facetsXML = folder.getFile("org.eclipse.wst.common.project.facet.core.xml")).exists()) {
                if (!doUpgrade) {
                    upgradeRequired = true;
                    break;
                }
                try {
                    InputStream contents = facetsXML.getContents();
                    BufferedReader myInput = new BufferedReader(new InputStreamReader(contents));
                    String thisLine = null;
                    StringBuffer buffer = new StringBuffer();
                    while ((thisLine = myInput.readLine()) != null) {
                        String replaceAll = thisLine.replaceAll("ag.carnot.bpm.wst.jackrabbit", "org.eclipse.stardust.ide.wst.facet.jackrabbit");
                        replaceAll = replaceAll.replaceAll("ag.carnot.bpm.wst.diagrams", "com.infinity.bpm.ide.wst.facet.diagrams");
                        replaceAll = replaceAll.replaceAll("com.infinity.bpm.ide.wst.portals", "org.eclipse.stardust.ide.wst.facet.portal");
                        buffer.append(replaceAll);
                    }
                    myInput.close();
                    contents.close();
                    facetsXML.setContents((InputStream)new ByteArrayInputStream(buffer.toString().getBytes("UTF-8")), true, false, null);
                    file.create((InputStream)new ByteArrayInputStream("1".getBytes("UTF-8")), true, null);
                }
                catch (CoreException coreException) {
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                }
                catch (IOException iOException) {}
            }
            ++i;
        }
        if (upgradeRequired) {
            try {
                Display.getDefault().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        MessageBox messageBox = new MessageBox(Display.getDefault().getActiveShell(), 40);
                        messageBox.setText(Common_Messages.UpgradeFacets_message);
                        messageBox.setMessage(Common_Messages.UpgradeFacets_message);
                        messageBox.open();
                        UpgradeFacets.upgradeProject(true);
                    }
                });
            }
            catch (Exception exception) {}
        }
    }

    public void earlyStartup() {
        UpgradeFacets.upgradeProject(false);
    }
}

