/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.ide.wst.common.utils;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.variables.IDynamicVariable;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.stardust.common.StringUtils;
import org.eclipse.stardust.modeling.common.platform.utils.BundleUtils;
import org.osgi.framework.Bundle;

public class VariableUtils {
    public static void initializeClasspathVariableFromBundleRoot(String variable, String bundleId) {
        if (!StringUtils.isEmpty((String)variable) && !StringUtils.isEmpty((String)bundleId)) {
            IPath location = BundleUtils.getBundleLocation((String)bundleId);
            try {
                if (location != null) {
                    JavaCore.setClasspathVariable((String)variable, (IPath)location, null);
                } else {
                    JavaCore.removeClasspathVariable((String)variable, null);
                }
            }
            catch (JavaModelException e) {
                e.printStackTrace();
            }
        }
    }

    public static void initializeClasspathVariableFromBundleRoot(String variable, Bundle bundle) {
        if (!StringUtils.isEmpty((String)variable) && bundle != null) {
            IPath location = BundleUtils.getBundleLocation((Bundle)bundle);
            try {
                if (location != null) {
                    JavaCore.setClasspathVariable((String)variable, (IPath)location, null);
                } else {
                    JavaCore.removeClasspathVariable((String)variable, null);
                }
            }
            catch (JavaModelException e) {
                e.printStackTrace();
            }
        }
    }

    public static String resolveDynamicVariableFromBundleRoot(IDynamicVariable variable, String bundleId) throws CoreException {
        IPath location;
        String result = "";
        if (variable != null && !StringUtils.isEmpty((String)bundleId) && (location = BundleUtils.getBundleLocation((String)bundleId)) != null) {
            result = location.toOSString();
        }
        return result;
    }

    public static String resolveDynamicVariableFromBundleRoot(IDynamicVariable variable, Bundle bundle) throws CoreException {
        IPath location;
        String result = "";
        if (variable != null && bundle != null && (location = BundleUtils.getBundleLocation((Bundle)bundle)) != null) {
            result = location.toOSString();
        }
        return result;
    }
}

