/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.ide.wst.modeling.app.jsf.generation;

import java.util.Calendar;
import java.util.Date;
import org.eclipse.stardust.engine.api.runtime.Document;
import org.eclipse.stardust.engine.api.runtime.Folder;
import org.eclipse.stardust.engine.core.struct.IXPathMap;
import org.eclipse.stardust.engine.core.struct.StructuredDataXPathUtils;
import org.eclipse.stardust.engine.core.struct.StructuredTypeRtUtils;
import org.eclipse.stardust.engine.core.struct.TypedXPath;
import org.eclipse.stardust.ide.wst.modeling.app.jsf.generation.GenericDataMapping;
import org.eclipse.stardust.model.xpdl.carnot.DataType;
import org.eclipse.stardust.model.xpdl.carnot.util.StructuredTypeUtils;

public class ModelUtils {
    public static SystemDefinedData[] SYSTEM_DEFINED_DATA = new SystemDefinedData[]{new SystemDefinedData("PROCESS_ID", true), new SystemDefinedData("ROOT_PROCESS_ID", true), new SystemDefinedData("CURRENT_LOCALE", true), new SystemDefinedData("CURRENT_DATE", true), new SystemDefinedData("CURRENT_MODEL", true), new SystemDefinedData("CURRENT_USER", true), new SystemDefinedData("STARTING_USER", true), new SystemDefinedData("LAST_ACTIVITY_PERFORMER", true), new SystemDefinedData("PROCESS_ATTACHMENTS", true), new SystemDefinedData("PROCESS_PRIORITY", false)};

    public static boolean isPrimitiveType(GenericDataMapping mapping) {
        Class<?> type = mapping.getMappedType().getMappedType();
        if (Boolean.class == type || Long.class == type || Integer.class == type || Double.class == type || Float.class == type || Short.class == type || Byte.class == type || String.class == type || Character.class == type || Date.class == type || Calendar.class == type) {
            return true;
        }
        return "primitive".equals(mapping.getDataMapping().getData().getType().getId());
    }

    public static boolean isEnumerationType(GenericDataMapping mapping) {
        TypedXPath path;
        boolean isEnum = false;
        if (ModelUtils.isStructuredType(mapping) && (path = ModelUtils.getTypedXPath(mapping)) != null) {
            isEnum = path.isEnumeration();
        }
        return isEnum;
    }

    public static boolean isStructuredType(GenericDataMapping mapping) {
        return StructuredTypeRtUtils.isStructuredType((String)mapping.getDataMapping().getData().getType().getId());
    }

    public static boolean isDocumentType(GenericDataMapping mapping) {
        if (ModelUtils.isDMSType(mapping)) {
            return mapping.getMappedType().getMappedType().isAssignableFrom(Document.class);
        }
        return false;
    }

    public static boolean isFolderType(GenericDataMapping mapping) {
        if (ModelUtils.isDMSType(mapping)) {
            return mapping.getMappedType().getMappedType().isAssignableFrom(Folder.class);
        }
        return false;
    }

    public static boolean isDMSType(GenericDataMapping mapping) {
        return StructuredTypeRtUtils.isDmsType((String)mapping.getDataMapping().getData().getType().getId());
    }

    public static SystemDefinedData getSystemDefinedData(GenericDataMapping mapping) {
        SystemDefinedData[] systemDefinedDataArray = SYSTEM_DEFINED_DATA;
        int n = SYSTEM_DEFINED_DATA.length;
        int n2 = 0;
        while (n2 < n) {
            SystemDefinedData systemDefinedData = systemDefinedDataArray[n2];
            if (systemDefinedData.getDataId().equals(mapping.getId())) {
                return systemDefinedData;
            }
            ++n2;
        }
        return null;
    }

    public static SystemDefinedDataType getSystemDefinedDataType(String id) {
        SystemDefinedDataType dataType = null;
        if (SystemDefinedDataType.PROCESS_ID.name().equals(id)) {
            dataType = SystemDefinedDataType.PROCESS_ID;
        } else if (SystemDefinedDataType.ROOT_PROCESS_ID.name().equals(id)) {
            dataType = SystemDefinedDataType.ROOT_PROCESS_ID;
        } else if (SystemDefinedDataType.CURRENT_LOCALE.name().equals(id)) {
            dataType = SystemDefinedDataType.CURRENT_LOCALE;
        } else if (SystemDefinedDataType.CURRENT_DATE.name().equals(id)) {
            dataType = SystemDefinedDataType.CURRENT_DATE;
        } else if (SystemDefinedDataType.CURRENT_MODEL.name().equals(id)) {
            dataType = SystemDefinedDataType.CURRENT_MODEL;
        } else if (SystemDefinedDataType.CURRENT_USER.name().equals(id)) {
            dataType = SystemDefinedDataType.CURRENT_USER;
        } else if (SystemDefinedDataType.STARTING_USER.name().equals(id)) {
            dataType = SystemDefinedDataType.STARTING_USER;
        } else if (SystemDefinedDataType.LAST_ACTIVITY_PERFORMER.name().equals(id)) {
            dataType = SystemDefinedDataType.LAST_ACTIVITY_PERFORMER;
        } else if (SystemDefinedDataType.PROCESS_ATTACHMENTS.name().equals(id)) {
            dataType = SystemDefinedDataType.PROCESS_ATTACHMENTS;
        } else if (SystemDefinedDataType.PROCESS_PRIORITY.name().equals(id)) {
            dataType = SystemDefinedDataType.PROCESS_PRIORITY;
        }
        return dataType;
    }

    public static boolean isSystemDefinedData(GenericDataMapping mapping) {
        return ModelUtils.getSystemDefinedData(mapping) != null;
    }

    public static boolean isSystemDefinedReadOnlyData(GenericDataMapping mapping) {
        SystemDefinedData systemDefinedData = ModelUtils.getSystemDefinedData(mapping);
        if (systemDefinedData != null) {
            return systemDefinedData.isReadOnly();
        }
        return false;
    }

    public static boolean isDMSReadOnlyData(GenericDataMapping mapping) {
        if (ModelUtils.isDMSType(mapping)) {
            DmsWritableData[] dmsWritableDataArray = DmsWritableData.values();
            int n = dmsWritableDataArray.length;
            int n2 = 0;
            while (n2 < n) {
                DmsWritableData dmsWritableData = dmsWritableDataArray[n2];
                if (dmsWritableData.getDataMappingId().equals(mapping.getId())) {
                    return false;
                }
                ++n2;
            }
            return true;
        }
        return false;
    }

    public static TypedXPath getTypedXPath(GenericDataMapping dataMapping) {
        IXPathMap xPathMap = StructuredTypeUtils.getXPathMap((DataType)dataMapping.getDataMapping().getData());
        String startXPath = dataMapping.getDataMapping().getDataPath();
        TypedXPath typedXPath = xPathMap.getXPath(StructuredDataXPathUtils.getXPathWithoutIndexes((String)startXPath));
        return typedXPath;
    }

    public static enum DmsWritableData {
        DESCRIPTION("Description", "description");

        private final String dataMappingId;
        private final String dataPath;

        private DmsWritableData(String dataMappingId, String dataPath) {
            this.dataMappingId = dataMappingId;
            this.dataPath = dataPath;
        }

        public String getDataMappingId() {
            return this.dataMappingId;
        }

        public String getDataPath() {
            return this.dataPath;
        }
    }

    public static class SystemDefinedData {
        private String dataId;
        private boolean readOnly;

        private SystemDefinedData(String dataId, boolean readOnly) {
            this.dataId = dataId;
            this.readOnly = readOnly;
        }

        public String getDataId() {
            return this.dataId;
        }

        public boolean isReadOnly() {
            return this.readOnly;
        }
    }

    public static enum SystemDefinedDataType {
        PROCESS_ID,
        ROOT_PROCESS_ID,
        CURRENT_LOCALE,
        CURRENT_DATE,
        CURRENT_MODEL,
        CURRENT_USER,
        STARTING_USER,
        LAST_ACTIVITY_PERFORMER,
        PROCESS_ATTACHMENTS,
        PROCESS_PRIORITY;

    }
}

