/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.model.xpdl.carnot;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum DiagramModeType implements Enumerator
{
    MODE_400_LITERAL(0, "MODE_4_0_0", "MODE_4_0_0"),
    MODE_450_LITERAL(1, "MODE_4_5_0", "MODE_4_5_0");

    public static final String copyright = "Copyright 2000-2009 by SunGard Systeme GmbH";
    public static final int MODE_400 = 0;
    public static final int MODE_450 = 1;
    private static final DiagramModeType[] VALUES_ARRAY;
    public static final List<DiagramModeType> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new DiagramModeType[]{MODE_400_LITERAL, MODE_450_LITERAL};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static DiagramModeType get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            DiagramModeType result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static DiagramModeType getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            DiagramModeType result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static DiagramModeType get(int value) {
        switch (value) {
            case 0: {
                return MODE_400_LITERAL;
            }
            case 1: {
                return MODE_450_LITERAL;
            }
        }
        return null;
    }

    private DiagramModeType(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

