/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.model.xpdl.carnot;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum FlowControlType implements Enumerator
{
    NONE_LITERAL(0, "none", "none"),
    JOIN_LITERAL(1, "join", "join"),
    SPLIT_LITERAL(2, "split", "split");

    public static final String copyright = "Copyright 2000-2009 by SunGard Systeme GmbH";
    public static final int NONE = 0;
    public static final int JOIN = 1;
    public static final int SPLIT = 2;
    private static final FlowControlType[] VALUES_ARRAY;
    public static final List<FlowControlType> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new FlowControlType[]{NONE_LITERAL, JOIN_LITERAL, SPLIT_LITERAL};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static FlowControlType get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            FlowControlType result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static FlowControlType getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            FlowControlType result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static FlowControlType get(int value) {
        switch (value) {
            case 0: {
                return NONE_LITERAL;
            }
            case 1: {
                return JOIN_LITERAL;
            }
            case 2: {
                return SPLIT_LITERAL;
            }
        }
        return null;
    }

    private FlowControlType(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

