/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.model.xpdl.carnot;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum LinkCardinality implements Enumerator
{
    UNKNOWN_LITERAL(-1, "", ""),
    ONE_LITERAL(0, "*:1", "*:1"),
    MANY_LITERAL(1, "*:N", "*:N");

    public static final String copyright = "Copyright 2000-2009 by SunGard Systeme GmbH";
    public static final int UNKNOWN = -1;
    public static final int ONE = 0;
    public static final int MANY = 1;
    private static final LinkCardinality[] VALUES_ARRAY;
    public static final List<LinkCardinality> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new LinkCardinality[]{UNKNOWN_LITERAL, ONE_LITERAL, MANY_LITERAL};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static LinkCardinality get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            LinkCardinality result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static LinkCardinality getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            LinkCardinality result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static LinkCardinality get(int value) {
        switch (value) {
            case -1: {
                return UNKNOWN_LITERAL;
            }
            case 0: {
                return ONE_LITERAL;
            }
            case 1: {
                return MANY_LITERAL;
            }
        }
        return null;
    }

    private LinkCardinality(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

