/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.model.xpdl.carnot;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum LinkLineStyle implements Enumerator
{
    UNKNOWN_LITERAL(-1, "", ""),
    NORMAL_LITERAL(0, "normal line", "normal line"),
    SHORT_STROKES_LITERAL(1, "short strokes", "short strokes"),
    LONG_STROKES_LITERAL(2, "long strokes", "long strokes");

    public static final String copyright = "Copyright 2000-2009 by SunGard Systeme GmbH";
    public static final int UNKNOWN = -1;
    public static final int NORMAL = 0;
    public static final int SHORT_STROKES = 1;
    public static final int LONG_STROKES = 2;
    private static final LinkLineStyle[] VALUES_ARRAY;
    public static final List<LinkLineStyle> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new LinkLineStyle[]{UNKNOWN_LITERAL, NORMAL_LITERAL, SHORT_STROKES_LITERAL, LONG_STROKES_LITERAL};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static LinkLineStyle get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            LinkLineStyle result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static LinkLineStyle getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            LinkLineStyle result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static LinkLineStyle get(int value) {
        switch (value) {
            case -1: {
                return UNKNOWN_LITERAL;
            }
            case 0: {
                return NORMAL_LITERAL;
            }
            case 1: {
                return SHORT_STROKES_LITERAL;
            }
            case 2: {
                return LONG_STROKES_LITERAL;
            }
        }
        return null;
    }

    private LinkLineStyle(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

