/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.model.xpdl.carnot.merge;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EContentsEList;
import org.eclipse.stardust.model.xpdl.carnot.DataType;
import org.eclipse.stardust.model.xpdl.carnot.IIdentifiableModelElement;
import org.eclipse.stardust.model.xpdl.carnot.ModelType;
import org.eclipse.stardust.model.xpdl.carnot.ProcessDefinitionType;
import org.eclipse.stardust.model.xpdl.carnot.extensions.FormalParameterMappingsType;
import org.eclipse.stardust.model.xpdl.carnot.util.AttributeUtil;
import org.eclipse.stardust.model.xpdl.carnot.util.ModelUtils;
import org.eclipse.stardust.model.xpdl.xpdl2.ExternalReferenceType;
import org.eclipse.stardust.model.xpdl.xpdl2.FormalParameterType;
import org.eclipse.stardust.model.xpdl.xpdl2.FormalParametersType;
import org.eclipse.stardust.model.xpdl.xpdl2.SchemaTypeType;
import org.eclipse.stardust.model.xpdl.xpdl2.TypeDeclarationType;
import org.eclipse.stardust.model.xpdl.xpdl2.TypeDeclarationsType;
import org.eclipse.stardust.model.xpdl.xpdl2.XpdlTypeType;
import org.eclipse.stardust.model.xpdl.xpdl2.util.TypeDeclarationUtils;
import org.eclipse.xsd.XSDImport;
import org.eclipse.xsd.XSDSchema;
import org.eclipse.xsd.XSDSchemaContent;

public class CreateClosures {
    public List<EObject> computeClosure(EObject eObject, ModelType targetModel) {
        ArrayList<EObject> closure = new ArrayList<EObject>();
        HashSet<EObject> visited = new HashSet<EObject>();
        this.visit(closure, visited, eObject, null, targetModel);
        return closure;
    }

    private boolean isTopLevelElement(EObject element) {
        return element.eContainer() == null || element.eContainer() instanceof ModelType || element instanceof TypeDeclarationType;
    }

    protected boolean alreadyLinked(EObject element, ModelType model) {
        return false;
    }

    private void visit(List<EObject> closure, Set<EObject> visited, EObject element, EReference reference, ModelType targetModel) {
        block11: {
            DataType data;
            block12: {
                XSDSchema schema;
                XpdlTypeType type;
                block13: {
                    if (element == null) {
                        return;
                    }
                    if (element.eContainer() == null) {
                        return;
                    }
                    if (visited.contains(element) || element instanceof ModelType) break block11;
                    visited.add(element);
                    if ((element instanceof IIdentifiableModelElement || element instanceof TypeDeclarationType) && this.isTopLevelElement(element) && !this.alreadyLinked(element, targetModel)) {
                        closure.add(element);
                    }
                    if (!(element instanceof TypeDeclarationType)) break block12;
                    type = ((TypeDeclarationType)element).getDataType();
                    if (!(type instanceof ExternalReferenceType)) break block13;
                    this.visitTypeReference(closure, visited, (TypeDeclarationsType)element.eContainer(), ((ExternalReferenceType)type).getLocation(), targetModel);
                    break block11;
                }
                if (!(type instanceof SchemaTypeType) || (schema = ((SchemaTypeType)type).getSchema()) == null) break block11;
                for (XSDSchemaContent item : schema.getContents()) {
                    if (!(item instanceof XSDImport)) continue;
                    this.visitTypeReference(closure, visited, (TypeDeclarationsType)element.eContainer(), ((XSDImport)item).getSchemaLocation(), targetModel);
                }
                break block11;
            }
            if (element instanceof DataType && (data = (DataType)element).getType() != null && "struct".equals(data.getType().getId())) {
                String typeId = AttributeUtil.getAttributeValue(data, "carnot:engine:dataType");
                TypeDeclarationType decl = ModelUtils.findContainingModel(element).getTypeDeclarations().getTypeDeclaration(typeId);
                if (decl != null) {
                    this.visit(closure, visited, decl, null, targetModel);
                }
            }
            if (element instanceof ProcessDefinitionType) {
                FormalParameterMappingsType formalParameterMappings = ((ProcessDefinitionType)element).getFormalParameterMappings();
                FormalParametersType referencedParametersType = ((ProcessDefinitionType)element).getFormalParameters();
                if (referencedParametersType != null && formalParameterMappings != null) {
                    for (FormalParameterType referencedParameterType : referencedParametersType.getFormalParameter()) {
                        DataType mappedData = formalParameterMappings.getMappedData(referencedParameterType);
                        if (mappedData == null) continue;
                        this.visit(closure, visited, mappedData, null, targetModel);
                    }
                }
            }
            for (EObject child : element.eContents()) {
                this.visit(closure, visited, child, null, targetModel);
            }
            EList crossReferences = element.eCrossReferences();
            EContentsEList.FeatureIterator references = (EContentsEList.FeatureIterator)crossReferences.iterator();
            while (references.hasNext()) {
                EObject target = (EObject)references.next();
                EStructuralFeature ref = references.feature();
                if (ref.isTransient()) continue;
                this.visit(closure, visited, target, reference, targetModel);
            }
        }
    }

    private void visitTypeReference(List<EObject> closure, Set<EObject> visited, TypeDeclarationsType declarations, String location, ModelType targetModel) {
        TypeDeclarationType decl = TypeDeclarationUtils.findTypeDeclarationByLocation(declarations, location);
        this.visit(closure, visited, decl, null, targetModel);
    }
}

