/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.model.xpdl.carnot.util;

import java.io.StringReader;
import java.net.URL;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.TreeMap;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.EMap;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.EObjectImpl;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.xmi.XMLHelper;
import org.eclipse.emf.ecore.xmi.XMLResource;
import org.eclipse.emf.ecore.xmi.impl.SAXXMLHandler;
import org.eclipse.emf.ecore.xmi.impl.XMLHandler;
import org.eclipse.stardust.common.CollectionUtils;
import org.eclipse.stardust.engine.core.model.beans.ModelBean;
import org.eclipse.stardust.model.xpdl.carnot.CarnotWorkflowModelPackage;
import org.eclipse.stardust.model.xpdl.carnot.DocumentRoot;
import org.eclipse.stardust.model.xpdl.carnot.IIdentifiableElement;
import org.eclipse.stardust.model.xpdl.carnot.IModelElement;
import org.eclipse.stardust.model.xpdl.carnot.ModelType;
import org.eclipse.stardust.model.xpdl.carnot.PoolSymbol;
import org.eclipse.stardust.model.xpdl.carnot.ProcessDefinitionType;
import org.eclipse.stardust.model.xpdl.carnot.util.ModelUtils;
import org.eclipse.stardust.model.xpdl.carnot.util.SchemaLocatorAdapter;
import org.eclipse.stardust.model.xpdl.xpdl2.ExtendedAttributeType;
import org.eclipse.stardust.model.xpdl.xpdl2.ExternalPackage;
import org.eclipse.stardust.model.xpdl.xpdl2.ExternalPackages;
import org.eclipse.stardust.model.xpdl.xpdl2.SchemaTypeType;
import org.eclipse.stardust.model.xpdl.xpdl2.XpdlPackage;
import org.eclipse.stardust.model.xpdl.xpdl2.extensions.ExtendedAnnotationType;
import org.eclipse.stardust.model.xpdl.xpdl2.extensions.ExtensionFactory;
import org.eclipse.xsd.XSDSchema;
import org.eclipse.xsd.util.XSDParser;
import org.w3c.dom.Element;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class CwmXmlHandler
extends SAXXMLHandler {
    private static final CarnotWorkflowModelPackage CWM_PKG = CarnotWorkflowModelPackage.eINSTANCE;
    private static final XpdlPackage XPDL_PKG = XpdlPackage.eINSTANCE;
    private static final String[] SCHEMA_KEYWORDS_45 = new String[]{"complexType", "element", "enumeration", "restriction", "schema", "sequence", "simpleType"};
    private boolean inSchema = false;
    private MyXSDParser xsdParser = new MyXSDParser();
    private Stack<Map<String, String>> namespaces = new Stack();
    private Map<String, String> current = null;
    private int schemaElementCount = 0;

    private boolean isSchemaKeyword45(String name) {
        return Arrays.binarySearch(SCHEMA_KEYWORDS_45, name) >= 0;
    }

    public CwmXmlHandler(XMLResource xmiResource, XMLHelper helper, Map<?, ?> options) {
        super(xmiResource, helper, options);
        this.hrefAttribute = "proxy";
        xmiResource.eAdapters().add((Object)new SchemaLocatorAdapter());
    }

    protected EPackage getPackageForURI(String uriString) {
        EPackage ePackage = super.getPackageForURI(uriString);
        return ePackage == null ? CarnotWorkflowModelPackage.eINSTANCE : ePackage;
    }

    protected void setValueFromId(EObject object, EReference eReference, String ids) {
        if (eReference.getEType() instanceof EClass && CWM_PKG.getIIdentifiableElement().isSuperTypeOf((EClass)eReference.getEType()) && eReference.getEAnnotation("http://www.carnot.ag/workflow/model/ElementIdRef") != null) {
            boolean mustAdd = this.deferIDREFResolution;
            int size = 0;
            int position = 0;
            String id = ids;
            if (!this.deferIDREFResolution) {
                EReference eOpposite = eReference.getEOpposite();
                boolean bl = mustAdd = eOpposite == null || eOpposite.isTransient() || eReference.isMany();
            }
            if (mustAdd) {
                if (size == this.capacity) {
                    this.growArrays();
                }
                this.identifiers[size] = id;
                this.positions[size] = position;
                ++size;
            }
            ++position;
            if (size <= 5) {
                int i = 0;
                while (i < size) {
                    XMLHandler.SingleReference ref = new XMLHandler.SingleReference(object, (EStructuralFeature)eReference, this.identifiers[i], this.positions[i], this.getLineNumber(), this.getColumnNumber());
                    this.forwardSingleReferences.add(ref);
                    ++i;
                }
            }
        } else {
            super.setValueFromId(object, eReference, ids);
        }
    }

    protected void handleForwardReferences(boolean isEndDocument) {
        if (isEndDocument) {
            Iterator i = this.forwardSingleReferences.iterator();
            while (i.hasNext()) {
                XMLHandler.SingleReference ref = (XMLHandler.SingleReference)i.next();
                if (!this.doResolveReference(ref)) continue;
                i.remove();
            }
        }
        this.forwardSingleReferences.clear();
        super.handleForwardReferences(isEndDocument);
    }

    protected boolean doResolveReference(XMLHandler.SingleReference ref) {
        EObject obj;
        boolean resolved = false;
        EStructuralFeature feature = ref.getFeature();
        EClassifier eType = feature.getEType();
        if (eType instanceof EClass && (CWM_PKG.getIIdentifiableElement().isSuperTypeOf((EClass)eType) || XPDL_PKG.getExternalPackage().isSuperTypeOf((EClass)eType))) {
            EAnnotation aEIdRef = feature.getEAnnotation("http://www.carnot.ag/workflow/model/ElementIdRef");
            if (aEIdRef != null) {
                PoolSymbol pool;
                String scope = null;
                String refType = null;
                EMap details = aEIdRef.getDetails();
                for (Map.Entry detail : details) {
                    if (scope == null && "scope".equals(detail.getKey())) {
                        scope = (String)detail.getValue();
                    }
                    if (refType != null || !"reftype".equals(detail.getKey())) continue;
                    refType = (String)detail.getValue();
                }
                EObject resolvedTarget = null;
                if ("process".equals(scope)) {
                    ProcessDefinitionType proc = ModelUtils.findContainingProcess(ref.getObject());
                    if (proc != null) {
                        resolvedTarget = CwmXmlHandler.resolveReferenceByElementId(ref, null, (List<? extends EObject>)proc.eContents(), refType);
                    }
                } else if ("model".equals(scope)) {
                    ModelType model = ModelUtils.findContainingModel(ref.getObject());
                    String refId = ref.getValue().toString();
                    if (model != null) {
                        EList<ExternalPackage> candidates = null;
                        if (CWM_PKG.getIdRef_PackageRef() == feature) {
                            ExternalPackages packages = model.getExternalPackages();
                            if (packages != null) {
                                candidates = packages.getExternalPackage();
                            }
                        } else {
                            candidates = model.eContents();
                        }
                        if (candidates != null) {
                            resolvedTarget = CwmXmlHandler.resolveReferenceByElementId(ref, refId, candidates, refType);
                        }
                    }
                } else if ("pool".equals(scope) && (pool = ModelUtils.findContainingPool(ref.getObject())) != null) {
                    resolvedTarget = ref.getValue().equals(CwmXmlHandler.getId(pool, refType)) ? pool : CwmXmlHandler.resolveReferenceByElementId(ref, null, (List<? extends EObject>)pool.eContents(), refType);
                }
                if (resolvedTarget != null) {
                    this.setFeatureValue(ref.getObject(), feature, resolvedTarget, ref.getPosition());
                    resolved = true;
                }
            }
        } else if (eType instanceof EClass && CWM_PKG.getIModelElement().isSuperTypeOf((EClass)eType) && (obj = this.xmlResource.getEObject((String)ref.getValue())) != null) {
            this.setFeatureValue(ref.getObject(), feature, obj, ref.getPosition());
            resolved = true;
        }
        return resolved;
    }

    protected static EObject resolveReferenceByElementId(XMLHandler.SingleReference ref, String refId, List<? extends EObject> candidates, String refType) {
        EObject result = null;
        if (refId == null) {
            refId = ref.getValue().toString();
        }
        for (EObject eObject : candidates) {
            if (!ref.getFeature().getEType().isInstance((Object)eObject) || !refId.equals(CwmXmlHandler.getId(eObject, refType))) continue;
            result = eObject;
            break;
        }
        return result;
    }

    private static String getId(EObject content, String refType) {
        String id = null;
        if (content instanceof ExternalPackage) {
            id = ((ExternalPackage)content).getId();
        } else if (refType == null || "id".equals(refType)) {
            id = ((IIdentifiableElement)content).getId();
        } else if (content instanceof IModelElement && "oid".equals(refType)) {
            id = Long.toString(((IModelElement)content).getElementOid());
        } else if (content.eIsProxy()) {
            id = ((EObjectImpl)content).eProxyURI().toString();
        }
        return id;
    }

    protected void handleObjectAttribs(EObject obj) {
        IModelElement element;
        super.handleObjectAttribs(obj);
        if (obj instanceof IModelElement && (element = (IModelElement)obj).isSetElementOid()) {
            this.xmlResource.setID(obj, Long.toString(element.getElementOid()));
        }
    }

    public void startPrefixMapping(String prefix, String uri) {
        if (this.current == null) {
            this.current = new TreeMap<String, String>();
        }
        this.current.put(prefix, uri);
    }

    public void startElement(String uri, String localName, String name, Attributes attributes) throws SAXException {
        if (this.isSchemaKeyword45(name) && this.isXpdlNamespace(uri)) {
            uri = "http://www.w3.org/2001/XMLSchema";
        }
        if (this.current != null && !this.inSchema && !this.isSchemaElement(uri)) {
            for (Map.Entry<String, String> entry : this.current.entrySet()) {
                super.startPrefixMapping(entry.getKey(), entry.getValue());
            }
        }
        super.startElement(uri, localName, name, attributes);
    }

    public void startElement(String uri, String localName, String name) {
        this.namespaces.push(this.current == null ? CollectionUtils.newMap() : this.current);
        if (!this.inSchema && this.isSchemaElement(uri)) {
            this.startXsdDocument();
        }
        if (this.inSchema) {
            ++this.schemaElementCount;
            this.elements.push((Object)name);
            try {
                this.xsdParser.startElement(uri, localName, name, this.attribs);
                if (this.current != null) {
                    for (Map.Entry<String, String> entry : this.current.entrySet()) {
                        String key = entry.getKey();
                        this.xsdParser.declareNamespace(entry.getValue(), key);
                    }
                }
                this.declareNamespaceForQName(name, uri);
                int i = 0;
                int l = this.attribs.getLength();
                while (i < l) {
                    this.declareNamespaceForQName(this.attribs.getQName(i), this.attribs.getURI(i));
                    ++i;
                }
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        } else {
            super.startElement(uri, localName, name);
        }
        this.current = null;
    }

    private void declareNamespaceForQName(String qname, String uri) {
        if (!uri.isEmpty()) {
            String prefix = this.getPrefix(qname);
            int i = this.namespaces.size() - 1;
            int l = this.schemaElementCount;
            while (i >= 0) {
                Map ns = (Map)this.namespaces.get(i);
                if (ns.containsKey(prefix)) {
                    if (l > 0) break;
                    this.xsdParser.declareNamespace(uri, prefix);
                    break;
                }
                --i;
                --l;
            }
        }
    }

    private void startXsdDocument() {
        this.inSchema = true;
        this.xsdParser.startDocument();
    }

    private String getPrefix(String name) {
        int ix = name.indexOf(58);
        return ix < 0 ? "" : name.substring(0, ix);
    }

    private boolean isSchemaElement(String uri) {
        return "http://www.w3.org/2001/XMLSchema".equals(uri);
    }

    private boolean isXpdlNamespace(String uri) {
        return "http://www.wfmc.org/2008/XPDL2.1".equals(uri);
    }

    public void endPrefixMapping(String prefix) {
    }

    public void endElement(String uri, String localName, String name) {
        block10: {
            if (this.isSchemaKeyword45(name) && this.isXpdlNamespace(uri)) {
                uri = "http://www.w3.org/2001/XMLSchema";
            }
            Map<String, String> expired = this.namespaces.pop();
            if (this.inSchema) {
                --this.schemaElementCount;
                this.elements.pop();
                try {
                    this.xsdParser.endElement(uri, localName, name);
                    if (this.schemaElementCount != 0) break block10;
                    this.inSchema = false;
                    this.xsdParser.endDocument();
                    Object peek = this.objects.peek();
                    if (peek instanceof SchemaTypeType) {
                        XSDSchema schema = this.xsdParser.getSchema();
                        ((InternalEObject)schema).eSetResource((Resource.Internal)this.xmlResource, null);
                        ((SchemaTypeType)peek).setSchema(schema);
                    } else if (peek instanceof ExtendedAttributeType && "carnot:engine:resource:mapping:annotations".equals(((ExtendedAttributeType)peek).getName())) {
                        ExtendedAnnotationType annotation = ExtensionFactory.eINSTANCE.createExtendedAnnotationType();
                        annotation.getSchema().updateElement();
                        Element source = this.xsdParser.getDocument().getDocumentElement();
                        Element imported = (Element)annotation.getSchema().getDocument().importNode(source, true);
                        annotation.getSchema().getElement().appendChild(imported);
                        annotation.setElement(imported);
                        ((ExtendedAttributeType)peek).setExtendedAnnotation(annotation);
                        ((ExtendedAttributeType)peek).getMixed().clear();
                        ((ExtendedAttributeType)peek).getGroup().clear();
                        ((ExtendedAttributeType)peek).getAny().clear();
                    }
                }
                catch (Throwable e) {
                    e.printStackTrace();
                }
            } else {
                super.endElement(uri, localName, name);
                if (!this.inSchema) {
                    for (String entry : expired.keySet()) {
                        super.endPrefixMapping(entry);
                    }
                }
            }
        }
    }

    public void startEntity(String name) {
        if (this.inSchema) {
            this.xsdParser.startEntity(name);
        } else {
            super.startEntity(name);
        }
    }

    public void endEntity(String name) {
        if (this.inSchema) {
            this.xsdParser.endEntity(name);
        } else {
            super.endEntity(name);
        }
    }

    public void comment(char[] ch, int start, int length) {
        if (this.inSchema) {
            try {
                this.xsdParser.comment(ch, start, length);
            }
            catch (SAXException e) {
                e.printStackTrace();
            }
        } else {
            super.comment(ch, start, length);
        }
    }

    public void startCDATA() {
        if (this.inSchema) {
            this.xsdParser.startCDATA();
        } else {
            super.startCDATA();
        }
    }

    public void endCDATA() {
        if (this.inSchema) {
            this.xsdParser.endCDATA();
        } else {
            super.endCDATA();
        }
    }

    public InputSource resolveEntity(String publicId, String systemId) throws SAXException {
        if (systemId != null) {
            if ("http://www.carnot.ag/workflowmodel/3.0/WorkflowModel.dtd".equals(systemId) || "http://www.carnot.ag/workflowmodel/3.1/WorkflowModel.dtd".equals(systemId) || systemId.endsWith("WorkflowModel.dtd")) {
                return new InputSource(new StringReader(""));
            }
            if ("http://www.carnot.ag/workflowmodel/3.1/WorkflowModel.xsd".equals(systemId) || systemId.endsWith("WorkflowModel.xsd")) {
                try {
                    URL xsdUrl = ModelBean.class.getResource("WorkflowModel.xsd");
                    if (xsdUrl != null) {
                        return new InputSource(xsdUrl.openStream());
                    }
                }
                catch (Exception exception) {}
            }
        }
        return this.inSchema ? this.xsdParser.resolveEntity(publicId, systemId) : super.resolveEntity(publicId, systemId);
    }

    public void processingInstruction(String target, String data) {
        if (this.inSchema) {
            this.xsdParser.processingInstruction(target, data);
        } else {
            super.processingInstruction(target, data);
        }
    }

    public void characters(char[] ch, int start, int length) {
        if (this.inSchema) {
            try {
                this.xsdParser.characters(ch, start, length);
            }
            catch (SAXException e) {
                e.printStackTrace();
            }
        } else {
            super.characters(ch, start, length);
        }
    }

    public ModelType getModel(Resource resource) {
        ModelType model = null;
        EList l = resource.getContents();
        for (EObject o : l) {
            if (!(o instanceof DocumentRoot)) continue;
            model = ((DocumentRoot)o).getModel();
        }
        if (model != null) {
            ModelUtils.resolve(model, model);
        }
        return model;
    }

    class MyXSDParser
    extends XSDParser {
        public MyXSDParser() {
            super(null);
        }

        public void characters(char[] ch, int start, int length) throws SAXException {
            if (ch != null && start >= 0 && length > 0 && ch.length >= start + length) {
                try {
                    while (start < length && Character.isWhitespace(ch[start])) {
                        ++start;
                        --length;
                    }
                    while (length > 0 && Character.isWhitespace(ch[start + length - 1])) {
                        --length;
                    }
                    if (length > 0) {
                        super.characters(ch, start, length);
                    }
                }
                catch (Throwable e) {
                    e.printStackTrace();
                }
            }
        }

        public void declareNamespace(String uri, String prefix) {
            String attributeURI = "http://www.w3.org/2000/xmlns/";
            String attributeQName = "xmlns";
            if (prefix.length() > 0) {
                attributeQName = String.valueOf(attributeQName) + ':' + prefix;
            }
            String attributeValue = uri;
            this.element.setAttributeNS(attributeURI, attributeQName, attributeValue);
        }
    }
}

