/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.model.xpdl.carnot.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.EObjectImpl;
import org.eclipse.stardust.common.CollectionUtils;
import org.eclipse.stardust.common.log.LogManager;
import org.eclipse.stardust.common.log.Logger;
import org.eclipse.stardust.model.xpdl.carnot.ConditionalPerformerType;
import org.eclipse.stardust.model.xpdl.carnot.DataType;
import org.eclipse.stardust.model.xpdl.carnot.IIdentifiableModelElement;
import org.eclipse.stardust.model.xpdl.carnot.IModelParticipant;
import org.eclipse.stardust.model.xpdl.carnot.IdRefOwner;
import org.eclipse.stardust.model.xpdl.carnot.ModelType;
import org.eclipse.stardust.model.xpdl.carnot.OrganizationType;
import org.eclipse.stardust.model.xpdl.carnot.RoleType;
import org.eclipse.stardust.model.xpdl.carnot.util.ModelUtils;
import org.eclipse.stardust.model.xpdl.carnot.util.connectionhandler.EObjectProxyHandler;
import org.eclipse.stardust.model.xpdl.carnot.util.connectionhandler.IdRefHandler;
import org.eclipse.stardust.model.xpdl.xpdl2.ExternalPackage;
import org.eclipse.stardust.model.xpdl.xpdl2.util.ExtendedAttributeUtil;

public class WorkspaceManager {
    private static final Logger trace = LogManager.getLogger(WorkspaceManager.class);
    private static WorkspaceManager INSTANCE;
    private static Map<String, ModelType> models;

    private WorkspaceManager() {
    }

    public static WorkspaceManager getInstance() {
        if (INSTANCE == null) {
            models = new HashMap<String, ModelType>();
            INSTANCE = new WorkspaceManager();
        }
        return INSTANCE;
    }

    public ModelType getModel(URI uri) {
        uri = this.createPlatformURI(uri);
        ModelType modelType = models.get(uri.toString());
        trace.info((Object)("get " + uri.toString() + " / " + modelType));
        return modelType;
    }

    public EObject findElement(EObject element) {
        URI eProxyURI;
        ModelType model = ModelUtils.findContainingModel(element);
        if (model != null && model.getExternalPackages() != null && element.eIsProxy() && (eProxyURI = ((InternalEObject)element).eProxyURI()) != null) {
            String id = eProxyURI.toString();
            for (ExternalPackage pkg : model.getExternalPackages().getExternalPackage()) {
                String path;
                int ix;
                ModelType externalModel;
                String pkgConnectionUri = ExtendedAttributeUtil.getAttributeValue(pkg, "carnot:connection:uri");
                if (!id.startsWith(pkgConnectionUri) || (externalModel = ModelUtils.getExternalModel(pkg)) == null || (ix = (path = id.substring(pkgConnectionUri.length())).indexOf(47)) <= 0) continue;
                String type = path.substring(0, ix);
                String elementId = path.substring(ix + 1);
                String elementUuuid = null;
                if (elementId.contains("?uuid=")) {
                    int idx = elementId.indexOf("?uuid=");
                    elementUuuid = elementId.substring(idx + 6);
                    elementId = elementId.substring(0, idx);
                }
                if (type.equals("data")) {
                    for (DataType data : externalModel.getData()) {
                        String uuid = ModelUtils.getUUID(data);
                        if (!(uuid != null && elementUuuid != null ? uuid.equals(elementUuuid) : elementId.equals(data.getId()))) continue;
                        return data;
                    }
                    continue;
                }
                if (type.equals("role") || type.equals("organization") || type.equals("conditionalPerformer")) {
                    ArrayList participants = CollectionUtils.newArrayList();
                    if (type.equals("role")) {
                        EList<RoleType> roles = externalModel.getRole();
                        participants.addAll(roles);
                    } else if (type.equals("organization")) {
                        EList<OrganizationType> organizations = externalModel.getOrganization();
                        participants.addAll(organizations);
                    } else if (type.equals("conditionalPerformer")) {
                        EList<ConditionalPerformerType> conditionalPerformers = externalModel.getConditionalPerformer();
                        participants.addAll(conditionalPerformers);
                    }
                    for (IModelParticipant participant : participants) {
                        String uuid = ModelUtils.getUUID(participant);
                        if (!(uuid != null && elementUuuid != null ? uuid.equals(elementUuuid) : elementId.equals(participant.getId()))) continue;
                        return participant;
                    }
                    continue;
                }
                System.err.println("type " + type);
            }
        }
        return null;
    }

    public void resolve(ModelType model) {
        TreeIterator i = model.eAllContents();
        while (i.hasNext()) {
            EObject object = (EObject)i.next();
            if (object.eIsProxy()) {
                if (!(object instanceof EObjectImpl)) continue;
                try {
                    this.resolve(object);
                }
                catch (Throwable throwable) {}
                continue;
            }
            if (!(object instanceof IdRefOwner) && !(object instanceof DataType)) continue;
            IdRefHandler.adapt((IIdentifiableModelElement)object);
        }
    }

    private void resolve(EObject object) {
        EObject target = this.findElement(object);
        if (target != null) {
            EObjectProxyHandler.createProxy(object, target);
        }
    }

    public void addModel(URI uri, ModelType model) {
        uri = this.createPlatformURI(uri);
        models.put(uri.toString(), model);
        trace.info((Object)("add " + uri.toString() + " / " + model));
    }

    private URI createPlatformURI(URI uri) {
        return uri;
    }

    public boolean usesModel(ModelType toCheck) {
        for (ModelType model : models.values()) {
            if (model.equals(toCheck) || model == null || model.getExternalPackages() == null) continue;
            for (ExternalPackage pkg : model.getExternalPackages().getExternalPackage()) {
                ModelType externalModel = ModelUtils.getExternalModel(pkg);
                if (!externalModel.equals(toCheck)) continue;
                return true;
            }
        }
        return false;
    }

    public void cleanCache(ModelType workflowModel) {
        this.usesModel(workflowModel);
    }
}

