/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.model.xpdl.xpdl2.util;

import java.util.Collection;
import java.util.Collections;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.FeatureMap;
import org.eclipse.emf.ecore.xml.type.XMLTypePackage;
import org.eclipse.stardust.model.xpdl.xpdl2.ExpressionType;
import org.eclipse.stardust.model.xpdl.xpdl2.LoopMultiInstanceType;
import org.eclipse.stardust.model.xpdl.xpdl2.LoopStandardType;
import org.eclipse.stardust.model.xpdl.xpdl2.LoopType;
import org.eclipse.stardust.model.xpdl.xpdl2.LoopTypeType;
import org.eclipse.stardust.model.xpdl.xpdl2.XpdlFactory;

public class XpdlUtil {
    public static LoopStandardType getOrCreateLoopStandard(LoopType loop) {
        if (loop == null) {
            loop = XpdlFactory.eINSTANCE.createLoopType();
        }
        loop.setLoopType(LoopTypeType.STANDARD);
        LoopStandardType loopStandard = loop.getLoopStandard();
        if (loopStandard == null) {
            loopStandard = XpdlFactory.eINSTANCE.createLoopStandardType();
            loop.setLoopStandard(loopStandard);
            loop.setLoopMultiInstance(null);
        }
        return loopStandard;
    }

    public static LoopMultiInstanceType getOrCreateLoopMulti(LoopType loop) {
        if (loop == null) {
            loop = XpdlFactory.eINSTANCE.createLoopType();
        }
        loop.setLoopType(LoopTypeType.MULTI_INSTANCE);
        LoopMultiInstanceType loopMulti = loop.getLoopMultiInstance();
        if (loopMulti == null) {
            loopMulti = XpdlFactory.eINSTANCE.createLoopMultiInstanceType();
            loop.setLoopMultiInstance(loopMulti);
            loop.setLoopStandard(null);
        }
        return loopMulti;
    }

    public static String getText(FeatureMap featureMap, boolean preferCDATA) {
        EAttribute feature = preferCDATA ? XMLTypePackage.eINSTANCE.getXMLTypeDocumentRoot_CDATA() : XMLTypePackage.eINSTANCE.getXMLTypeDocumentRoot_Text();
        Collection parts = (Collection)featureMap.get((EStructuralFeature)feature, false);
        if (parts == null || parts.isEmpty()) {
            EAttribute fallbackFeature = preferCDATA ? XMLTypePackage.eINSTANCE.getXMLTypeDocumentRoot_Text() : XMLTypePackage.eINSTANCE.getXMLTypeDocumentRoot_CDATA();
            parts = (Collection)featureMap.get((EStructuralFeature)fallbackFeature, false);
        }
        String result = null;
        if (parts != null && !parts.isEmpty()) {
            if (parts.size() == 1) {
                result = parts.iterator().next().toString();
            } else {
                StringBuffer sb = new StringBuffer();
                for (Object o : parts) {
                    sb.append(o.toString());
                }
                result = sb.toString();
            }
        }
        return result;
    }

    public static void setText(FeatureMap mixed, String text, boolean preferCDATA) {
        EAttribute feature;
        EAttribute excludedFeature;
        EAttribute eAttribute = excludedFeature = preferCDATA ? XMLTypePackage.eINSTANCE.getXMLTypeDocumentRoot_Text() : XMLTypePackage.eINSTANCE.getXMLTypeDocumentRoot_CDATA();
        if (mixed.isSet((EStructuralFeature)excludedFeature)) {
            mixed.unset((EStructuralFeature)excludedFeature);
        }
        EAttribute eAttribute2 = feature = preferCDATA ? XMLTypePackage.eINSTANCE.getXMLTypeDocumentRoot_CDATA() : XMLTypePackage.eINSTANCE.getXMLTypeDocumentRoot_Text();
        if (text == null) {
            mixed.unset((EStructuralFeature)feature);
        } else {
            mixed.set((EStructuralFeature)feature, Collections.singleton(text));
        }
    }

    public static String getLoopStandardCondition(LoopType loop) {
        LoopStandardType loopStandard;
        if (loop != null && loop.getLoopType() == LoopTypeType.STANDARD && (loopStandard = loop.getLoopStandard()) != null) {
            return XpdlUtil.getLoopStandardCondition(loopStandard);
        }
        return null;
    }

    public static String getLoopStandardCondition(LoopStandardType loopStandard) {
        ExpressionType expression = loopStandard.getLoopCondition();
        if (expression == null) {
            return null;
        }
        return XpdlUtil.getText(expression.getMixed(), false);
    }

    public static void setLoopStandardCondition(LoopStandardType loopStandard, String condition) {
        ExpressionType expression = loopStandard.getLoopCondition();
        if (expression == null) {
            expression = XpdlFactory.eINSTANCE.createExpressionType();
            loopStandard.setLoopCondition(expression);
        }
        XpdlUtil.setText(expression.getMixed(), condition, false);
    }
}

