/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.model.xpdl.xpdl2.util;

import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.stardust.common.CollectionUtils;
import org.eclipse.xsd.XSDAttributeGroupContent;
import org.eclipse.xsd.XSDAttributeGroupDefinition;
import org.eclipse.xsd.XSDAttributeUse;
import org.eclipse.xsd.XSDComplexTypeContent;
import org.eclipse.xsd.XSDComplexTypeDefinition;
import org.eclipse.xsd.XSDComponent;
import org.eclipse.xsd.XSDConstrainingFacet;
import org.eclipse.xsd.XSDElementDeclaration;
import org.eclipse.xsd.XSDModelGroup;
import org.eclipse.xsd.XSDModelGroupDefinition;
import org.eclipse.xsd.XSDNamedComponent;
import org.eclipse.xsd.XSDParticle;
import org.eclipse.xsd.XSDParticleContent;
import org.eclipse.xsd.XSDSchema;
import org.eclipse.xsd.XSDSimpleTypeDefinition;
import org.eclipse.xsd.XSDTerm;
import org.eclipse.xsd.XSDTypeDefinition;
import org.eclipse.xsd.XSDWildcard;
import org.eclipse.xsd.util.XSDConstants;
import org.eclipse.xsd.util.XSDSwitch;

public class XsdContentProvider
extends XSDSwitch<EObject[]> {
    protected boolean showDirectContentOnly;
    public static EObject[] EMPTY_ARRAY = new EObject[0];

    public XsdContentProvider() {
        this(false);
    }

    public XsdContentProvider(boolean showDirectContentOnly) {
        this.showDirectContentOnly = showDirectContentOnly;
    }

    public EObject[] caseXSDSchema(XSDSchema schema) {
        String targetNamespace = schema.getTargetNamespace();
        if (targetNamespace == null) {
            targetNamespace = "";
        }
        List all = null;
        EList elements = schema.getElementDeclarations();
        EList types = schema.getTypeDefinitions();
        all = CollectionUtils.newList((int)(elements.size() + types.size()));
        this.addElements(all, targetNamespace, (List<? extends XSDNamedComponent>)elements);
        this.addElements(all, targetNamespace, (List<? extends XSDNamedComponent>)types);
        return all.toArray(new EObject[all.size()]);
    }

    private void addElements(List<XSDNamedComponent> targetList, String targetNamespace, List<? extends XSDNamedComponent> sourceList) {
        for (XSDNamedComponent xSDNamedComponent : sourceList) {
            String namespace = xSDNamedComponent.getTargetNamespace();
            if (!targetNamespace.equals(namespace == null ? "" : namespace)) continue;
            targetList.add(xSDNamedComponent);
        }
    }

    public EObject[] caseXSDElementDeclaration(XSDElementDeclaration element) {
        XSDTypeDefinition type;
        if (!this.showDirectContentOnly && element.isElementDeclarationReference()) {
            element = element.getResolvedElementDeclaration();
        }
        if ((type = element.getAnonymousTypeDefinition()) == null && !this.showDirectContentOnly) {
            type = element.getTypeDefinition();
        }
        return type == null ? new EObject[]{} : (EObject[])this.doSwitch((EObject)type);
    }

    public EObject[] caseXSDComplexTypeDefinition(XSDComplexTypeDefinition type) {
        XSDTypeDefinition base = type.getBaseType();
        EObject[] resultArray3 = null;
        int cnt = 0;
        EObject[] content = EMPTY_ARRAY;
        XSDComplexTypeContent typeContent = type.getContent();
        if (typeContent != null) {
            content = (EObject[])this.doSwitch((EObject)typeContent);
        }
        List result = CollectionUtils.newList();
        XSDWildcard wildcard = type.getAttributeWildcardContent();
        EList attributes = type.getAttributeContents();
        if (typeContent instanceof XSDSimpleTypeDefinition && !attributes.isEmpty()) {
            result.add(typeContent);
        }
        this.addAttributes(result, (List<XSDAttributeGroupContent>)attributes);
        if (wildcard != null) {
            result.add(wildcard);
        }
        cnt = result.size() + content.length;
        EObject[] resultArray = new EObject[result.size() + content.length];
        result.toArray(resultArray);
        System.arraycopy(content, 0, resultArray, result.size(), content.length);
        EObject[] resultArray2 = null;
        if (base != null && base instanceof XSDComplexTypeDefinition && !XSDConstants.isAnyType((XSDTypeDefinition)base)) {
            EObject[] baseContent = EMPTY_ARRAY;
            baseContent = (EObject[])this.doSwitch((EObject)base);
            cnt += baseContent.length;
            resultArray2 = new EObject[baseContent.length];
            result.toArray(resultArray2);
            System.arraycopy(baseContent, 0, resultArray2, 0, baseContent.length);
        }
        resultArray3 = new EObject[cnt];
        if (resultArray2 != null) {
            System.arraycopy(resultArray2, 0, resultArray3, 0, resultArray2.length);
            System.arraycopy(resultArray, 0, resultArray3, resultArray2.length, resultArray.length);
        } else {
            System.arraycopy(resultArray, 0, resultArray3, 0, resultArray.length);
        }
        return resultArray3;
    }

    private void addAttributes(List<XSDComponent> result, List<XSDAttributeGroupContent> attributes) {
        for (XSDAttributeGroupContent attribute : attributes) {
            if (attribute instanceof XSDAttributeUse) {
                result.add((XSDComponent)((XSDAttributeUse)attribute).getContent());
                continue;
            }
            if (!(attribute instanceof XSDAttributeGroupDefinition)) continue;
            XSDAttributeGroupDefinition group = (XSDAttributeGroupDefinition)attribute;
            if (group.isAttributeGroupDefinitionReference()) {
                group = group.getResolvedAttributeGroupDefinition();
            }
            this.addAttributes(result, (List<XSDAttributeGroupContent>)group.getContents());
        }
    }

    public EObject[] caseXSDSimpleTypeDefinition(XSDSimpleTypeDefinition type) {
        EList elements = type.getEnumerationFacets();
        if (elements.isEmpty()) {
            elements = type.getPatternFacets();
        }
        XSDConstrainingFacet newElement = (XSDConstrainingFacet)this.getNewItem((XSDComponent)type);
        int size = elements.size();
        if (newElement != null) {
            ++size;
        }
        EObject[] result = new EObject[size];
        int i = 0;
        while (i < elements.size()) {
            result[i] = (EObject)elements.get(i);
            ++i;
        }
        if (newElement != null) {
            result[result.length - 1] = newElement;
        }
        return result;
    }

    protected <T> T getNewItem(XSDComponent parent) {
        return null;
    }

    public EObject[] caseXSDModelGroup(XSDModelGroup model) {
        List result = CollectionUtils.newList();
        EList particles = model.getContents();
        this.addModelGroupContent(result, (List<XSDParticle>)particles);
        XSDTerm newElement = (XSDTerm)this.getNewItem((XSDComponent)model);
        if (newElement != null) {
            result.add(newElement);
        }
        return result.toArray(new EObject[result.size()]);
    }

    private void addModelGroupContent(List<Object> result, List<XSDParticle> particles) {
        for (XSDParticle particle : particles) {
            XSDParticleContent content = particle.getContent();
            if (content instanceof XSDModelGroupDefinition) {
                XSDModelGroupDefinition group = (XSDModelGroupDefinition)content;
                if (group.isModelGroupDefinitionReference()) {
                    group = group.getResolvedModelGroupDefinition();
                }
                EObject[] children = this.caseXSDModelGroup(group.getModelGroup());
                int j = 0;
                while (j < children.length) {
                    result.add(children[j]);
                    ++j;
                }
                continue;
            }
            result.add(content);
        }
    }

    public EObject[] caseXSDParticle(XSDParticle particle) {
        XSDParticleContent content = particle.getContent();
        if (content instanceof XSDModelGroupDefinition) {
            XSDModelGroupDefinition group = (XSDModelGroupDefinition)content;
            if (group.isModelGroupDefinitionReference()) {
                group = group.getResolvedModelGroupDefinition();
            }
            return new EObject[]{group.getModelGroup()};
        }
        return new EObject[]{particle.getContent()};
    }

    public EObject[] defaultCase(EObject object) {
        return EMPTY_ARRAY;
    }
}

