/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.audittrail;

import java.util.List;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.stardust.common.CollectionUtils;
import org.eclipse.stardust.modeling.audittrail.IAuditTrailDbListener;
import org.osgi.framework.BundleContext;

public class AuditTrailActivator
extends Plugin {
    private final List<IAuditTrailDbListener> dbListeners = CollectionUtils.newList();
    private static AuditTrailActivator instance = null;

    public static AuditTrailActivator instance() {
        return instance;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        instance = this;
    }

    public void stop(BundleContext context) throws Exception {
        super.stop(context);
        instance = null;
    }

    public void addDbListener(IAuditTrailDbListener listener) {
        if (!this.dbListeners.contains(listener)) {
            this.dbListeners.add(listener);
        }
    }

    public void removeDbListener(IAuditTrailDbListener listener) {
        this.dbListeners.remove(listener);
    }

    protected void notifyDbListeners(IFolder dbFolder, int change) {
        if (!this.dbListeners.isEmpty()) {
            IAuditTrailDbListener[] listeners = this.dbListeners.toArray(new IAuditTrailDbListener[0]);
            int i = 0;
            while (i < listeners.length) {
                listeners[i].onAuditTrailDbChanged(dbFolder, change);
                ++i;
            }
        }
    }
}

