/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.audittrail;

import java.io.File;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import javax.sql.DataSource;
import org.apache.derby.jdbc.EmbeddedDataSource;
import org.eclipse.stardust.common.error.PublicException;
import org.eclipse.stardust.engine.core.persistence.jdbc.QueryUtils;
import org.eclipse.stardust.modeling.audittrail.SqlTemplate;

public class EmbeddedDerbyTemplate {
    private final SqlTemplate sqlTemplate;

    public EmbeddedDerbyTemplate() {
        this.sqlTemplate = null;
    }

    public EmbeddedDerbyTemplate(SqlTemplate sqlTemplate) {
        this.sqlTemplate = sqlTemplate;
    }

    public Object performOperation(File dbSystemHome, String dbName, String schemaName) {
        return this.performOperation(dbSystemHome, dbName, schemaName, false);
    }

    public Object performOperation(File dbSystemHome, String dbName, String schemaName, boolean createDb) {
        Object result = null;
        try {
            try {
                System.setProperty("derby.system.home", dbSystemHome.getAbsolutePath());
                EmbeddedDataSource dataSource = new EmbeddedDataSource();
                dataSource.setDatabaseName(dbName);
                dataSource.setUser(schemaName);
                if (createDb) {
                    dataSource.setCreateDatabase("create");
                }
                try {
                    result = this.performDbOperation((DataSource)dataSource);
                }
                catch (Throwable throwable) {
                    try {
                        dataSource.setShutdownDatabase("shutdown");
                        dataSource.getConnection();
                    }
                    catch (SQLException sQLException) {}
                    try {
                        DriverManager.getConnection("jdbc:derby:;shutdown=true");
                    }
                    catch (SQLException sQLException) {}
                    throw throwable;
                }
                try {
                    dataSource.setShutdownDatabase("shutdown");
                    dataSource.getConnection();
                }
                catch (SQLException sQLException) {}
                try {
                    DriverManager.getConnection("jdbc:derby:;shutdown=true");
                }
                catch (SQLException sQLException) {}
            }
            catch (SQLException e) {
                SQLException nextE = e.getNextException();
                if (nextE != null) {
                    throw new PublicException(nextE.getMessage(), (Throwable)e);
                }
                throw new PublicException((Throwable)e);
            }
            catch (Exception e) {
                throw new PublicException((Throwable)e);
            }
        }
        finally {
            System.getProperties().remove("derby.system.home");
        }
        return result;
    }

    protected Object performDbOperation(DataSource dataSource) throws SQLException {
        Object result = null;
        if (this.sqlTemplate != null) {
            Connection conn = dataSource.getConnection();
            conn.setAutoCommit(false);
            try {
                try {
                    result = this.sqlTemplate.executeSql(conn, null);
                    conn.commit();
                }
                catch (SQLException sQLException) {
                    conn.rollback();
                    QueryUtils.closeConnection((Connection)conn);
                }
            }
            finally {
                QueryUtils.closeConnection((Connection)conn);
            }
        }
        return result;
    }
}

