/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.common.ui.swt;

import org.eclipse.stardust.modeling.common.ui.swt.ObjectTable;
import org.eclipse.swt.custom.TableEditor;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.TableItem;

public abstract class AbstractCellEditor
implements Listener {
    protected TableEditor editor;
    protected ObjectTable objectTable;
    protected int tableColumn;

    public AbstractCellEditor(ObjectTable objectTable, int columnIndex) {
        this.objectTable = objectTable;
        this.tableColumn = columnIndex;
        this.editor = new TableEditor(objectTable.getTable());
        this.editor.horizontalAlignment = 16384;
        this.editor.grabHorizontal = true;
        objectTable.getTable().addListener(3, (Listener)this);
    }

    public void handleEvent(Event event) {
        final Control editorControl = this.createEditorControl();
        Rectangle clientArea = this.objectTable.getTable().getClientArea();
        Point pt = new Point(event.x, event.y);
        int index = this.objectTable.getTable().getTopIndex();
        while (index < this.objectTable.getTable().getItemCount()) {
            boolean visible = false;
            final TableItem item = this.objectTable.getTable().getItem(index);
            int i = 0;
            while (i < this.objectTable.getTable().getColumnCount()) {
                if (i == this.tableColumn) {
                    Rectangle rect = item.getBounds(i);
                    if (rect.contains(pt)) {
                        final int column = i;
                        final int row = index;
                        Listener textListener = new Listener(){

                            /*
                             * Enabled force condition propagation
                             * Lifted jumps to return sites
                             */
                            public void handleEvent(Event e) {
                                block0 : switch (e.type) {
                                    case 16: {
                                        AbstractCellEditor.this.disposeEditorControl(item, editorControl, column);
                                        return;
                                    }
                                    case 31: {
                                        switch (e.detail) {
                                            case 8: 
                                            case 32: {
                                                e.doit = false;
                                                int newRow = row;
                                                int newColumn = column;
                                                if (column - 1 == 0) {
                                                    if (--newRow == -1) return;
                                                    newColumn = AbstractCellEditor.this.objectTable.getTable().getColumnCount() - 1;
                                                } else {
                                                    --newColumn;
                                                }
                                                TableItem newItem = AbstractCellEditor.this.objectTable.getTable().getItem(newRow);
                                                Event event = new Event();
                                                event.x = newItem.getBounds((int)newColumn).x + 1;
                                                event.y = newItem.getBounds((int)newColumn).y + 1;
                                                AbstractCellEditor.this.objectTable.getTable().notifyListeners(3, event);
                                                AbstractCellEditor.this.disposeEditorControl(item, editorControl, column);
                                                e.doit = false;
                                                break block0;
                                            }
                                            case 16: 
                                            case 64: {
                                                int newRow = row;
                                                int newColumn = column;
                                                if (column + 1 == AbstractCellEditor.this.objectTable.getTable().getColumnCount()) {
                                                    if (++newRow == AbstractCellEditor.this.objectTable.getTable().getItemCount()) return;
                                                    newColumn = 1;
                                                } else {
                                                    ++newColumn;
                                                }
                                                TableItem newItem = AbstractCellEditor.this.objectTable.getTable().getItem(newRow);
                                                Event event = new Event();
                                                event.x = newItem.getBounds((int)newColumn).x + 1;
                                                event.y = newItem.getBounds((int)newColumn).y + 1;
                                                AbstractCellEditor.this.objectTable.getTable().notifyListeners(3, event);
                                                AbstractCellEditor.this.disposeEditorControl(item, editorControl, column);
                                                e.doit = false;
                                                break block0;
                                            }
                                            case 4: {
                                                AbstractCellEditor.this.disposeEditorControl(item, editorControl, column);
                                                e.doit = false;
                                                break block0;
                                            }
                                            case 2: {
                                                editorControl.dispose();
                                                e.doit = false;
                                            }
                                        }
                                    }
                                }
                            }
                        };
                        this.activateEditor(editorControl, textListener, item, i, item.getText(i));
                        editorControl.setFocus();
                    }
                    if (!visible && rect.intersects(clientArea)) {
                        visible = true;
                    }
                }
                ++i;
            }
            if (!visible) {
                return;
            }
            ++index;
        }
    }

    private void disposeEditorControl(TableItem item, Control editorControl, int column) {
        if (item.getData() == null) {
            this.objectTable.addObjectViaEditing(this.objectTable.createObject());
        }
        this.objectTable.setValueFromString(item.getData(), column, this.getTextFromEditor(editorControl));
        item.setText(column, this.getTextFromEditor(editorControl));
        editorControl.dispose();
    }

    protected abstract Control createEditorControl();

    protected abstract void activateEditor(Control var1, Listener var2, TableItem var3, int var4, String var5);

    protected abstract Object getValueFromEditor(Control var1);

    protected abstract String getTextFromEditor(Control var1);
}

