/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.core;

import org.eclipse.stardust.modeling.core.Diagram_Messages;
import org.eclipse.stardust.modeling.core.Verifier;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.widgets.Text;

public class DoubleVerifier
implements Verifier {
    private int type;
    private double min;
    private double max;
    private static final String DEFAULT_CURRENCY = Diagram_Messages.DEFAULT_CURRENCY;

    public DoubleVerifier(int format, double minValue, double maxValue) {
        this.type = format;
        this.min = minValue;
        this.max = maxValue;
    }

    public void verifyText(VerifyEvent e) {
        StringBuffer sb = new StringBuffer(((Text)e.widget).getText());
        if (e.character == '\u0000') {
            sb.replace(e.start, e.end, e.text);
        } else if (!Character.isISOControl(e.character)) {
            sb.replace(e.start, e.end, e.text);
        }
        int last = 0;
        int i = 0;
        while (i < sb.length()) {
            char current = sb.charAt(i);
            if (current == symbols.getGroupingSeparator()) {
                sb.setCharAt(i, ',');
            } else if (current == symbols.getDecimalSeparator()) {
                sb.setCharAt(i, '.');
            } else if (current == symbols.getMinusSign()) {
                sb.setCharAt(i, '-');
            } else if (current == 'e') {
                sb.setCharAt(i, 'E');
            }
            last = sb.charAt(i);
            ++i;
        }
        if (last == 0 || last == 45 || last == 46 || last == 69) {
            sb.append(symbols.getZeroDigit());
        }
        double value = 0.0;
        try {
            switch (this.type) {
                case 4: {
                    value = Float.parseFloat(sb.toString());
                    break;
                }
                case 5: {
                    value = Double.parseDouble(sb.toString());
                }
            }
            e.doit = value >= this.min && value <= this.max;
        }
        catch (NumberFormatException numberFormatException) {
            e.doit = false;
        }
    }

    @Override
    public int getType() {
        return this.type;
    }

    @Override
    public String getExternalValue(String value) {
        if (value == null) {
            return value;
        }
        int ix = value.indexOf(32);
        StringBuffer sb = new StringBuffer(ix < 0 ? value : value.substring(0, ix));
        int i = 0;
        while (i < sb.length()) {
            char current = sb.charAt(i);
            if (current == ',') {
                sb.setCharAt(i, symbols.getGroupingSeparator());
            } else if (current == '.') {
                sb.setCharAt(i, symbols.getDecimalSeparator());
            } else if (current == '-') {
                sb.setCharAt(i, symbols.getMinusSign());
            } else if (current == 'e') {
                sb.setCharAt(i, 'E');
            }
            ++i;
        }
        return sb.toString();
    }

    @Override
    public String getInternalValue(String value) {
        if (value == null) {
            return value;
        }
        StringBuffer sb = new StringBuffer(value);
        int i = 0;
        while (i < sb.length()) {
            char current = sb.charAt(i);
            if (current == symbols.getGroupingSeparator()) {
                sb.setCharAt(i, ',');
            } else if (current == symbols.getDecimalSeparator()) {
                sb.setCharAt(i, '.');
            } else if (current == symbols.getMinusSign()) {
                sb.setCharAt(i, '-');
            } else if (current == 'e') {
                sb.setCharAt(i, 'E');
            }
            ++i;
        }
        if (6 == this.type) {
            sb.append(' ');
            sb.append(DEFAULT_CURRENCY);
        }
        return sb.toString();
    }
}

