/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.core;

import org.eclipse.stardust.modeling.core.Verifier;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.widgets.Text;

public class LongVerifier
implements Verifier {
    private int type;
    private long min;
    private long max;

    public LongVerifier(int format, long minValue, long maxValue) {
        this.type = format;
        this.min = minValue;
        this.max = maxValue;
    }

    public void verifyText(VerifyEvent e) {
        StringBuffer sb = new StringBuffer(((Text)e.widget).getText());
        if (e.character == '\u0000') {
            sb.insert(e.start, e.text);
        } else if (!Character.isISOControl(e.character)) {
            sb.insert(e.start, e.text);
        }
        int last = 0;
        int i = 0;
        while (i < sb.length()) {
            char current = sb.charAt(i);
            if (current == symbols.getGroupingSeparator()) {
                sb.setCharAt(i, ',');
            } else if (current == symbols.getMinusSign()) {
                sb.setCharAt(i, '-');
            }
            last = sb.charAt(i);
            ++i;
        }
        if (last == 0 || last == 45) {
            sb.append(symbols.getZeroDigit());
        }
        long value = 0L;
        try {
            switch (this.type) {
                case 0: {
                    value = Byte.parseByte(sb.toString());
                    break;
                }
                case 1: {
                    value = Short.parseShort(sb.toString());
                    break;
                }
                case 2: {
                    value = Integer.parseInt(sb.toString());
                    break;
                }
                case 3: {
                    value = Long.parseLong(sb.toString());
                }
            }
            e.doit = value >= this.min && value <= this.max;
        }
        catch (NumberFormatException numberFormatException) {
            e.doit = false;
        }
    }

    @Override
    public int getType() {
        return this.type;
    }

    @Override
    public String getExternalValue(String value) {
        return value;
    }

    @Override
    public String getInternalValue(String value) {
        return value;
    }
}

