/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.core;

import org.eclipse.stardust.common.StringUtils;
import org.eclipse.stardust.modeling.core.Verifier;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.widgets.Text;

public class OverdueThresholdVerifier
implements Verifier {
    private static final String PATTERN = "###%";
    private static final String DEFAULT_TEXT = StringUtils.replace((String)"###%", (String)"#", (String)" ");
    private final Text text;
    private boolean ignore;

    public OverdueThresholdVerifier(Text text) {
        this.text = text;
        text.setText(DEFAULT_TEXT);
        this.updateCaretPosition(0, false);
        this.ignore = true;
        text.setText(DEFAULT_TEXT);
        this.ignore = false;
    }

    @Override
    public String getExternalValue(String value) {
        if (value == null) {
            return "  0%";
        }
        int c = 0;
        StringBuffer externalValue = new StringBuffer();
        int i = 0;
        while (i < PATTERN.length()) {
            char ch = PATTERN.charAt(i);
            if (c < value.length() && ch == '#' && c != 37) {
                externalValue.append(value.charAt(c));
                ++c;
            } else if (ch != '#') {
                externalValue.append(ch);
            }
            ++i;
        }
        while (externalValue.length() < PATTERN.length()) {
            externalValue.insert(0, ' ');
        }
        return externalValue.toString();
    }

    @Override
    public String getInternalValue(String val) {
        StringBuffer internalValue = new StringBuffer();
        int i = 0;
        while (i < PATTERN.length()) {
            if (PATTERN.charAt(i) == '#' && val.length() > i && val.charAt(i) != '%' && !Character.isWhitespace(val.charAt(i))) {
                internalValue.append(val.charAt(i));
            }
            ++i;
        }
        String value = internalValue.toString().trim();
        String result = StringUtils.isEmpty((String)value) ? "0" : value;
        return result;
    }

    @Override
    public int getType() {
        return 8;
    }

    /*
     * Unable to fully structure code
     */
    private void updateCaretPosition(int caretPosition, boolean backwards) {
        block8: {
            if (caretPosition < 0) {
                caretPosition = 0;
            }
            if (caretPosition > "###%".length()) {
                caretPosition = "###%".length();
            }
            if (!backwards) ** GOTO lbl15
            while (caretPosition > 0 && "###%".charAt(caretPosition) != '#' && "###%".charAt(caretPosition - 1) != '#') {
                --caretPosition;
            }
            if (caretPosition != 0) break block8;
            while (caretPosition < "###%".length() && "###%".charAt(caretPosition) != '#') {
                ++caretPosition;
            }
            break block8;
lbl-1000:
            // 1 sources

            {
                ++caretPosition;
lbl15:
                // 2 sources

                ** while (caretPosition < "###%".length() && "###%".charAt((int)caretPosition) != '#')
            }
        }
        this.text.setSelection(caretPosition);
    }

    public void verifyText(VerifyEvent e) {
        if (this.ignore) {
            return;
        }
        e.doit = false;
        if (e.keyCode == 8 || e.keyCode == 127) {
            this.clearText(e.start, e.end);
            this.updateCaretPosition(e.start, e.keyCode == 8);
        } else {
            if (e.start >= PATTERN.length()) {
                return;
            }
            String editValue = this.text.getText();
            StringBuffer sb = new StringBuffer();
            sb.append(editValue);
            int i = 0;
            int pos = e.start;
            while (i < e.text.length() && pos < PATTERN.length()) {
                char c = e.text.charAt(i);
                if ('#' == PATTERN.charAt(pos)) {
                    if (!Character.isDigit(c) && !Character.isWhitespace(c)) {
                        return;
                    }
                    sb.setCharAt(pos, c);
                }
                ++i;
                ++pos;
            }
            String value = sb.toString();
            int overdueThreshold = Integer.parseInt(this.getInternalValue(value));
            if (overdueThreshold < 1000) {
                this.ignore = true;
                this.text.setText(value);
                this.ignore = false;
                this.updateCaretPosition(e.start + e.text.length(), false);
            }
        }
    }

    private void clearText(int start, int end) {
        this.ignore = true;
        StringBuffer sb = new StringBuffer();
        sb.append(this.text.getText());
        int pos = start;
        while (pos < end && pos < PATTERN.length()) {
            char c = DEFAULT_TEXT.charAt(pos);
            sb.setCharAt(pos, c);
            ++pos;
        }
        this.text.setText(sb.toString());
        this.ignore = false;
    }
}

