/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.core;

import java.awt.Toolkit;
import org.eclipse.stardust.common.Period;
import org.eclipse.stardust.common.StringUtils;
import org.eclipse.stardust.modeling.core.Diagram_Messages;
import org.eclipse.stardust.modeling.core.Verifier;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.widgets.Text;

public class PeriodVerifier
implements Verifier,
FocusListener {
    private static final String PATTERN = Diagram_Messages.PeriodVerifier_PATTERN;
    private static final String DEFAULT_TEXT = StringUtils.replace((String)PATTERN, (String)"#", (String)"0");
    private Text text;
    private boolean ignore;

    public PeriodVerifier(Text text) {
        this.text = text;
        this.ignore = true;
        text.setText(DEFAULT_TEXT);
        this.ignore = false;
        this.updateCaretPosition(0, false);
        text.addFocusListener((FocusListener)this);
    }

    /*
     * Unable to fully structure code
     */
    private void updateCaretPosition(int caretPosition, boolean backwards) {
        block8: {
            if (caretPosition < 0) {
                caretPosition = 0;
            }
            if (caretPosition > PeriodVerifier.PATTERN.length()) {
                caretPosition = PeriodVerifier.PATTERN.length();
            }
            if (!backwards) ** GOTO lbl15
            while (caretPosition > 0 && PeriodVerifier.PATTERN.charAt(caretPosition) != '#' && PeriodVerifier.PATTERN.charAt(caretPosition - 1) != '#') {
                --caretPosition;
            }
            if (caretPosition != 0) break block8;
            while (caretPosition < PeriodVerifier.PATTERN.length() && PeriodVerifier.PATTERN.charAt(caretPosition) != '#') {
                ++caretPosition;
            }
            break block8;
lbl-1000:
            // 1 sources

            {
                ++caretPosition;
lbl15:
                // 2 sources

                ** while (caretPosition < PeriodVerifier.PATTERN.length() && PeriodVerifier.PATTERN.charAt((int)caretPosition) != '#')
            }
        }
        this.text.setSelection(caretPosition);
    }

    public void verifyText(VerifyEvent e) {
        if (this.ignore) {
            return;
        }
        e.doit = false;
        if (e.keyCode == 8 || e.keyCode == 127) {
            this.clearText(e.start, e.end);
            this.updateCaretPosition(e.start, e.keyCode == 8);
        } else {
            if (e.start >= PATTERN.length()) {
                this.beep();
                return;
            }
            String editValue = this.text.getText();
            StringBuffer sb = new StringBuffer();
            sb.append(editValue);
            int i = 0;
            int pos = e.start;
            while (i < e.text.length() && pos < PATTERN.length()) {
                char c = e.text.charAt(i);
                if ('#' == PATTERN.charAt(pos)) {
                    if (!Character.isDigit(c)) {
                        this.beep();
                        return;
                    }
                    sb.setCharAt(pos, c);
                }
                ++i;
                ++pos;
            }
            String text = sb.toString();
            Period period = new Period(this.getInternalValue(text));
            if (period.get(1) < 12 && period.get(2) < 366 && period.get(3) < 24 && period.get(4) < 60 && period.get(5) < 60) {
                this.updateText(text);
                this.updateCaretPosition(e.start + e.text.length(), false);
            } else {
                this.beep();
            }
        }
    }

    protected void beep() {
        Toolkit.getDefaultToolkit().beep();
    }

    protected void updateText(String text) {
        this.ignore = true;
        this.text.setText(text);
        this.ignore = false;
    }

    protected void clearText(int start, int end) {
        this.ignore = true;
        StringBuffer sb = new StringBuffer();
        sb.append(this.text.getText());
        int pos = start;
        while (pos < end && pos < PATTERN.length()) {
            char c = DEFAULT_TEXT.charAt(pos);
            sb.setCharAt(pos, c);
            ++pos;
        }
        this.text.setText(sb.toString());
        this.ignore = false;
    }

    @Override
    public String getExternalValue(String internalValue) {
        if (internalValue == null) {
            return DEFAULT_TEXT;
        }
        int c = 0;
        StringBuffer externalValue = new StringBuffer();
        int start = PATTERN.indexOf(58) + 1;
        externalValue.append(PATTERN.substring(0, start));
        int i = start;
        while (i < PATTERN.length()) {
            char ch = PATTERN.charAt(i);
            if (c < internalValue.length() && (ch == '#' || ch == ':')) {
                externalValue.append(internalValue.charAt(c));
                ++c;
            } else {
                externalValue.append(ch);
            }
            ++i;
        }
        return externalValue.toString();
    }

    @Override
    public String getInternalValue(String externalValue) {
        int start;
        StringBuffer internalValue = new StringBuffer();
        int i = start = PATTERN.indexOf(58) + 1;
        while (i < PATTERN.length()) {
            if (PATTERN.charAt(i) == '#' || PATTERN.charAt(i) == ':') {
                internalValue.append(externalValue.charAt(i));
            }
            ++i;
        }
        return internalValue.toString();
    }

    @Override
    public int getType() {
        return 7;
    }

    public void focusGained(FocusEvent e) {
    }

    public void focusLost(FocusEvent e) {
    }
}

