/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.core.compare;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.compare.BufferedContent;
import org.eclipse.compare.IEditableContent;
import org.eclipse.compare.IStreamContentAccessor;
import org.eclipse.compare.ITypedElement;
import org.eclipse.compare.structuremergeviewer.IStructureComparator;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.ETypedElement;
import org.eclipse.emf.ecore.impl.EStringToStringMapEntryImpl;
import org.eclipse.emf.ecore.util.BasicFeatureMap;
import org.eclipse.emf.ecore.util.EcoreEMap;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.util.ExtendedMetaData;
import org.eclipse.emf.ecore.util.FeatureMap;
import org.eclipse.stardust.common.reflect.Reflect;
import org.eclipse.stardust.model.xpdl.carnot.DataMappingType;
import org.eclipse.stardust.model.xpdl.carnot.DataPathType;
import org.eclipse.stardust.model.xpdl.carnot.DataType;
import org.eclipse.stardust.model.xpdl.carnot.DescriptionType;
import org.eclipse.stardust.model.xpdl.carnot.DiagramType;
import org.eclipse.stardust.model.xpdl.carnot.DocumentRoot;
import org.eclipse.stardust.model.xpdl.carnot.IIdentifiableElement;
import org.eclipse.stardust.model.xpdl.carnot.IModelElement;
import org.eclipse.stardust.model.xpdl.carnot.ISwimlaneSymbol;
import org.eclipse.stardust.model.xpdl.carnot.LaneSymbol;
import org.eclipse.stardust.model.xpdl.carnot.ModelType;
import org.eclipse.stardust.model.xpdl.carnot.ParticipantType;
import org.eclipse.stardust.model.xpdl.carnot.PoolSymbol;
import org.eclipse.stardust.model.xpdl.carnot.XmlTextNode;
import org.eclipse.stardust.model.xpdl.carnot.util.ModelUtils;
import org.eclipse.stardust.modeling.core.DiagramPlugin;
import org.eclipse.stardust.modeling.core.Diagram_Messages;
import org.eclipse.stardust.modeling.core.compare.CopyUtil;
import org.eclipse.stardust.modeling.core.editors.parts.IconFactory;
import org.eclipse.swt.graphics.Image;

public class ComparableModelElementNode
extends BufferedContent
implements IStructureComparator,
IStreamContentAccessor,
IEditableContent,
ITypedElement {
    private static final String ZEROS = "0000";
    private EObject eObject;
    private ETypedElement typedElement;
    private ArrayList children;

    public ComparableModelElementNode(EObject eObject) {
        this.eObject = eObject;
    }

    public ComparableModelElementNode(ETypedElement typedElement, EObject eObject) {
        this(eObject);
        this.typedElement = typedElement;
    }

    public ComparableModelElementNode getParent() {
        EObject parent = null;
        if (this.eObject != null) {
            parent = this.eObject.eContainer();
        }
        return parent != null ? new ComparableModelElementNode(parent) : null;
    }

    public boolean hasChildren() {
        return this.getChildren().length > 0;
    }

    public Object[] getChildren() {
        this.children = new ArrayList();
        if (this.eObject != null && this.typedElement == null) {
            Object feature;
            EAttribute mixedFeature;
            IStructureComparator child;
            for (EStructuralFeature eStructuralFeature : this.getAttributes(this.eObject)) {
                if (!(eStructuralFeature instanceof EAttribute) && !(eStructuralFeature instanceof EReference) || this.eObject.eGet(eStructuralFeature) == null || this.eObject.eGet(eStructuralFeature) instanceof EcoreEMap || (child = this.createChild((ETypedElement)eStructuralFeature, this.eObject)) == null) continue;
                this.children.add(child);
            }
            if (this.eObject instanceof XmlTextNode && (mixedFeature = ExtendedMetaData.INSTANCE.getMixedFeature(this.eObject.eClass())) != null && (feature = this.eObject.eGet((EStructuralFeature)mixedFeature)) instanceof BasicFeatureMap && (child = this.createChild((ETypedElement)mixedFeature, this.eObject)) != null) {
                this.children.add(child);
            }
            Iterator _iterator = this.eObject.eContents().iterator();
            while (_iterator.hasNext()) {
                IStructureComparator child2 = this.createChild((EObject)_iterator.next());
                if (child2 == null) continue;
                this.children.add(child2);
            }
        }
        return this.children.toArray();
    }

    protected IStructureComparator createChild(EObject child) {
        if (child instanceof EStringToStringMapEntryImpl) {
            return null;
        }
        return new ComparableModelElementNode(child);
    }

    protected IStructureComparator createChild(ETypedElement child, EObject parent) {
        return new ComparableModelElementNode(child, parent);
    }

    public EObject getEObject() {
        return this.eObject;
    }

    public String getName() {
        return this.getElementName();
    }

    public String getType() {
        return "???";
    }

    public Image getImage() {
        Image image = null;
        if (this.eObject != null && this.typedElement == null) {
            String iconPath = IconFactory.getDefault().getIconFor(this.eObject);
            image = DiagramPlugin.getImage(iconPath);
        } else if (this.eObject != null && this.typedElement != null) {
            if (this.eObject.eGet((EStructuralFeature)this.typedElement) instanceof EObject) {
                String iconPath = IconFactory.getDefault().getIconFor((EObject)this.eObject.eGet((EStructuralFeature)this.typedElement));
                image = DiagramPlugin.getImage(iconPath);
            } else {
                image = DiagramPlugin.getImage("/icons/full/obj16/attribute_obj.gif");
            }
        }
        return image;
    }

    public boolean equals(Object other) {
        if (other instanceof ITypedElement && this.getElementIdentifier() != null) {
            return this.getElementIdentifier().equals(((ComparableModelElementNode)((Object)other)).getElementIdentifier());
        }
        return super.equals(other);
    }

    public int hashCode() {
        if (this.getElementIdentifier() != null) {
            return this.getElementIdentifier().hashCode();
        }
        return super.hashCode();
    }

    protected InputStream createStream() throws CoreException {
        Object value;
        String stringifiedValue = null;
        if (this.eObject instanceof DescriptionType) {
            stringifiedValue = this.getDescriptionText((DescriptionType)this.eObject);
        } else if (this.typedElement != null && !this.isIgnorable() && (value = this.eObject.eGet((EStructuralFeature)this.typedElement)) != null) {
            if (value instanceof BasicFeatureMap) {
                stringifiedValue = this.getCDataString((FeatureMap)((BasicFeatureMap)value));
            } else {
                if (this.typedElement instanceof EReference) {
                    value = this.getElementIdentifier();
                }
                StringBuffer strBuffer = new StringBuffer();
                strBuffer.append(value);
                stringifiedValue = strBuffer.toString();
            }
        }
        if (stringifiedValue == null) {
            stringifiedValue = new String();
        }
        return new ByteArrayInputStream(stringifiedValue.getBytes());
    }

    private List getAttributes(EObject eObject) {
        return ExtendedMetaData.INSTANCE.getAllAttributes(eObject.eClass());
    }

    private String getElementName() {
        if (this.eObject != null && this.typedElement == null) {
            String name;
            for (EStructuralFeature eStructFeature : this.getAttributes(this.eObject)) {
                if (!eStructFeature.getName().equals("name") || (name = (String)this.eObject.eGet(eStructFeature)) == null) continue;
                return name;
            }
            for (EStructuralFeature eStructFeature : this.getAttributes(this.eObject)) {
                if (!eStructFeature.getName().equals("elementOid")) continue;
                name = Reflect.getHumanReadableClassName((Class)this.eObject.eClass().getInstanceClass());
                Long value = (Long)this.eObject.eGet(eStructFeature);
                name = String.valueOf(name) + " : " + value;
                return name;
            }
        } else {
            Object feature;
            String value = null;
            if (this.typedElement instanceof EReference) {
                Object refObject = this.eObject.eGet((EStructuralFeature)this.typedElement);
                if (refObject instanceof EObject) {
                    String name;
                    EObject refEObject = (EObject)refObject;
                    for (EStructuralFeature eStructFeature : this.getAttributes(refEObject)) {
                        if (!eStructFeature.getName().equals("name") || (name = (String)refEObject.eGet(eStructFeature)) == null) continue;
                        value = String.valueOf(this.typedElement.getName()) + " : " + name;
                    }
                    if (value == null) {
                        for (EStructuralFeature eStructFeature : this.getAttributes(refEObject)) {
                            if (!eStructFeature.getName().equals("elementOid")) continue;
                            name = Reflect.getHumanReadableClassName((Class)refEObject.eClass().getInstanceClass());
                            value = String.valueOf(name) + " : " + refEObject.eGet(eStructFeature);
                        }
                    }
                }
            } else {
                value = String.valueOf(this.typedElement.getName()) + " : " + this.eObject.eGet((EStructuralFeature)this.typedElement);
            }
            if ((feature = this.eObject.eGet((EStructuralFeature)this.typedElement)) instanceof BasicFeatureMap) {
                value = this.convert(this.getCDataString((FeatureMap)feature));
            }
            return value;
        }
        if (this.eObject instanceof DescriptionType) {
            return this.convert(this.getDescriptionText((DescriptionType)this.eObject));
        }
        if (this.eObject instanceof XmlTextNode) {
            return Reflect.getHumanReadableClassName((Class)this.eObject.eClass().getInstanceClass());
        }
        if (this.eObject instanceof ParticipantType) {
            return "participant";
        }
        if (this.eObject instanceof DocumentRoot) {
            return Diagram_Messages.ComparableModelElementNode_root;
        }
        return Diagram_Messages.ComparableModelElementNode_noName;
    }

    private String convert(String text) {
        StringBuffer sb = new StringBuffer();
        sb.append("\"");
        int i = 0;
        while (i < text.length()) {
            char c = text.charAt(i);
            if (Character.isISOControl(c)) {
                sb.append(this.getHumanReadableForm(c));
            } else {
                sb.append(c);
            }
            ++i;
        }
        sb.append("\"");
        return sb.toString();
    }

    private String getHumanReadableForm(char c) {
        char b = c;
        String hex = Integer.toHexString(b);
        return "\\0x" + ZEROS.substring(0, 4 - hex.length()) + Integer.toHexString(b);
    }

    private String getCDataString(FeatureMap map) {
        String text = ModelUtils.getCDataString((FeatureMap)map);
        return text == null ? "" : text;
    }

    private String getDescriptionText(DescriptionType type) {
        String text = ModelUtils.getDescriptionText((DescriptionType)((DescriptionType)this.eObject));
        return text == null ? "" : text.trim();
    }

    public Object getElementIdentifier() {
        Object identifier = null;
        if (this.eObject instanceof ModelType) {
            return "";
        }
        if (this.eObject != null && this.typedElement == null) {
            if (this.eObject instanceof DataMappingType) {
                DataMappingType dataMapping = (DataMappingType)this.eObject;
                identifier = String.valueOf(dataMapping.getId()) + "_" + dataMapping.getDirection().getName() + "_" + dataMapping.getContext();
            } else if (this.eObject instanceof DataPathType) {
                DataPathType dataPath = (DataPathType)this.eObject;
                identifier = String.valueOf(dataPath.getId()) + "_" + dataPath.getDirection().getName();
            } else if (this.eObject instanceof DiagramType) {
                identifier = ((DiagramType)this.eObject).getName();
            } else if (this.eObject instanceof IIdentifiableElement) {
                identifier = ((IIdentifiableElement)this.eObject).getId();
            } else if (this.eObject instanceof IModelElement) {
                identifier = String.valueOf(((IModelElement)this.eObject).getElementOid());
            }
        } else if (this.typedElement != null) {
            if (this.typedElement instanceof EReference) {
                Object refObject = this.eObject.eGet((EStructuralFeature)this.typedElement);
                if (refObject instanceof EObject) {
                    ComparableModelElementNode node = new ComparableModelElementNode((EObject)refObject);
                    identifier = node.getElementIdentifier();
                }
            } else {
                identifier = this.typedElement.getName();
            }
        }
        identifier = identifier == null ? (this.eObject != null ? this.eObject.eClass().getName() : null) : (this.eObject != null ? identifier + ":" + this.eObject.eClass().getClassifierID() : "");
        return identifier;
    }

    public boolean isEditable() {
        return true;
    }

    public ITypedElement replace(ITypedElement dest, ITypedElement src) {
        if (dest != null && src != null) {
            this.copyModelElementValue((ComparableModelElementNode)src, (ComparableModelElementNode)dest);
        } else if (dest != null && src == null) {
            this.removeModelElement((ComparableModelElementNode)dest);
        } else if (dest == null && src != null) {
            this.addModelElement((ComparableModelElementNode)src);
        }
        return dest;
    }

    public void setContent(byte[] contents) {
        super.setContent(contents);
    }

    public ETypedElement getETypedElement() {
        return this.typedElement;
    }

    private void copyModelElementValue(ComparableModelElementNode src, ComparableModelElementNode dest) {
        if (dest.getETypedElement() != null && src.getETypedElement() != null) {
            dest.getEObject().eSet((EStructuralFeature)dest.getETypedElement(), src.getEObject().eGet((EStructuralFeature)src.getETypedElement()));
        } else if (src.getEObject().eContainingFeature() != null && dest.getEObject().eContainingFeature() != null) {
            this.eObject.eUnset(dest.getEObject().eContainingFeature());
            EObject value = EcoreUtil.copy((EObject)src.getEObject());
            this.eObject.eSet(src.getEObject().eContainingFeature(), (Object)value);
        }
    }

    private void removeModelElement(ComparableModelElementNode dest) {
        EObject destinationEObject = dest.getEObject();
        Object feature = null;
        if (dest.getETypedElement() != null) {
            feature = dest.getETypedElement();
        } else {
            EStructuralFeature containingFeature = destinationEObject.eContainingFeature();
            feature = this.eObject.eGet(containingFeature);
            if (!(feature instanceof EStructuralFeature) && !(feature instanceof List)) {
                feature = null;
            }
        }
        if (feature != null) {
            if (feature instanceof List) {
                ((List)feature).remove(destinationEObject);
                if (destinationEObject instanceof LaneSymbol && this.eObject instanceof ISwimlaneSymbol) {
                    ((LaneSymbol)destinationEObject).setParentLane(null);
                    ((LaneSymbol)destinationEObject).setParentPool(null);
                }
            } else {
                this.eObject.eUnset((EStructuralFeature)feature);
            }
        } else if (destinationEObject.eContainingFeature() != null) {
            this.eObject.eUnset(destinationEObject.eContainingFeature());
        }
    }

    private void addModelElement(ComparableModelElementNode src) {
        EObject sourceEObject = src.getEObject();
        Object feature = null;
        Object value = null;
        if (src.getETypedElement() != null) {
            feature = src.getETypedElement();
            value = sourceEObject.eGet((EStructuralFeature)feature);
        } else {
            feature = this.eObject.eGet(sourceEObject.eContainingFeature());
            if (!(feature instanceof EStructuralFeature) && !(feature instanceof List)) {
                feature = null;
            }
            value = CopyUtil.copy(sourceEObject, this.getEObject());
        }
        if (feature != null) {
            if (feature instanceof List) {
                ((List)feature).add(value);
                if (value instanceof LaneSymbol && this.eObject instanceof ISwimlaneSymbol) {
                    ((LaneSymbol)value).setParentLane((ISwimlaneSymbol)this.eObject);
                    ((LaneSymbol)value).setParentPool(this.getPool(this.eObject));
                }
            } else {
                this.eObject.eSet((EStructuralFeature)feature, value);
            }
        } else if (sourceEObject.eContainingFeature() != null) {
            this.eObject.eSet(sourceEObject.eContainingFeature(), value);
        }
    }

    private PoolSymbol getPool(EObject object) {
        if (this.eObject instanceof PoolSymbol) {
            return (PoolSymbol)this.eObject;
        }
        if (this.eObject instanceof LaneSymbol) {
            return ((LaneSymbol)this.eObject).getParentPool();
        }
        return null;
    }

    private boolean isIgnorable() {
        return this.eObject != null && this.typedElement != null && (this.eObject instanceof IIdentifiableElement || this.eObject instanceof DataType) && "elementOid".equals(this.typedElement.getName());
    }

    public String toString() {
        return this.getName();
    }
}

