/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.core.compare;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.FeatureMap;
import org.eclipse.emf.ecore.util.FeatureMapUtil;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.stardust.model.xpdl.carnot.IModelElement;
import org.eclipse.stardust.model.xpdl.carnot.ModelType;
import org.eclipse.stardust.model.xpdl.carnot.util.ModelUtils;
import org.eclipse.stardust.modeling.core.compare.ComparableModelElementNode;
import org.eclipse.stardust.modeling.core.compare.ImportSelectionRegistration;

public class CopyUtil {
    private static Map visited;
    private static Map features;

    public static void reset() {
        if (visited == null) {
            visited = new HashMap();
        } else {
            visited.clear();
        }
        if (features == null) {
            features = new HashMap();
        } else {
            features.clear();
        }
    }

    public static EObject create(EClass eClass) {
        return eClass.getEPackage().getEFactoryInstance().create(eClass);
    }

    public static EObject copy(EObject eObject, EObject target) {
        Copier copier = new Copier(target, visited);
        EObject result = copier.copy(eObject);
        copier.copyReferences();
        return result;
    }

    public static Collection copyAll(Collection eObjects, EObject target) {
        Copier copier = new Copier(target, visited);
        Collection result = copier.copyAll(eObjects);
        copier.copyReferences();
        return result;
    }

    public static boolean isModelElementInTargetModel(EObject element, EObject target) {
        boolean elementExistsInModel;
        ModelType model = ModelUtils.findContainingModel((EObject)target);
        boolean bl = element instanceof IModelElement ? CopyUtil.getElementInOtherModel(element, model) != null : (elementExistsInModel = false);
        if (!elementExistsInModel) {
            elementExistsInModel = ImportSelectionRegistration.lookup(element);
        }
        return elementExistsInModel;
    }

    private static Collection getContainingList(EObject obj, ModelType model) {
        Object parent = obj.eContainer();
        if (parent == null) {
            return null;
        }
        EStructuralFeature feature = obj.eContainingFeature();
        if ((parent = parent instanceof ModelType ? model : CopyUtil.getElementInOtherModel(parent, model)) == null) {
            return null;
        }
        Object o = parent.eGet(feature);
        if (!(o instanceof Collection)) {
            return null;
        }
        return (Collection)o;
    }

    public static EObject getElementInOtherModel(EObject element, ModelType model) {
        EObject other = (EObject)visited.get(element);
        if (other != null) {
            return other;
        }
        Collection listOfEObjects = CopyUtil.getContainingList(element, model);
        if (listOfEObjects != null) {
            ComparableModelElementNode elementNode = new ComparableModelElementNode(element);
            Iterator _iterator = listOfEObjects.iterator();
            while (_iterator.hasNext()) {
                ComparableModelElementNode targetNode = new ComparableModelElementNode((EObject)_iterator.next());
                if (!elementNode.getElementIdentifier().equals(targetNode.getElementIdentifier())) continue;
                return targetNode.getEObject();
            }
        }
        return null;
    }

    public static class Copier {
        private EObject target;
        private Map visited;
        private ModelType model;

        public Copier(EObject target, Map visited) {
            this.target = target;
            this.visited = visited;
            this.model = ModelUtils.findContainingModel((EObject)target);
        }

        public Collection copyAll(Collection eObjects) {
            ArrayList<EObject> result = new ArrayList<EObject>(eObjects.size());
            Iterator i = eObjects.iterator();
            while (i.hasNext()) {
                result.add(this.copy((EObject)i.next()));
            }
            return result;
        }

        public EObject copy(EObject eObject) {
            EObject copyEObject = (EObject)this.visited.get(eObject);
            if (copyEObject == null) {
                boolean newObject = false;
                copyEObject = CopyUtil.getElementInOtherModel(eObject, this.model);
                if (copyEObject == null) {
                    copyEObject = this.createCopy(eObject);
                    newObject = true;
                }
                this.visited.put(eObject, copyEObject);
                EClass eClass = eObject.eClass();
                if (newObject) {
                    int i = 0;
                    int size = eClass.getFeatureCount();
                    while (i < size) {
                        EStructuralFeature eStructuralFeature = eClass.getEStructuralFeature(i);
                        if (eStructuralFeature.isChangeable() && !eStructuralFeature.isDerived()) {
                            if (eStructuralFeature instanceof EAttribute) {
                                this.copyAttribute((EAttribute)eStructuralFeature, eObject, copyEObject);
                            } else {
                                EReference eReference = (EReference)eStructuralFeature;
                                if (eReference.isContainment()) {
                                    this.copyContainment(eReference, eObject, copyEObject);
                                } else {
                                    ComparableModelElementNode node;
                                    Object eRefObj = eObject.eGet((EStructuralFeature)eReference);
                                    EObject refEObject = null;
                                    if (eRefObj instanceof EObject && !eReference.isTransient()) {
                                        refEObject = (EObject)eRefObj;
                                    }
                                    if (refEObject != null && CopyUtil.isModelElementInTargetModel((node = new ComparableModelElementNode(refEObject)).getEObject(), this.target)) {
                                        this.copyContainment(eReference, eObject, copyEObject);
                                    }
                                }
                            }
                        }
                        ++i;
                    }
                }
            }
            return copyEObject;
        }

        protected EObject createCopy(EObject eObject) {
            return CopyUtil.create(this.getTarget(eObject.eClass()));
        }

        protected EClass getTarget(EClass eClass) {
            return eClass;
        }

        protected EStructuralFeature getTarget(EStructuralFeature eStructuralFeature) {
            return eStructuralFeature;
        }

        protected void copyContainment(EReference eReference, EObject eObject, EObject copyEObject) {
            if (eObject.eIsSet((EStructuralFeature)eReference)) {
                if (eReference.isMany()) {
                    List source = (List)eObject.eGet((EStructuralFeature)eReference);
                    List target = (List)copyEObject.eGet(this.getTarget((EStructuralFeature)eReference));
                    if (source.isEmpty()) {
                        target.clear();
                    } else {
                        target.addAll(this.copyAll(source));
                    }
                } else {
                    EObject childEObject = (EObject)eObject.eGet((EStructuralFeature)eReference);
                    copyEObject.eSet(this.getTarget((EStructuralFeature)eReference), childEObject == null ? null : this.copy(childEObject));
                }
            }
        }

        protected void copyAttribute(EAttribute eAttribute, EObject eObject, EObject copyEObject) {
            if (eObject.eIsSet((EStructuralFeature)eAttribute)) {
                if (FeatureMapUtil.isFeatureMap((EStructuralFeature)eAttribute)) {
                    FeatureMap featureMap = (FeatureMap)eObject.eGet((EStructuralFeature)eAttribute);
                    int i = 0;
                    int size = featureMap.size();
                    while (i < size) {
                        Object value;
                        EStructuralFeature feature = featureMap.getEStructuralFeature(i);
                        if (feature instanceof EReference && ((EReference)feature).isContainment() && (value = featureMap.getValue(i)) != null) {
                            this.copy((EObject)value);
                        }
                        ++i;
                    }
                } else if (eAttribute.isMany()) {
                    List source = (List)eObject.eGet((EStructuralFeature)eAttribute);
                    List target = (List)copyEObject.eGet(this.getTarget((EStructuralFeature)eAttribute));
                    if (source.isEmpty()) {
                        target.clear();
                    } else {
                        target.addAll(source);
                    }
                } else {
                    copyEObject.eSet(this.getTarget((EStructuralFeature)eAttribute), eObject.eGet((EStructuralFeature)eAttribute));
                }
            }
        }

        public void copyReferences() {
            for (Map.Entry entry : this.visited.entrySet()) {
                EObject eObject = (EObject)entry.getKey();
                EObject copyEObject = (EObject)entry.getValue();
                EClass eClass = eObject.eClass();
                int j = 0;
                int size = eClass.getFeatureCount();
                while (j < size) {
                    EStructuralFeature eStructuralFeature = eClass.getEStructuralFeature(j);
                    if (eStructuralFeature.isChangeable() && !eStructuralFeature.isDerived()) {
                        if (eStructuralFeature instanceof EReference) {
                            EReference eReference = (EReference)eStructuralFeature;
                            if (!eReference.isContainment()) {
                                this.copyReference(eReference, eObject, copyEObject);
                            }
                        } else if (FeatureMapUtil.isFeatureMap((EStructuralFeature)eStructuralFeature)) {
                            FeatureMap featureMap = (FeatureMap)eObject.eGet(eStructuralFeature);
                            FeatureMap copyFeatureMap = (FeatureMap)features.get(featureMap);
                            if (copyFeatureMap == null) {
                                copyFeatureMap = (FeatureMap)copyEObject.eGet(this.getTarget(eStructuralFeature));
                                features.put(featureMap, copyFeatureMap);
                                int k = 0;
                                int featureMapSize = featureMap.size();
                                while (k < featureMapSize) {
                                    EStructuralFeature feature = featureMap.getEStructuralFeature(k);
                                    if (feature instanceof EReference) {
                                        Object referencedEObject = featureMap.getValue(k);
                                        Object copyReferencedEObject = this.visited.get(referencedEObject);
                                        copyFeatureMap.add(feature, copyReferencedEObject == null ? referencedEObject : copyReferencedEObject);
                                    } else {
                                        copyFeatureMap.add((Object)((FeatureMap.Entry)featureMap.get(k)));
                                    }
                                    ++k;
                                }
                            }
                        }
                    }
                    ++j;
                }
            }
        }

        protected void copyReference(EReference eReference, EObject eObject, EObject copyEObject) {
            if (eObject.eIsSet((EStructuralFeature)eReference)) {
                if (eReference.isMany()) {
                    List source = (List)eObject.eGet((EStructuralFeature)eReference);
                    InternalEList target = (InternalEList)copyEObject.eGet(this.getTarget((EStructuralFeature)eReference));
                    if (source.isEmpty()) {
                        target.clear();
                    } else {
                        boolean isBidirectional = eReference.getEOpposite() != null;
                        int index = 0;
                        for (Object referencedEObject : source) {
                            Object copyReferencedEObject = this.visited.get(referencedEObject);
                            if (copyReferencedEObject == null) {
                                if (isBidirectional) continue;
                                target.addUnique(index, referencedEObject);
                                ++index;
                                continue;
                            }
                            if (isBidirectional) {
                                int position = target.indexOf(copyReferencedEObject);
                                if (position == -1) {
                                    target.addUnique(index, copyReferencedEObject);
                                } else if (index != position) {
                                    target.move(index, copyReferencedEObject);
                                }
                            } else {
                                target.addUnique(index, copyReferencedEObject);
                            }
                            ++index;
                        }
                    }
                } else {
                    Object referencedEObject = eObject.eGet((EStructuralFeature)eReference);
                    if (referencedEObject == null) {
                        copyEObject.eSet(this.getTarget((EStructuralFeature)eReference), null);
                    } else {
                        Object copyReferencedEObject = this.visited.get(referencedEObject);
                        if (copyReferencedEObject == null) {
                            if (eReference.getEOpposite() == null) {
                                copyEObject.eSet(this.getTarget((EStructuralFeature)eReference), referencedEObject);
                            }
                        } else {
                            copyEObject.eSet(this.getTarget((EStructuralFeature)eReference), copyReferencedEObject);
                        }
                    }
                }
            }
        }
    }
}

