/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.core.compare;

import java.util.HashSet;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.stardust.model.xpdl.carnot.IModelElement;
import org.eclipse.stardust.model.xpdl.carnot.ModelType;
import org.eclipse.stardust.model.xpdl.carnot.util.ModelUtils;
import org.eclipse.stardust.modeling.core.compare.CopyUtil;

public class ModelElementOidRegistration {
    public static void replaceDuplicateOids(ModelType newModel, ModelType targetModel) {
        long oid;
        EObject child;
        HashSet<Long> oids = new HashSet<Long>();
        long nextOid = Long.MIN_VALUE;
        TreeIterator i = targetModel.eAllContents();
        while (i.hasNext()) {
            child = (EObject)i.next();
            if (!(child instanceof IModelElement)) continue;
            oid = ((IModelElement)child).getElementOid();
            nextOid = Math.max(nextOid, oid);
            oids.add(new Long(oid));
        }
        i = newModel.eAllContents();
        while (i.hasNext()) {
            child = (EObject)i.next();
            if (!(child instanceof IModelElement)) continue;
            oid = ((IModelElement)child).getElementOid();
            nextOid = Math.max(nextOid, oid);
        }
        i = newModel.eAllContents();
        while (i.hasNext()) {
            IModelElement other;
            child = (EObject)i.next();
            if (!(child instanceof IModelElement)) continue;
            IModelElement me = (IModelElement)child;
            if (!me.isSetElementOid()) {
                me.setElementOid(ModelUtils.getElementOid((IModelElement)me, (ModelType)newModel));
            }
            if ((other = (IModelElement)CopyUtil.getElementInOtherModel(child, targetModel)) == null) {
                if (!oids.contains(new Long(me.getElementOid()))) continue;
                long newElementOid = ++nextOid;
                me.setElementOid(newElementOid);
                continue;
            }
            me.setElementOid(other.getElementOid());
        }
    }
}

