/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.core.editors;

import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.draw2d.Clickable;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Toggle;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.gef.DefaultEditDomain;
import org.eclipse.gef.EditDomain;
import org.eclipse.gef.EditPartFactory;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.commands.CommandStack;
import org.eclipse.gef.editparts.SimpleRootEditPart;
import org.eclipse.gef.palette.PaletteRoot;
import org.eclipse.gef.ui.palette.PaletteViewer;
import org.eclipse.gef.ui.parts.SelectionSynchronizer;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.stardust.common.reflect.Reflect;
import org.eclipse.stardust.modeling.core.editors.AbstractMultiPageGraphicalEditor;
import org.eclipse.stardust.modeling.core.editors.tools.CarnotPaletteEditPartFactory;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IPropertyListener;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.EditorPart;

public abstract class AbstractGraphicalEditorPage
extends EditorPart {
    private final AbstractMultiPageGraphicalEditor editor;
    private final EditDomain editDomain;
    private PaletteViewer paletteViewer;

    AbstractGraphicalEditorPage(AbstractMultiPageGraphicalEditor editor) {
        this.editor = editor;
        this.editDomain = new DefaultEditDomain((IEditorPart)this);
        this.editDomain.setCommandStack(editor.getSharedCommandStack());
        editor.addPropertyListener(new IPropertyListener(){

            public void propertyChanged(Object source, int propId) {
                if (propId == 258) {
                    AbstractGraphicalEditorPage.this.updateTitle(AbstractGraphicalEditorPage.this.editor.getEditorInput());
                }
            }
        });
    }

    public abstract String getPageName();

    public abstract GraphicalViewer getGraphicalViewer();

    protected abstract void createPageControl(Composite var1);

    public void doSave(IProgressMonitor monitor) {
        this.editor.doSave(monitor);
    }

    public void doSaveAs() {
        this.editor.doSaveAs();
    }

    public boolean isSaveAsAllowed() {
        return this.editor.isSaveAsAllowed();
    }

    public final boolean isDirty() {
        return this.editor.isDirty();
    }

    public EditDomain getEditDomain() {
        return this.editDomain;
    }

    public CommandStack getCommandStack() {
        return this.getEditDomain().getCommandStack();
    }

    protected SelectionSynchronizer getSelectionSynchronizer() {
        return this.editor.getSelectionSynchronizer();
    }

    protected abstract PaletteRoot getPaletteRoot();

    public PaletteViewer getPaletteViewer() {
        return this.paletteViewer;
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        this.setSite((IWorkbenchPartSite)site);
        this.setInput(input);
        this.updateTitle(input);
    }

    public void updateTitle(IEditorInput input) {
        this.setPartName(String.valueOf(input.getName()) + ": " + this.getPageName());
    }

    public void setFocus() {
        this.getGraphicalViewer().getControl().setFocus();
    }

    public final void createPartControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 10;
        layout.marginWidth = 10;
        layout.verticalSpacing = 5;
        layout.horizontalSpacing = 5;
        layout.numColumns = 1;
        composite.setLayout((Layout)layout);
        composite.setBackground(parent.getDisplay().getSystemColor(25));
        composite.setForeground(parent.getDisplay().getSystemColor(24));
        final Label label = new Label(composite, 16648);
        label.setText(this.getTitle());
        label.setFont(JFaceResources.getFontRegistry().get("org.eclipse.jface.headerfont"));
        label.setBackground(parent.getDisplay().getSystemColor(25));
        label.setForeground(parent.getDisplay().getSystemColor(24));
        label.setLayoutData((Object)new GridData(768));
        this.addPropertyListener(new IPropertyListener(){

            public void propertyChanged(Object source, int propId) {
                if (propId == 1) {
                    label.setText(AbstractGraphicalEditorPage.this.getTitle());
                }
            }
        });
        composite = new Composite(composite, 0);
        composite.setLayout((Layout)new FillLayout());
        composite.setBackground(parent.getDisplay().getSystemColor(25));
        composite.setForeground(parent.getDisplay().getSystemColor(24));
        composite.setLayoutData((Object)new GridData(1808));
        this.createPageControl(composite);
    }

    protected void registerEditPartViewer(EditPartViewer viewer) {
        this.getEditDomain().addViewer(viewer);
        this.editor.getSelectionSynchronizer().addViewer(viewer);
        this.getSite().setSelectionProvider((ISelectionProvider)viewer);
    }

    protected void configureEditPartViewer(EditPartViewer viewer) {
        if (viewer.getKeyHandler() != null) {
            viewer.getKeyHandler().setParent(this.editor.getSharedKeyHandler());
        }
    }

    protected void createPaletteViewer(Composite parent) {
        this.paletteViewer = new PaletteViewer();
        this.paletteViewer.createControl(parent);
        this.paletteViewer.getControl().setBackground(parent.getBackground());
        parent.getParent().getParent().getParent().getBackground();
        this.paletteViewer.setEditPartFactory((EditPartFactory)new CarnotPaletteEditPartFactory());
        this.getEditDomain().setPaletteViewer(this.paletteViewer);
        this.getEditDomain().setPaletteRoot(this.getPaletteRoot());
        this.fixPaletteLayout();
    }

    private void fixPaletteLayout() {
        if (this.paletteViewer.getRootEditPart() instanceof SimpleRootEditPart) {
            IFigure figure = ((SimpleRootEditPart)this.paletteViewer.getRootEditPart()).getFigure();
            try {
                this.fixFigureLayout(figure.getChildren());
            }
            catch (Throwable throwable) {}
        }
    }

    private void fixFigureLayout(List<?> list) {
        for (Object o : list) {
            if (o instanceof Toggle) {
                Insets insets = new Insets(0, 0, 0, 0);
                Toggle toggle = (Toggle)o;
                toggle.setStyle(Clickable.STYLE_BUTTON | Clickable.STYLE_TOGGLE);
                Object border = Reflect.getFieldValue((Object)toggle, (String)"border");
                Object scheme = Reflect.getFieldValue((Object)border, (String)"scheme");
                Reflect.setFieldValue((Object)scheme, (String)"insets", (Object)insets);
                if (toggle.toString().indexOf("DrawerFigure$CollapseToggle") > 0) {
                    toggle.setSelected(true);
                }
            }
            if (!(o instanceof IFigure)) continue;
            IFigure figure = (IFigure)o;
            if (figure.getChildren().size() > 0) {
                this.fixFigureLayout(figure.getChildren());
            }
            figure.setBackgroundColor(ColorConstants.button);
        }
    }
}

