/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.core.editors;

import org.eclipse.draw2d.ScalableFigure;
import org.eclipse.draw2d.Viewport;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.editparts.ZoomListener;
import org.eclipse.gef.editparts.ZoomManager;
import org.eclipse.jface.util.ListenerList;

public class DelegatingZoomManager
extends ZoomManager
implements ZoomListener {
    private ZoomManager currentZoomManager;
    private ListenerList zoomListeners = new ListenerList(3);

    public DelegatingZoomManager() {
        super(null, null);
    }

    public void zoomChanged(double zoom) {
        Object[] listeners = this.zoomListeners.getListeners();
        int i = 0;
        while (i < listeners.length) {
            ((ZoomListener)listeners[i]).zoomChanged(zoom);
            ++i;
        }
    }

    public void addZoomListener(ZoomListener listener) {
        this.zoomListeners.add((Object)listener);
    }

    public void removeZoomListener(ZoomListener listener) {
        this.zoomListeners.remove((Object)listener);
    }

    public void setCurrentZoomManager(ZoomManager zoomManager) {
        if (this.currentZoomManager != zoomManager) {
            if (this.currentZoomManager != null) {
                this.currentZoomManager.removeZoomListener((ZoomListener)this);
            }
            this.currentZoomManager = zoomManager;
            if (this.currentZoomManager != null) {
                this.currentZoomManager.addZoomListener((ZoomListener)this);
                this.zoomChanged(this.currentZoomManager.getZoom());
            }
        }
    }

    public boolean canZoomIn() {
        return this.currentZoomManager == null ? false : this.currentZoomManager.canZoomIn();
    }

    public boolean canZoomOut() {
        return this.currentZoomManager == null ? false : this.currentZoomManager.canZoomOut();
    }

    public double getMaxZoom() {
        return this.currentZoomManager == null ? 1.0 : this.currentZoomManager.getMaxZoom();
    }

    public double getMinZoom() {
        return this.currentZoomManager == null ? 1.0 : this.currentZoomManager.getMinZoom();
    }

    public double getNextZoomLevel() {
        return this.currentZoomManager == null ? 1.0 : this.currentZoomManager.getNextZoomLevel();
    }

    public double getPreviousZoomLevel() {
        return this.currentZoomManager == null ? 1.0 : this.currentZoomManager.getPreviousZoomLevel();
    }

    public ScalableFigure getScalableFigure() {
        return this.currentZoomManager == null ? null : this.currentZoomManager.getScalableFigure();
    }

    public double getUIMultiplier() {
        return this.currentZoomManager == null ? 1.0 : this.currentZoomManager.getUIMultiplier();
    }

    public Viewport getViewport() {
        return this.currentZoomManager == null ? null : this.currentZoomManager.getViewport();
    }

    public double getZoom() {
        return this.currentZoomManager == null ? 1.0 : this.currentZoomManager.getZoom();
    }

    public String getZoomAsText() {
        return this.currentZoomManager == null ? " 100%" : this.currentZoomManager.getZoomAsText();
    }

    public double[] getZoomLevels() {
        double[] dArray;
        if (this.currentZoomManager == null) {
            double[] dArray2 = new double[1];
            dArray = dArray2;
            dArray2[0] = 1.0;
        } else {
            dArray = this.currentZoomManager.getZoomLevels();
        }
        return dArray;
    }

    public String[] getZoomLevelsAsText() {
        String[] stringArray;
        if (this.currentZoomManager == null) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = " 100%";
        } else {
            stringArray = this.currentZoomManager.getZoomLevelsAsText();
        }
        return stringArray;
    }

    public void setUIMultiplier(double multiplier) {
        if (this.currentZoomManager != null) {
            this.currentZoomManager.setUIMultiplier(multiplier);
        }
    }

    public void setViewLocation(Point p) {
        if (this.currentZoomManager != null) {
            this.currentZoomManager.setViewLocation(p);
        }
    }

    public void setZoom(double zoom) {
        if (this.currentZoomManager != null) {
            this.currentZoomManager.setZoom(zoom);
        }
    }

    public void setZoomAnimationStyle(int style) {
        if (this.currentZoomManager != null) {
            this.currentZoomManager.setZoomAnimationStyle(style);
        }
    }

    public void setZoomAsText(String zoomString) {
        if (this.currentZoomManager != null) {
            this.currentZoomManager.setZoomAsText(zoomString);
        }
    }

    public void setZoomLevels(double[] zoomLevels) {
        if (this.currentZoomManager != null) {
            this.currentZoomManager.setZoomLevels(zoomLevels);
        }
    }

    public void zoomIn() {
        if (this.currentZoomManager != null) {
            this.currentZoomManager.zoomIn();
        }
    }

    public void zoomOut() {
        if (this.currentZoomManager != null) {
            this.currentZoomManager.zoomOut();
        }
    }

    public void zoomTo(Rectangle rect) {
        if (this.currentZoomManager != null) {
            this.currentZoomManager.zoomTo(rect);
        }
    }
}

