/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.core.editors;

import org.eclipse.draw2d.ConnectionLayer;
import org.eclipse.draw2d.ConnectionRouter;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartFactory;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.KeyHandler;
import org.eclipse.gef.MouseWheelHandler;
import org.eclipse.gef.MouseWheelZoomHandler;
import org.eclipse.gef.RootEditPart;
import org.eclipse.gef.dnd.TransferDropTargetListener;
import org.eclipse.gef.editparts.ScalableFreeformRootEditPart;
import org.eclipse.gef.palette.PaletteRoot;
import org.eclipse.gef.ui.actions.ToggleGridAction;
import org.eclipse.gef.ui.actions.ToggleSnapToGeometryAction;
import org.eclipse.gef.ui.parts.GraphicalViewerKeyHandler;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.stardust.common.StringUtils;
import org.eclipse.stardust.model.xpdl.carnot.DiagramType;
import org.eclipse.stardust.model.xpdl.carnot.ModelType;
import org.eclipse.stardust.model.xpdl.carnot.ProcessDefinitionType;
import org.eclipse.stardust.model.xpdl.carnot.util.ModelUtils;
import org.eclipse.stardust.modeling.core.Diagram_Messages;
import org.eclipse.stardust.modeling.core.editors.AbstractGraphicalEditorPage;
import org.eclipse.stardust.modeling.core.editors.DiagramScrollingGraphicalViewer;
import org.eclipse.stardust.modeling.core.editors.EditPartRegistry;
import org.eclipse.stardust.modeling.core.editors.WorkflowModelEditor;
import org.eclipse.stardust.modeling.core.editors.WorkflowModelEditorContextMenuProvider;
import org.eclipse.stardust.modeling.core.editors.WorkflowModelEditorPaletteFactory;
import org.eclipse.stardust.modeling.core.editors.dnd.ModelElementTransferDropTargetListener;
import org.eclipse.stardust.modeling.core.editors.figures.routers.DiagramShortestPathConnectionRouter;
import org.eclipse.stardust.modeling.core.editors.parts.diagram.DiagramRootEditPart;
import org.eclipse.stardust.modeling.core.editors.parts.diagram.WorkflowModelDiagramEditPartFactory;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.actions.ActionFactory;

public class DiagramEditorPage
extends AbstractGraphicalEditorPage
implements EditPartRegistry,
IShellProvider {
    private GraphicalViewer viewer;
    final WorkflowModelEditor cwmEditor;
    private final DiagramType diagram;
    private PaletteRoot paletteRoot;
    private Point mouseLocation;

    public DiagramEditorPage(WorkflowModelEditor cwmEditor, DiagramType diagram) {
        super(cwmEditor);
        this.cwmEditor = cwmEditor;
        this.diagram = diagram;
    }

    @Override
    public PaletteRoot getPaletteRoot() {
        if (this.paletteRoot == null) {
            this.paletteRoot = WorkflowModelEditorPaletteFactory.createPaletteForDiagram(this);
            WorkflowModelEditorPaletteFactory.updatePalette(this);
        }
        return this.paletteRoot;
    }

    @Override
    public String getPageName() {
        if (this.diagram != null) {
            boolean trailingBrace = false;
            StringBuffer buffer = new StringBuffer(100);
            ProcessDefinitionType process = ModelUtils.findContainingProcess((EObject)this.diagram);
            if (process != null) {
                if (!StringUtils.isEmpty((String)process.getName())) {
                    buffer.append(process.getName());
                } else {
                    buffer.append(Diagram_Messages.DiagramEditor_PAGENAME_UnnamedProcess);
                }
                buffer.append(" (");
                trailingBrace = true;
            }
            if (!StringUtils.isEmpty((String)this.diagram.getName())) {
                buffer.append(this.diagram.getName());
            } else {
                buffer.append(Diagram_Messages.DiagramEditor_PAGENAME_UnnamedDiagram);
            }
            if (trailingBrace) {
                buffer.append(")");
            }
            return buffer.toString();
        }
        return Diagram_Messages.DiagramEditor_PAGENAME_UnnamedDiagram;
    }

    @Override
    public GraphicalViewer getGraphicalViewer() {
        return this.viewer;
    }

    @Override
    protected void createPageControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setBackground(parent.getBackground());
        composite.setLayout((Layout)new GridLayout(2, false));
        GridData cdata = new GridData();
        cdata.verticalIndent = 0;
        cdata.horizontalIndent = 0;
        cdata.widthHint = 0;
        cdata.heightHint = 0;
        this.createPaletteViewer(composite);
        GridData gd2 = new GridData(1040);
        gd2.widthHint = 130;
        gd2.heightHint = 0;
        gd2.horizontalIndent = 0;
        gd2.verticalIndent = 0;
        this.getPaletteViewer().getControl().setLayoutData((Object)gd2);
        this.createGraphicalViewer(composite);
        GridData gd1 = new GridData(1808);
        gd1.widthHint = 275;
        this.getGraphicalViewer().getControl().setLayoutData((Object)gd1);
    }

    protected void initializeGraphicalViewer() {
        ToggleGridAction toggleSnapToGrid;
        GraphicalViewer viewer = this.getGraphicalViewer();
        ScalableFreeformRootEditPart root = (ScalableFreeformRootEditPart)viewer.getRootEditPart();
        IFigure nodeLayer = root.getLayer((Object)"Primary Layer");
        ConnectionLayer connLayer = (ConnectionLayer)root.getLayer((Object)"Connection Layer");
        DiagramShortestPathConnectionRouter router = new DiagramShortestPathConnectionRouter(nodeLayer);
        connLayer.setConnectionRouter((ConnectionRouter)router);
        ToggleSnapToGeometryAction toggleSnapToGeometry = new ToggleSnapToGeometryAction(viewer);
        if (toggleSnapToGeometry.isChecked()) {
            toggleSnapToGeometry.run();
        }
        if (!(toggleSnapToGrid = new ToggleGridAction(viewer)).isChecked()) {
            toggleSnapToGrid.run();
        }
        viewer.setContents((Object)this.diagram);
        viewer.addDropTargetListener((TransferDropTargetListener)new ModelElementTransferDropTargetListener(this.cwmEditor, (EditPartViewer)viewer));
        viewer.setProperty(MouseWheelHandler.KeyGenerator.getKey((int)SWT.MOD1), (Object)MouseWheelZoomHandler.SINGLETON);
    }

    private void createGraphicalViewer(Composite parent) {
        this.viewer = new DiagramScrollingGraphicalViewer();
        this.viewer.createControl(parent);
        this.viewer.getControl().setBackground(parent.getBackground());
        this.viewer.setRootEditPart((RootEditPart)new DiagramRootEditPart());
        this.viewer.setKeyHandler((KeyHandler)new GraphicalViewerKeyHandler(this.viewer));
        WorkflowModelEditorContextMenuProvider provider = new WorkflowModelEditorContextMenuProvider(this, this.cwmEditor.getActionRegistry());
        this.viewer.setContextMenu((MenuManager)provider);
        this.registerEditPartViewer((EditPartViewer)this.viewer);
        this.configureEditPartViewer((EditPartViewer)this.viewer);
        this.viewer.setEditPartFactory((EditPartFactory)new WorkflowModelDiagramEditPartFactory(this.cwmEditor));
        this.initializeGraphicalViewer();
        this.getGraphicalViewer().getControl().addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent e) {
                IAction action = DiagramEditorPage.this.cwmEditor.getActionRegistry().getAction((Object)ActionFactory.PROPERTIES.getId());
                action.run();
            }

            public void mouseDown(MouseEvent e) {
                DiagramEditorPage.this.mouseLocation = new Point(e.x, e.y);
            }
        });
    }

    public DiagramType getDiagram() {
        return this.diagram;
    }

    @Override
    public EditPart findEditPart(Object model) {
        return (EditPart)this.getGraphicalViewer().getEditPartRegistry().get(model);
    }

    @Override
    public ModelType getWorkflowModel() {
        return ModelUtils.findContainingModel((EObject)this.diagram);
    }

    public WorkflowModelEditor getWorkflowModelEditor() {
        return this.cwmEditor;
    }

    public Point getMouseLocation() {
        return this.mouseLocation;
    }

    public Shell getShell() {
        return this.getSite().getShell();
    }

    public void setMouseLocation(Point mouseLocation) {
        this.mouseLocation = mouseLocation;
    }
}

