/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.core.editors;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IMarkerDelta;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.stardust.modeling.core.editors.ValidationIssueManager;
import org.eclipse.stardust.modeling.validation.Issue;
import org.eclipse.stardust.modeling.validation.IssueDelta;
import org.eclipse.stardust.modeling.validation.ValidationMarkerService;

public class ModelResourceIssueSynchronizer
implements IResourceDeltaVisitor {
    private final Map markerMapping = new HashMap();
    private final ValidationIssueManager issueManager;

    public ModelResourceIssueSynchronizer(ValidationIssueManager issueManager) {
        this.issueManager = issueManager;
    }

    public boolean visit(IResourceDelta delta) throws CoreException {
        IMarkerDelta[] markerDeltas = delta.getMarkerDeltas();
        if (markerDeltas != null && markerDeltas.length > 0) {
            HashMap<EObject, IssueDelta> issueDeltas = new HashMap<EObject, IssueDelta>();
            int i = 0;
            while (i < markerDeltas.length) {
                IMarkerDelta markerDelta = markerDeltas[i];
                if ("org.eclipse.stardust.modeling.validation.wfModelValidationMarker".equals(markerDelta.getType())) {
                    IssueDelta iDelta;
                    EObject element;
                    Issue issue;
                    if (1 == markerDelta.getKind()) {
                        Issue issue2;
                        ValidationMarkerService validationService = ValidationMarkerService.getInstance();
                        Issue issue3 = issue2 = validationService != null ? validationService.resolveMapping(markerDelta.getResource(), markerDelta.getId()) : null;
                        if (issue2 != null) {
                            this.markerMapping.put(new Long(markerDelta.getId()), issue2);
                            EObject element2 = issue2.getModelElement();
                            if (element2 != null) {
                                IssueDelta iDelta2 = (IssueDelta)issueDeltas.get(element2);
                                if (iDelta2 == null) {
                                    iDelta2 = new IssueDelta((Object)element2);
                                    issueDeltas.put(element2, iDelta2);
                                }
                                iDelta2.issueAdded(issue2);
                            }
                        }
                    } else if (4 == markerDelta.getKind()) {
                        issue = (Issue)this.markerMapping.get(new Long(markerDelta.getId()));
                        if (issue != null && (element = issue.getModelElement()) != null) {
                            iDelta = (IssueDelta)issueDeltas.get(element);
                            if (iDelta == null) {
                                iDelta = new IssueDelta((Object)element);
                                issueDeltas.put(element, iDelta);
                            }
                            iDelta.issueModified(issue);
                        }
                    } else if (2 == markerDelta.getKind() && (issue = (Issue)this.markerMapping.get(new Long(markerDelta.getId()))) != null) {
                        element = issue.getModelElement();
                        if (element != null) {
                            iDelta = (IssueDelta)issueDeltas.get(element);
                            if (iDelta == null) {
                                iDelta = new IssueDelta((Object)element);
                                issueDeltas.put(element, iDelta);
                            }
                            iDelta.issueRemoved(issue);
                        }
                        this.markerMapping.remove(new Long(markerDelta.getId()));
                    }
                }
                ++i;
            }
            this.issueManager.handleIssueUpdate(issueDeltas.values().toArray(IssueDelta.ISSUE_DELTA_ARRAY));
        }
        return false;
    }
}

