/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.core.editors;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.requests.CreationFactory;
import org.eclipse.stardust.model.xpdl.carnot.ActivityImplementationType;
import org.eclipse.stardust.model.xpdl.carnot.ActivityType;
import org.eclipse.stardust.model.xpdl.carnot.ApplicationContextTypeType;
import org.eclipse.stardust.model.xpdl.carnot.ApplicationType;
import org.eclipse.stardust.model.xpdl.carnot.CarnotWorkflowModelFactory;
import org.eclipse.stardust.model.xpdl.carnot.CarnotWorkflowModelPackage;
import org.eclipse.stardust.model.xpdl.carnot.ContextType;
import org.eclipse.stardust.model.xpdl.carnot.DataType;
import org.eclipse.stardust.model.xpdl.carnot.DataTypeType;
import org.eclipse.stardust.model.xpdl.carnot.DiagramModeType;
import org.eclipse.stardust.model.xpdl.carnot.DiagramType;
import org.eclipse.stardust.model.xpdl.carnot.IModelElement;
import org.eclipse.stardust.model.xpdl.carnot.ModelType;
import org.eclipse.stardust.model.xpdl.carnot.OrientationType;
import org.eclipse.stardust.model.xpdl.carnot.PoolSymbol;
import org.eclipse.stardust.model.xpdl.carnot.ProcessDefinitionType;
import org.eclipse.stardust.model.xpdl.carnot.SubProcessModeType;
import org.eclipse.stardust.model.xpdl.carnot.spi.IDataInitializer;
import org.eclipse.stardust.model.xpdl.carnot.util.DiagramUtil;
import org.eclipse.stardust.model.xpdl.carnot.util.ModelUtils;
import org.eclipse.stardust.model.xpdl.xpdl2.FormalParametersType;
import org.eclipse.stardust.model.xpdl.xpdl2.XpdlPackage;
import org.eclipse.stardust.modeling.common.ui.IdFactory;
import org.eclipse.stardust.modeling.core.Diagram_Messages;
import org.eclipse.stardust.modeling.core.editors.EditPartRegistry;
import org.eclipse.stardust.modeling.core.editors.parts.diagram.commands.CommandHolder;
import org.eclipse.stardust.modeling.core.editors.parts.diagram.commands.CompoundDiagramCommand;
import org.eclipse.stardust.modeling.core.editors.parts.diagram.commands.CreateMetaTypeCommand;
import org.eclipse.stardust.modeling.core.editors.parts.diagram.commands.CreateModelElementCommand;
import org.eclipse.stardust.modeling.core.editors.parts.diagram.commands.CreateSymbolCommand;
import org.eclipse.stardust.modeling.core.editors.parts.diagram.commands.CreateTypedModelElementCommand;
import org.eclipse.stardust.modeling.core.editors.parts.diagram.commands.SetValueCmd;
import org.eclipse.ui.PlatformUI;

public class NodeCreationFactory {
    public static CreationFactory getEventFactory(IConfigurationElement config, boolean isEnding) {
        IdFactory id = new IdFactory(config == null ? (isEnding ? "EndEvent" : "StartEvent") : config.getAttribute("id"), config == null ? (isEnding ? "End Event" : "Start Event") : config.getAttribute("name"));
        CompoundDiagramCommand compound = new CompoundDiagramCommand();
        if (config != null) {
            compound.add(new CreateMetaTypeCommand(config, CarnotWorkflowModelPackage.eINSTANCE.getTriggerTypeType(), new EStructuralFeature[]{CarnotWorkflowModelPackage.eINSTANCE.getTriggerTypeType_PullTrigger()}));
            compound.add(new CreateTypedModelElementCommand(1, id, config.getAttribute("id"), (EStructuralFeature)CarnotWorkflowModelPackage.eINSTANCE.getModelType_TriggerType(), CarnotWorkflowModelPackage.eINSTANCE.getTriggerType()));
        }
        EClass ref = isEnding ? CarnotWorkflowModelPackage.eINSTANCE.getEndEventSymbol() : CarnotWorkflowModelPackage.eINSTANCE.getStartEventSymbol();
        compound.add(new CreateSymbolCommand(0, id, ref));
        return new CommandHolder(id, compound, ref);
    }

    public static CreationFactory getProcessInterfaceFactory(IConfigurationElement config) {
        IdFactory id = new IdFactory(config == null ? "ProcessInterface" : config.getAttribute("id"), config == null ? "ProcessInterface" : config.getAttribute("name"));
        CompoundDiagramCommand compound = new CompoundDiagramCommand();
        FormalParametersType fmt = XpdlPackage.eINSTANCE.getXpdlFactory().createFormalParametersType();
        SetValueCmd command = new SetValueCmd(1, (EStructuralFeature)CarnotWorkflowModelPackage.eINSTANCE.getProcessDefinitionType_FormalParameters(), (Object)fmt);
        compound.add(command);
        EClass ref = CarnotWorkflowModelPackage.eINSTANCE.getPublicInterfaceSymbol();
        compound.add(new CreateSymbolCommand(0, id, ref));
        return new CommandHolder(id, compound, ref);
    }

    public static CreationFactory getDataFactory(IConfigurationElement config) {
        IdFactory id = new IdFactory(config == null ? "data" : config.getAttribute("id"), config == null ? Diagram_Messages.NodeCreationFactory_BASENAME_Data : config.getAttribute("name"));
        CompoundDiagramCommand command = new CompoundDiagramCommand();
        if (config != null) {
            command.add(new CreateMetaTypeCommand(config, CarnotWorkflowModelPackage.eINSTANCE.getDataTypeType(), new EStructuralFeature[0]));
        }
        command.add(new CreateTypedModelElementCommand(2, id, config == null ? null : config.getAttribute("id"), (EStructuralFeature)CarnotWorkflowModelPackage.eINSTANCE.getModelType_DataType(), CarnotWorkflowModelPackage.eINSTANCE.getDataType()){

            @Override
            protected IModelElement createModelElement() {
                List attributes;
                DataType element = (DataType)super.createModelElement();
                IDataInitializer initializer = ModelUtils.getInitializer((DataTypeType)element.getType());
                if (initializer != null && (attributes = initializer.initialize(element, Collections.EMPTY_LIST)) != null) {
                    element.getAttribute().addAll((Collection)attributes);
                }
                return element;
            }
        });
        command.add(new CreateSymbolCommand(0, id, CarnotWorkflowModelPackage.eINSTANCE.getDataSymbolType()));
        return new CommandHolder(id, command, CarnotWorkflowModelPackage.eINSTANCE.getDataSymbolType());
    }

    public static CreationFactory getRoleFactory() {
        IdFactory id = new IdFactory("Role", Diagram_Messages.BASENAME_Role);
        CompoundDiagramCommand command = new CompoundDiagramCommand();
        command.add(new CreateModelElementCommand(2, id, CarnotWorkflowModelPackage.eINSTANCE.getRoleType()));
        command.add(new CreateSymbolCommand(0, id, CarnotWorkflowModelPackage.eINSTANCE.getRoleSymbolType()));
        return new CommandHolder(id, command, CarnotWorkflowModelPackage.eINSTANCE.getRoleSymbolType());
    }

    public static CreationFactory getOrganizationFactory() {
        IdFactory id = new IdFactory("Organization", Diagram_Messages.BASENAME_Organization);
        CompoundDiagramCommand command = new CompoundDiagramCommand();
        command.add(new CreateModelElementCommand(2, id, CarnotWorkflowModelPackage.eINSTANCE.getOrganizationType()));
        command.add(new CreateSymbolCommand(0, id, CarnotWorkflowModelPackage.eINSTANCE.getOrganizationSymbolType()));
        return new CommandHolder(id, command, CarnotWorkflowModelPackage.eINSTANCE.getOrganizationSymbolType());
    }

    public static CreationFactory getConditionalPerformerFactory() {
        IdFactory id = new IdFactory("ConditionalPerformer", Diagram_Messages.BASENAME_ConditionalPerformer);
        CompoundDiagramCommand command = new CompoundDiagramCommand();
        command.add(new CreateModelElementCommand(2, id, CarnotWorkflowModelPackage.eINSTANCE.getConditionalPerformerType()));
        command.add(new CreateSymbolCommand(0, id, CarnotWorkflowModelPackage.eINSTANCE.getConditionalPerformerSymbolType()));
        return new CommandHolder(id, command, CarnotWorkflowModelPackage.eINSTANCE.getConditionalPerformerSymbolType());
    }

    public static CreationFactory getApplicationFactory(IConfigurationElement config) {
        IdFactory id = new IdFactory(config == null ? "application" : config.getAttribute("id"), config == null ? Diagram_Messages.NodeCreationFactory_BASENAME_Application : config.getAttribute("name"));
        CompoundDiagramCommand command = new CompoundDiagramCommand();
        if (config != null) {
            command.add(new CreateMetaTypeCommand(config, CarnotWorkflowModelPackage.eINSTANCE.getApplicationTypeType(), new EStructuralFeature[]{CarnotWorkflowModelPackage.eINSTANCE.getApplicationTypeType_Synchronous()}));
        }
        command.add(new CreateTypedModelElementCommand(2, id, config == null ? null : config.getAttribute("id"), (EStructuralFeature)CarnotWorkflowModelPackage.eINSTANCE.getModelType_ApplicationType(), CarnotWorkflowModelPackage.eINSTANCE.getApplicationType()));
        command.add(new CreateSymbolCommand(0, id, CarnotWorkflowModelPackage.eINSTANCE.getApplicationSymbolType()));
        return new CommandHolder(id, command, CarnotWorkflowModelPackage.eINSTANCE.getApplicationSymbolType());
    }

    public static CreationFactory getContextFactory(final IConfigurationElement config) {
        IdFactory id = new IdFactory("interactive", Diagram_Messages.BASENAME_InteractiveApplication);
        CompoundDiagramCommand command = new CompoundDiagramCommand();
        command.add(new CreateMetaTypeCommand(config, CarnotWorkflowModelPackage.eINSTANCE.getApplicationContextTypeType(), new EStructuralFeature[]{CarnotWorkflowModelPackage.eINSTANCE.getApplicationContextTypeType_HasMappingId(), CarnotWorkflowModelPackage.eINSTANCE.getApplicationContextTypeType_HasApplicationPath()}));
        command.add(new CreateModelElementCommand(2, id, CarnotWorkflowModelPackage.eINSTANCE.getApplicationType()){

            @Override
            protected IModelElement createModelElement() {
                ApplicationType application = (ApplicationType)super.createModelElement();
                application.setInteractive(true);
                CarnotWorkflowModelFactory factory = CarnotWorkflowModelFactory.eINSTANCE;
                ContextType context = factory.createContextType();
                context.setType(NodeCreationFactory.getApplicationContextType(this.getModel(), config.getAttribute("id")));
                application.getContext().add((Object)context);
                return application;
            }
        });
        command.add(new CreateSymbolCommand(0, id, CarnotWorkflowModelPackage.eINSTANCE.getApplicationSymbolType()));
        return new CommandHolder(id, command, CarnotWorkflowModelPackage.eINSTANCE.getApplicationSymbolType());
    }

    private static ApplicationContextTypeType getApplicationContextType(ModelType model, String id) {
        return (ApplicationContextTypeType)ModelUtils.findIdentifiableElement((EObject)model, (EStructuralFeature)CarnotWorkflowModelPackage.eINSTANCE.getModelType_ApplicationContextType(), (String)id);
    }

    public static CreationFactory getActivityFactory(final ActivityImplementationType implementation) {
        IdFactory id = new IdFactory("Activity", implementation == null ? "Activity" : String.valueOf(ModelUtils.getActivityImplementationTypeText((ActivityImplementationType)implementation)) + Diagram_Messages.BASENAME_P2_Activity);
        CompoundDiagramCommand command = new CompoundDiagramCommand();
        command.add(new CreateModelElementCommand(1, id, CarnotWorkflowModelPackage.eINSTANCE.getActivityType()){

            @Override
            protected IModelElement createModelElement() {
                ActivityType activity = (ActivityType)super.createModelElement();
                if (activity != null) {
                    activity.setImplementation(implementation);
                    if (ActivityImplementationType.SUBPROCESS_LITERAL.equals((Object)implementation)) {
                        activity.setSubProcessMode(SubProcessModeType.SYNC_SHARED_LITERAL);
                    }
                }
                return activity;
            }
        });
        command.add(new CreateSymbolCommand(0, id, CarnotWorkflowModelPackage.eINSTANCE.getActivitySymbolType()));
        return new CommandHolder(id, command, CarnotWorkflowModelPackage.eINSTANCE.getActivitySymbolType());
    }

    public static CreationFactory getProcessDefinitionFactory() {
        IdFactory id = new IdFactory("ProcessDefinition", Diagram_Messages.BASENAME_ProcessDefinition);
        CompoundDiagramCommand command = new CompoundDiagramCommand();
        command.add(new CreateModelElementCommand(2, id, CarnotWorkflowModelPackage.eINSTANCE.getProcessDefinitionType()){

            @Override
            protected IModelElement createModelElement() {
                ProcessDefinitionType process = (ProcessDefinitionType)super.createModelElement();
                CarnotWorkflowModelFactory factory = CarnotWorkflowModelFactory.eINSTANCE;
                DiagramType diagram = factory.createDiagramType();
                diagram.setName(Diagram_Messages.DIAGRAM_NAME_Default);
                diagram.setOrientation(OrientationType.VERTICAL_LITERAL.toString().equals(PlatformUI.getPreferenceStore().getString("org.eclipse.stardust.modeling.common.projectnature.modelingDirection")) ? OrientationType.VERTICAL_LITERAL : OrientationType.HORIZONTAL_LITERAL);
                DiagramModeType defaultMode = PlatformUI.getPreferenceStore().getBoolean("org.eclipse.stardust.modeling.common.projectnature.classicMode") ? DiagramModeType.MODE_400_LITERAL : DiagramModeType.MODE_450_LITERAL;
                diagram.setMode(defaultMode);
                process.getDiagram().add((Object)diagram);
                PoolSymbol pool = DiagramUtil.createDefaultPool(null);
                diagram.getPoolSymbols().add((Object)pool);
                return process;
            }
        });
        command.add(new CreateSymbolCommand(0, id, CarnotWorkflowModelPackage.eINSTANCE.getProcessSymbolType()));
        return new CommandHolder(id, command, CarnotWorkflowModelPackage.eINSTANCE.getProcessSymbolType());
    }

    public static CreationFactory getModelerFactory() {
        IdFactory id = new IdFactory("Modeler", Diagram_Messages.BASENAME_Modeler);
        CompoundDiagramCommand command = new CompoundDiagramCommand();
        command.add(new CreateModelElementCommand(2, id, CarnotWorkflowModelPackage.eINSTANCE.getModelerType()));
        command.add(new CreateSymbolCommand(0, id, CarnotWorkflowModelPackage.eINSTANCE.getModelerSymbolType()));
        return new CommandHolder(id, command, CarnotWorkflowModelPackage.eINSTANCE.getModelerSymbolType());
    }

    public static CreationFactory getPoolFactory() {
        IdFactory id = new IdFactory("Pool", Diagram_Messages.BASENAME_Pool);
        CreateSymbolCommand command = new CreateSymbolCommand(4, id, CarnotWorkflowModelPackage.eINSTANCE.getPoolSymbol());
        return new CommandHolder(id, command, CarnotWorkflowModelPackage.eINSTANCE.getPoolSymbol());
    }

    public static CreationFactory getLaneFactory() {
        IdFactory id = new IdFactory("Lane", Diagram_Messages.BASENAME_Lane);
        CreateSymbolCommand command = new CreateSymbolCommand(3, id, CarnotWorkflowModelPackage.eINSTANCE.getLaneSymbol());
        return new CommandHolder(id, command, CarnotWorkflowModelPackage.eINSTANCE.getLaneSymbol());
    }

    public static CreationFactory getTextFactory(EditPartRegistry registry) {
        return NodeCreationFactory.createAndEditSymbol(Diagram_Messages.BASENAME_Text, CarnotWorkflowModelPackage.eINSTANCE.getTextSymbolType(), registry);
    }

    public static CreationFactory getAnnotationFactory(EditPartRegistry registry) {
        return NodeCreationFactory.createAndEditSymbol(Diagram_Messages.BASENAME_Annotation, CarnotWorkflowModelPackage.eINSTANCE.getAnnotationSymbolType(), registry);
    }

    private static CreationFactory createAndEditSymbol(String base, EClass eClass, final EditPartRegistry registry) {
        final Object[] model = new Object[1];
        IdFactory id = new IdFactory(base, base);
        CreateSymbolCommand symCmd = new CreateSymbolCommand(0, id, eClass){

            @Override
            protected IModelElement createModelElement() {
                model[0] = super.createModelElement();
                return (IModelElement)model[0];
            }
        };
        CompoundDiagramCommand command = new CompoundDiagramCommand();
        command.add(symCmd);
        command.add(new Command(){

            public void execute() {
                Request request = new Request((Object)"direct edit");
                EditPart editPart = registry.findEditPart(model[0]);
                editPart.performRequest(request);
            }

            public void redo() {
            }
        });
        return new CommandHolder(id, command, eClass);
    }
}

