/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.core.editors;

import java.text.MessageFormat;
import java.util.ArrayList;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.stardust.modeling.common.ui.jface.utils.FormBuilder;
import org.eclipse.stardust.modeling.core.DiagramPlugin;
import org.eclipse.stardust.modeling.core.Diagram_Messages;
import org.eclipse.stardust.modeling.core.editors.WorkflowModelEditor;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.EditorPart;

public class UpgradePage
extends EditorPart {
    private final WorkflowModelEditor cwmEditor;
    private Composite partControl;
    private ControlListener controlListener;
    private PaintListener paintListener;
    private String moduleError;

    public UpgradePage(WorkflowModelEditor editor) {
        this.cwmEditor = editor;
        this.updateStrings();
    }

    public String getPageName() {
        return Diagram_Messages.TXT_OLD_MD_FORMAT;
    }

    public void dispose() {
        if (!this.partControl.isDisposed()) {
            this.partControl.removeControlListener(this.controlListener);
            this.controlListener = null;
            this.partControl.removePaintListener(this.paintListener);
            this.paintListener = null;
        }
        super.dispose();
    }

    public void doSave(IProgressMonitor monitor) {
        this.cwmEditor.doSave(monitor);
    }

    public void doSaveAs() {
        this.cwmEditor.doSaveAs();
    }

    public boolean isSaveAsAllowed() {
        return this.cwmEditor.isSaveAsAllowed();
    }

    public final boolean isDirty() {
        return this.cwmEditor.isDirty();
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        this.setSite((IWorkbenchPartSite)site);
        this.setInput(input);
        this.setPartName(this.getPageName());
    }

    public void setFocus() {
    }

    public final void createPartControl(Composite parent) {
        this.partControl = new Composite(parent, 0);
        GridLayout pageLayout = new GridLayout(1, false);
        pageLayout.marginHeight = 0;
        pageLayout.marginWidth = 0;
        pageLayout.verticalSpacing = 0;
        pageLayout.horizontalSpacing = 0;
        this.partControl.setLayout((Layout)pageLayout);
        Composite topPanel = new Composite(this.partControl, 0);
        topPanel.setLayoutData((Object)new GridData(4, 128, true, false));
        GridLayout layout = new GridLayout(3, false);
        layout.marginHeight = 10;
        layout.marginWidth = 10;
        layout.verticalSpacing = 5;
        layout.horizontalSpacing = 5;
        topPanel.setLayout((Layout)layout);
        topPanel.setBackground(parent.getDisplay().getSystemColor(25));
        topPanel.setForeground(parent.getDisplay().getSystemColor(24));
        Label label = FormBuilder.createLabel((Composite)topPanel, (String)this.getTitle(), (int)3);
        label.setFont(JFaceResources.getFontRegistry().get("org.eclipse.jface.headerfont"));
        label.setBackground(topPanel.getBackground());
        label.setForeground(topPanel.getForeground());
        Label lblLicensePath = FormBuilder.createLabel((Composite)topPanel, (String)Diagram_Messages.LBL_MD_MUST_BE_UPGRADE);
        lblLicensePath.setBackground(topPanel.getBackground());
        lblLicensePath.setForeground(topPanel.getForeground());
        FormBuilder.createButton((Composite)topPanel, (String)Diagram_Messages.BUT_UPRGADE_NOW, (SelectionListener)new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                UpgradePage.this.cwmEditor.doUpgradeModel();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        FormBuilder.createButton((Composite)topPanel, (String)Diagram_Messages.BUT_CLOSE_EDITOR, (SelectionListener)new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                UpgradePage.this.cwmEditor.closeEditor(false);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        Composite logoPanel = new Composite(this.partControl, 0);
        logoPanel.setLayout((Layout)new GridLayout());
        logoPanel.setBackground(parent.getDisplay().getSystemColor(25));
        logoPanel.setForeground(parent.getDisplay().getSystemColor(24));
        logoPanel.setLayoutData((Object)new GridData(1808));
        this.createPageControl(logoPanel);
    }

    protected void createPageControl(Composite parent) {
        final Image image = DiagramPlugin.getImage("icons/default_panel.gif");
        this.controlListener = new ControlListener(){

            public void controlMoved(ControlEvent e) {
            }

            public void controlResized(ControlEvent e) {
                Control control = (Control)e.widget;
                control.redraw();
            }
        };
        parent.addControlListener(this.controlListener);
        this.paintListener = new PaintListener(){

            public void paintControl(PaintEvent e) {
                Rectangle size = image.getBounds();
                Control control = (Control)e.widget;
                Point pageSize = control.getSize();
                int left = (pageSize.x - size.width) / 2;
                Color foreground = e.gc.getForeground();
                int width = size.width;
                int start = 5;
                if (UpgradePage.this.moduleError != null) {
                    int leftError = left + 70;
                    start = UpgradePage.this.drawString(e.gc, UpgradePage.this.moduleError, leftError, start + 8, new Color(null, 166, 0, 0), ColorConstants.darkGray, 1, width);
                }
                e.gc.setForeground(foreground);
                int top = Math.max((pageSize.y - size.height) / 2, start);
                e.gc.drawImage(image, left, top);
            }
        };
        parent.addPaintListener(this.paintListener);
    }

    private int drawString(GC gc, String fullText, int left, int start, Color base, Color shadow, int delta, int maxWidth) {
        ArrayList<String> paragraphs = this.splitParagraphs(fullText);
        int p = 0;
        while (p < paragraphs.size()) {
            ArrayList<String> splits = this.splitString(gc, paragraphs.get(p), maxWidth);
            int i = 0;
            while (i < splits.size()) {
                String text = splits.get(i);
                gc.setForeground(base);
                gc.drawString(text, left, start, true);
                start += gc.getFontMetrics().getHeight();
                ++i;
            }
            if (p < paragraphs.size() - 1) {
                start += 8;
            }
            ++p;
        }
        return start;
    }

    private ArrayList<String> splitParagraphs(String text) {
        ArrayList<String> list = new ArrayList<String>();
        int pos = 0;
        while (pos >= 0) {
            int newPos = text.indexOf("\n\n", pos);
            if (newPos < 0) {
                list.add(text.substring(pos));
                pos = newPos;
                continue;
            }
            list.add(text.substring(pos, newPos));
            pos = newPos + 2;
        }
        return list;
    }

    private ArrayList<String> splitString(GC gc, String text, int maxWidth) {
        text = text.replace('\n', ' ');
        ArrayList<String> list = new ArrayList<String>();
        int pos = 0;
        while (pos >= 0 && gc.stringExtent((String)text.substring((int)pos)).x > maxWidth) {
            int breakPos = text.lastIndexOf(32);
            while (breakPos > pos && gc.stringExtent((String)text.substring((int)pos, (int)breakPos)).x > maxWidth) {
                breakPos = text.lastIndexOf(32, breakPos - 1);
            }
            if (breakPos > pos) {
                list.add(text.substring(pos, breakPos));
                pos = breakPos + 1;
                continue;
            }
            pos = -1;
        }
        list.add(text.substring(pos));
        return list;
    }

    public Control getPartControl() {
        return this.partControl;
    }

    public void redraw() {
        this.updateStrings();
        this.partControl.redraw();
    }

    private void updateStrings() {
        this.moduleError = MessageFormat.format(Diagram_Messages.ERROR_UNSUPPORTED_MD_VERSION, this.cwmEditor.getWorkflowModel().getCarnotVersion());
    }
}

