/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.core.editors.cap;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.stardust.common.StringUtils;
import org.eclipse.stardust.engine.extensions.dms.data.DmsConstants;
import org.eclipse.stardust.model.xpdl.carnot.AccessPointType;
import org.eclipse.stardust.model.xpdl.carnot.ActivityType;
import org.eclipse.stardust.model.xpdl.carnot.ApplicationContextTypeType;
import org.eclipse.stardust.model.xpdl.carnot.ApplicationType;
import org.eclipse.stardust.model.xpdl.carnot.ApplicationTypeType;
import org.eclipse.stardust.model.xpdl.carnot.AttributeType;
import org.eclipse.stardust.model.xpdl.carnot.BindActionType;
import org.eclipse.stardust.model.xpdl.carnot.CarnotWorkflowModelFactory;
import org.eclipse.stardust.model.xpdl.carnot.Code;
import org.eclipse.stardust.model.xpdl.carnot.ConditionalPerformerType;
import org.eclipse.stardust.model.xpdl.carnot.ContextType;
import org.eclipse.stardust.model.xpdl.carnot.DataMappingType;
import org.eclipse.stardust.model.xpdl.carnot.DataPathType;
import org.eclipse.stardust.model.xpdl.carnot.DataType;
import org.eclipse.stardust.model.xpdl.carnot.DataTypeType;
import org.eclipse.stardust.model.xpdl.carnot.DiagramType;
import org.eclipse.stardust.model.xpdl.carnot.EventActionType;
import org.eclipse.stardust.model.xpdl.carnot.EventActionTypeType;
import org.eclipse.stardust.model.xpdl.carnot.EventConditionTypeType;
import org.eclipse.stardust.model.xpdl.carnot.EventHandlerType;
import org.eclipse.stardust.model.xpdl.carnot.IConnectionSymbol;
import org.eclipse.stardust.model.xpdl.carnot.IExtensibleElement;
import org.eclipse.stardust.model.xpdl.carnot.IIdentifiableElement;
import org.eclipse.stardust.model.xpdl.carnot.IIdentifiableModelElement;
import org.eclipse.stardust.model.xpdl.carnot.IModelElement;
import org.eclipse.stardust.model.xpdl.carnot.IModelElementNodeSymbol;
import org.eclipse.stardust.model.xpdl.carnot.IModelParticipant;
import org.eclipse.stardust.model.xpdl.carnot.IdentifiableReference;
import org.eclipse.stardust.model.xpdl.carnot.LaneSymbol;
import org.eclipse.stardust.model.xpdl.carnot.ModelType;
import org.eclipse.stardust.model.xpdl.carnot.OrganizationType;
import org.eclipse.stardust.model.xpdl.carnot.ParameterMappingType;
import org.eclipse.stardust.model.xpdl.carnot.ParticipantType;
import org.eclipse.stardust.model.xpdl.carnot.ProcessDefinitionType;
import org.eclipse.stardust.model.xpdl.carnot.RoleType;
import org.eclipse.stardust.model.xpdl.carnot.TransitionConnectionType;
import org.eclipse.stardust.model.xpdl.carnot.TransitionType;
import org.eclipse.stardust.model.xpdl.carnot.TriggerType;
import org.eclipse.stardust.model.xpdl.carnot.TriggerTypeType;
import org.eclipse.stardust.model.xpdl.carnot.UnbindActionType;
import org.eclipse.stardust.model.xpdl.carnot.merge.MergeUtils;
import org.eclipse.stardust.model.xpdl.carnot.merge.UUIDUtils;
import org.eclipse.stardust.model.xpdl.carnot.util.AttributeUtil;
import org.eclipse.stardust.model.xpdl.carnot.util.DiagramUtil;
import org.eclipse.stardust.model.xpdl.carnot.util.ModelUtils;
import org.eclipse.stardust.model.xpdl.carnot.util.ModelVariable;
import org.eclipse.stardust.model.xpdl.carnot.util.VariableContext;
import org.eclipse.stardust.model.xpdl.carnot.util.VariableContextHelper;
import org.eclipse.stardust.model.xpdl.xpdl2.ExtendedAttributesType;
import org.eclipse.stardust.model.xpdl.xpdl2.Extensible;
import org.eclipse.stardust.model.xpdl.xpdl2.ExternalReferenceType;
import org.eclipse.stardust.model.xpdl.xpdl2.SchemaTypeType;
import org.eclipse.stardust.model.xpdl.xpdl2.TypeDeclarationType;
import org.eclipse.stardust.model.xpdl.xpdl2.TypeDeclarationsType;
import org.eclipse.stardust.model.xpdl.xpdl2.XpdlFactory;
import org.eclipse.stardust.model.xpdl.xpdl2.XpdlTypeType;
import org.eclipse.stardust.model.xpdl.xpdl2.util.ExtendedAttributeUtil;
import org.eclipse.stardust.model.xpdl.xpdl2.util.TypeDeclarationUtils;
import org.eclipse.stardust.modeling.common.platform.utils.WorkspaceUtils;
import org.eclipse.stardust.modeling.core.Diagram_Messages;
import org.eclipse.stardust.modeling.core.editors.cap.ConnectionUtils;
import org.eclipse.stardust.modeling.core.editors.cap.ContentDecorator;
import org.eclipse.stardust.modeling.core.editors.cap.CopyPasteUtil;
import org.eclipse.stardust.modeling.core.editors.cap.InputContainer;
import org.eclipse.stardust.modeling.core.editors.cap.MergerUtil;
import org.eclipse.stardust.modeling.core.editors.cap.NameIDCache;
import org.eclipse.stardust.modeling.core.editors.cap.NameIdDialog;
import org.eclipse.stardust.modeling.core.editors.cap.ReferenceValueDialog;
import org.eclipse.stardust.modeling.core.editors.cap.StoreObject;
import org.eclipse.stardust.modeling.core.utils.GenericUtils;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.xsd.XSDElementDeclaration;
import org.eclipse.xsd.XSDImport;
import org.eclipse.xsd.XSDNamedComponent;
import org.eclipse.xsd.XSDSchema;
import org.eclipse.xsd.XSDTypeDefinition;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public abstract class AbstractMerger {
    public static final String AUTHORIZATION_SCOPE = "authorization:";
    protected Set structuredData = new HashSet();
    protected List structuredDataNameIdCache = new ArrayList();
    private Map structuredDataChangedCache = new HashMap();
    private TypeDeclarationsType targetDeclarations;
    protected boolean externalReferences = false;
    protected boolean showDialog = false;
    protected Map mergeElements = new HashMap();
    protected Map<ProcessDefinitionType, ProcessDefinitionType> processes = new HashMap<ProcessDefinitionType, ProcessDefinitionType>();
    protected Map processChildren = new HashMap();
    protected Map<DiagramType, DiagramType> diagrams = new HashMap<DiagramType, DiagramType>();
    protected Map<ActivityType, ActivityType> activities = new HashMap<ActivityType, ActivityType>();
    protected Map<TypeDeclarationType, TypeDeclarationType> typeDeclarationElements = new HashMap<TypeDeclarationType, TypeDeclarationType>();
    protected Map elements = new HashMap();
    protected Map globalElements = new HashMap();
    protected Map processElements = new HashMap();
    protected InputContainer referenceValueInput = new InputContainer();
    protected InputContainer.Container container = null;
    protected EcoreUtil.Copier copier = new EcoreUtil.Copier(){
        private static final long serialVersionUID = 1L;

        public EObject copy(EObject object) {
            if (object instanceof XSDSchema) {
                XSDSchema original = (XSDSchema)object;
                XSDSchema clone = (XSDSchema)original.cloneConcreteComponent(true, false);
                Document doc = clone.updateDocument();
                if (original.getElement() != null) {
                    Element clonedElement = (Element)doc.importNode(original.getElement(), true);
                    doc.appendChild(clonedElement);
                    clone.setElement(clonedElement);
                }
                return clone;
            }
            return super.copy(object);
        }
    };
    protected Map nameIdCache = new HashMap();
    protected long highestOid = 0L;
    protected boolean modelChanged = false;
    protected StoreObject storage;
    protected ModelType targetModel;
    protected DiagramType targetDiagram;
    protected ProcessDefinitionType targetProcess;
    protected boolean isDiagram = false;
    private List<ModelVariable> targetVariables;
    protected boolean isSameModel = false;
    private IProject targetProject;
    private Set xsdFiles = new HashSet();
    protected Map<EObject, EObject> changedCache = new HashMap<EObject, EObject>();

    public abstract void merge();

    public AbstractMerger(ModelType targetModel, StoreObject storage) {
        VariableContext context;
        this.storage = storage;
        this.targetModel = targetModel;
        this.collectTargetData();
        this.container = this.referenceValueInput.getContainer();
        this.isSameModel = storage.isSameModel();
        storage.setTargetModel(targetModel);
        this.targetProject = WorkspaceUtils.getProjectFromEObject((EObject)targetModel);
        if (!this.isSameModel && (context = VariableContextHelper.getInstance().getContext(targetModel)) != null) {
            context.refreshVariables((EObject)targetModel);
            this.targetVariables = new ArrayList<ModelVariable>(context.getVariables());
        }
    }

    protected void collectTargetData() {
        this.highestOid = ModelUtils.getMaxUsedOid((ModelType)this.targetModel);
        TreeIterator i = this.targetModel.eAllContents();
        while (i.hasNext()) {
            String name;
            String id;
            EObject child = (EObject)i.next();
            EClass eClass = child.eClass();
            EObject parent = child.eContainer();
            HashMap eClassNameIdCache = new HashMap();
            Object localNameIdCache = null;
            if (this.nameIdCache.containsKey(parent) && (eClassNameIdCache = (HashMap)this.nameIdCache.get(parent)).containsKey(eClass)) {
                localNameIdCache = child instanceof DiagramType ? (List)eClassNameIdCache.get(eClass) : (HashMap)eClassNameIdCache.get(eClass);
            }
            if (localNameIdCache == null) {
                localNameIdCache = child instanceof DiagramType ? new ArrayList() : new HashMap();
            }
            if (child instanceof IIdentifiableElement) {
                id = ((IIdentifiableElement)child).getId();
                name = ((IIdentifiableElement)child).getName();
                ((HashMap)localNameIdCache).put(id, name);
                eClassNameIdCache.put(eClass, localNameIdCache);
            } else if (child instanceof IModelElement && child instanceof DiagramType) {
                name = ((DiagramType)child).getName();
                ((ArrayList)localNameIdCache).add(name);
                eClassNameIdCache.put(eClass, localNameIdCache);
            }
            if (child instanceof TypeDeclarationType) {
                id = ((TypeDeclarationType)child).getId();
                name = ((TypeDeclarationType)child).getName();
                ((HashMap)localNameIdCache).put(id, name);
                eClassNameIdCache.put(eClass, localNameIdCache);
            }
            this.nameIdCache.put(parent, eClassNameIdCache);
        }
    }

    public Map<EObject, EObject> getChangedCache() {
        return this.changedCache;
    }

    protected boolean checkElementInModel(Map.Entry entry) {
        EObject raw = (EObject)entry.getKey();
        EObject copy = (EObject)entry.getValue();
        EClass eClass = copy.eClass();
        EObject parent = raw.eContainer();
        EObject checkParent = this.changedCache.get(parent);
        if (checkParent != null) {
            parent = checkParent;
        }
        parent = CopyPasteUtil.getSameModelElement(parent, this.targetModel, null);
        if (!this.processChildren.isEmpty() && this.processChildren.containsKey(raw) && (raw instanceof ActivityType || raw instanceof TransitionType || raw instanceof TriggerType)) {
            parent = this.storage.getTargetProcess();
        }
        if (this.isDiagram && (parent instanceof ProcessDefinitionType || raw instanceof ActivityType && parent == null || raw instanceof TransitionType && parent == null || raw instanceof TriggerType && parent == null)) {
            parent = this.storage.getTargetProcess();
        }
        HashMap eClassNameIdCache = new HashMap();
        Object localNameIdCache = null;
        if (this.nameIdCache.containsKey(parent) && (eClassNameIdCache = (HashMap)this.nameIdCache.get(parent)).containsKey(eClass)) {
            if (copy instanceof DiagramType) {
                String name = ((DiagramType)copy).getName();
                localNameIdCache = (List)eClassNameIdCache.get(eClass);
                if (((ArrayList)localNameIdCache).contains(name)) {
                    return true;
                }
            } else if (copy instanceof IIdentifiableElement) {
                String id = ((IIdentifiableElement)copy).getId();
                String name = ((IIdentifiableElement)copy).getName();
                localNameIdCache = (HashMap)eClassNameIdCache.get(eClass);
                if (((HashMap)localNameIdCache).containsKey(id) || ((HashMap)localNameIdCache).containsValue(name)) {
                    return true;
                }
            } else if (copy instanceof TypeDeclarationType) {
                String id = ((TypeDeclarationType)copy).getId();
                String name = ((TypeDeclarationType)copy).getName();
                localNameIdCache = (HashMap)eClassNameIdCache.get(eClass);
                if (((HashMap)localNameIdCache).containsKey(id) || ((HashMap)localNameIdCache).containsValue(name)) {
                    return true;
                }
            }
        }
        return false;
    }

    protected boolean mergeElement(Map.Entry<EObject, EObject> entry) {
        EObject raw = entry.getKey();
        if (MergerUtil.getEntryFromMap(this.changedCache, raw) == null && this.checkElementInModel(entry)) {
            if (!this.openDialog(entry)) {
                this.modelChanged = false;
                return false;
            }
            this.changedCache.put(entry.getKey(), entry.getValue());
        }
        this.addModelElement(entry, true);
        return true;
    }

    protected boolean addModelElement(Map.Entry entry, boolean copyEntry) {
        ApplicationContextTypeType rawApplicationContextType;
        DataType rawDataType;
        TransitionType rawTransition;
        IIdentifiableModelElement rawModelElement;
        IModelParticipant rawLaneParticipant;
        EventConditionTypeType rawConditionType;
        IIdentifiableModelElement modelElement;
        IIdentifiableModelElement modelElement2;
        EventActionTypeType rawActionType;
        IIdentifiableModelElement modelElement3;
        AttributeType attribute;
        String uuid;
        EObject raw = (EObject)entry.getKey();
        EObject copy = (EObject)entry.getValue();
        EObject parent = raw.eContainer();
        boolean haveParent = false;
        if (!this.processChildren.isEmpty() && this.processChildren.containsKey(raw) && (raw instanceof ActivityType || raw instanceof TransitionType || raw instanceof TriggerType)) {
            parent = this.storage.getTargetProcess();
            haveParent = true;
        }
        if (!haveParent) {
            if (!copyEntry) {
                parent = copy.eContainer();
            } else {
                EObject checkParent = this.changedCache.get(parent);
                if (checkParent != null) {
                    parent = checkParent;
                }
            }
        }
        if (copyEntry) {
            EStructuralFeature feature;
            EObject targetObject = haveParent ? parent : CopyPasteUtil.getSameModelElement(parent, this.targetModel, this.changedCache);
            if (this.isDiagram && parent instanceof ProcessDefinitionType) {
                targetObject = this.storage.getTargetProcess();
            }
            if (parent instanceof TypeDeclarationsType) {
                targetObject = this.targetModel.getTypeDeclarations();
            }
            if ((feature = raw.eContainingFeature()) != null && targetObject != null) {
                List list = (List)targetObject.eGet(feature);
                list.add(copy);
                this.modelChanged = true;
                return true;
            }
            return true;
        }
        EList contentObjects = copy.eContents();
        ArrayList<EObject> removeObjects = new ArrayList<EObject>();
        int i = 0;
        while (i < contentObjects.size()) {
            EObject content = (EObject)contentObjects.get(i);
            if (content instanceof IModelElement) {
                MergerUtil.MergerEntry mergeEntry;
                int index;
                EStructuralFeature feature = content.eContainingFeature();
                EList copy_container = (EList)copy.eGet(feature);
                EList raw_container = (EList)raw.eGet(feature);
                EObject rawContent = (EObject)raw_container.get(index = copy_container.indexOf((Object)content));
                if (rawContent != null && !this.addModelElement(mergeEntry = new MergerUtil.MergerEntry(rawContent, content), false)) {
                    removeObjects.add(content);
                }
            }
            ++i;
        }
        EStructuralFeature feature = copy.eContainingFeature();
        int i2 = 0;
        while (i2 < removeObjects.size()) {
            EObject remove = (EObject)removeObjects.get(i2);
            List list = (List)copy.eGet(feature);
            list.remove(remove);
            ++i2;
        }
        if (copy instanceof TypeDeclarationType && !StringUtils.isEmpty((String)(uuid = UUIDUtils.getUUID((EObject)raw)))) {
            UUIDUtils.setUUID((EObject)((TypeDeclarationType)copy), (String)uuid);
        }
        if (copy instanceof ProcessDefinitionType || copy instanceof DataType || copy instanceof ActivityType) {
            EList attributes = ((IExtensibleElement)raw).getAttribute();
            EList targetAttributes = ((IExtensibleElement)copy).getAttribute();
            int i3 = 0;
            while (i3 < attributes.size()) {
                AttributeType targetAttribute;
                EObject attributeModel;
                attribute = (AttributeType)attributes.get(i3);
                if (attribute.getName().startsWith(AUTHORIZATION_SCOPE) && (attributeModel = AttributeUtil.getReferenceElement((AttributeType)attribute)) != null && (modelElement3 = this.getTargetModelElement((EObject)this.targetModel, (IIdentifiableModelElement)attributeModel)) != null && (targetAttribute = (AttributeType)targetAttributes.get(i3)) != null) {
                    AttributeUtil.setReference((AttributeType)targetAttribute, (EObject)modelElement3);
                }
                ++i3;
            }
            if (copy instanceof ProcessDefinitionType) {
                MergeUtils.mergeFormalParameter((ProcessDefinitionType)((ProcessDefinitionType)raw), (ProcessDefinitionType)((ProcessDefinitionType)copy));
            }
        }
        if (copy instanceof BindActionType && (rawActionType = ((BindActionType)raw).getType()) != null && (modelElement2 = this.getTargetModelElement(parent, (IIdentifiableModelElement)rawActionType)) != null) {
            ((BindActionType)copy).setType((EventActionTypeType)modelElement2);
        }
        if (copy instanceof UnbindActionType && (rawActionType = ((UnbindActionType)raw).getType()) != null && (modelElement2 = this.getTargetModelElement(parent, (IIdentifiableModelElement)rawActionType)) != null) {
            ((UnbindActionType)copy).setType((EventActionTypeType)modelElement2);
        }
        if (copy instanceof EventActionType) {
            EventActionTypeType rawActionType2;
            ProcessDefinitionType rawProcess;
            ProcessDefinitionType targetProcess = null;
            AttributeType attribute2 = AttributeUtil.getAttribute((IExtensibleElement)((IExtensibleElement)raw), (String)"carnot:engine:processDefinition");
            if (attribute2 != null && attribute2.getReference() != null && (rawProcess = (ProcessDefinitionType)attribute2.getReference().getIdentifiable()) != null) {
                targetProcess = (ProcessDefinitionType)this.getTargetModelElement((EObject)this.targetModel, (IIdentifiableModelElement)rawProcess);
            }
            if (targetProcess != null && (attribute2 = AttributeUtil.getAttribute((IExtensibleElement)((IExtensibleElement)copy), (String)"carnot:engine:processDefinition")) != null && attribute2.getReference() != null) {
                AttributeUtil.setReference((AttributeType)attribute2, targetProcess);
            }
            if ((rawActionType2 = ((EventActionType)raw).getType()) != null && (modelElement = this.getTargetModelElement(parent, (IIdentifiableModelElement)rawActionType2)) != null) {
                ((EventActionType)copy).setType((EventActionTypeType)modelElement);
            }
        }
        if (copy instanceof EventHandlerType && (rawConditionType = ((EventHandlerType)raw).getType()) != null && (modelElement2 = this.getTargetModelElement(parent, (IIdentifiableModelElement)rawConditionType)) != null) {
            ((EventHandlerType)copy).setType((EventConditionTypeType)modelElement2);
        }
        if (copy instanceof ActivityType) {
            EList rawValidQualityCodes;
            IIdentifiableModelElement modelElement4;
            ProcessDefinitionType rawProcess;
            ApplicationType rawApplication;
            IIdentifiableModelElement modelElement5;
            IModelParticipant rawQualityControlParticipant;
            IModelParticipant rawParticipant = ((ActivityType)raw).getPerformer();
            if (rawParticipant != null && (modelElement2 = this.getTargetModelElement(parent, (IIdentifiableModelElement)rawParticipant)) != null) {
                ((ActivityType)copy).setPerformer((IModelParticipant)modelElement2);
            }
            if ((rawQualityControlParticipant = ((ActivityType)raw).getQualityControlPerformer()) != null && (modelElement5 = this.getTargetModelElement(parent, (IIdentifiableModelElement)rawQualityControlParticipant)) != null) {
                ((ActivityType)copy).setQualityControlPerformer((IModelParticipant)modelElement5);
            }
            if ((rawApplication = ((ActivityType)raw).getApplication()) != null && (modelElement = this.getTargetModelElement(parent, (IIdentifiableModelElement)rawApplication)) != null) {
                ((ActivityType)copy).setApplication((ApplicationType)modelElement);
            }
            if ((rawProcess = ((ActivityType)raw).getImplementationProcess()) != null && (modelElement4 = this.getTargetModelElement(parent, (IIdentifiableModelElement)rawProcess)) != null) {
                ((ActivityType)copy).setImplementationProcess((ProcessDefinitionType)modelElement4);
            }
            if ((rawValidQualityCodes = ((ActivityType)raw).getValidQualityCodes()) != null && !rawValidQualityCodes.isEmpty()) {
                EList targetValidQualityCodes = ((ActivityType)copy).getValidQualityCodes();
                targetValidQualityCodes.clear();
                for (Code code : rawValidQualityCodes) {
                    Code targetCode = MergerUtil.containsQC(this.targetModel, code);
                    if (targetCode == null) continue;
                    targetValidQualityCodes.add((Object)targetCode);
                }
            }
        }
        if (copy instanceof LaneSymbol && (rawLaneParticipant = ((LaneSymbol)raw).getParticipantReference()) != null && (modelElement2 = this.getTargetModelElement(parent, (IIdentifiableModelElement)rawLaneParticipant)) != null) {
            ((LaneSymbol)copy).setParticipantReference((IModelParticipant)modelElement2);
        }
        if (copy instanceof IModelElementNodeSymbol && (rawModelElement = ((IModelElementNodeSymbol)raw).getModelElement()) != null && (modelElement2 = this.getTargetModelElement(parent, rawModelElement)) != null) {
            ((IModelElementNodeSymbol)copy).setModelElement(modelElement2);
        }
        if (copy instanceof IConnectionSymbol && raw instanceof TransitionConnectionType && (rawTransition = ((TransitionConnectionType)raw).getTransition()) != null && (modelElement2 = this.getTargetModelElement(parent, (IIdentifiableModelElement)rawTransition)) != null) {
            ((TransitionConnectionType)copy).setTransition((TransitionType)modelElement2);
        }
        if (copy instanceof DataPathType && (rawDataType = ((DataPathType)raw).getData()) != null && (modelElement2 = this.getTargetModelElement(parent, (IIdentifiableModelElement)rawDataType)) != null) {
            ((DataPathType)copy).setData((DataType)modelElement2);
        }
        if (copy instanceof TriggerType) {
            TriggerTypeType rawTriggerType = ((TriggerType)raw).getType();
            if (rawTriggerType != null && (modelElement2 = this.getTargetModelElement(parent, (IIdentifiableModelElement)rawTriggerType)) != null) {
                ((TriggerType)copy).setType((TriggerTypeType)modelElement2);
            }
            EList attributes = ((TriggerType)raw).getAttribute();
            int a = 0;
            while (a < attributes.size()) {
                attribute = (AttributeType)attributes.get(a);
                IdentifiableReference reference = attribute.getReference();
                if (reference != null && (modelElement3 = this.getTargetModelElement(parent, (IIdentifiableModelElement)reference.getIdentifiable())) != null) {
                    AttributeUtil.setReference((IExtensibleElement)((TriggerType)copy), (String)attribute.getName(), (EObject)modelElement3);
                }
                ++a;
            }
        }
        if (copy instanceof ParameterMappingType && (rawDataType = ((ParameterMappingType)raw).getData()) != null && (modelElement2 = this.getTargetModelElement(parent, (IIdentifiableModelElement)rawDataType)) != null) {
            ((ParameterMappingType)copy).setData((DataType)modelElement2);
        }
        if (copy instanceof DataType) {
            DataTypeType rawDataTypeType = ((DataType)raw).getType();
            if (rawDataTypeType != null) {
                String rawStructuredDataId;
                modelElement2 = this.getTargetModelElement(parent, (IIdentifiableModelElement)rawDataTypeType);
                if (modelElement2 != null) {
                    ((DataType)copy).setType((DataTypeType)modelElement2);
                }
                if (rawDataTypeType.getId().equals("struct") && !StringUtils.isEmpty((String)(rawStructuredDataId = AttributeUtil.getAttributeValue((IExtensibleElement)((IExtensibleElement)raw), (String)"carnot:engine:dataType")))) {
                    TypeDeclarationType typeDeclaration;
                    String newId = (String)this.structuredDataChangedCache.get(rawStructuredDataId);
                    if (newId == null) {
                        newId = rawStructuredDataId;
                    }
                    if ((typeDeclaration = this.targetDeclarations.getTypeDeclaration(newId)) != null) {
                        AttributeUtil.setReference((IExtensibleElement)((IExtensibleElement)copy), (String)"carnot:engine:dataType", (EObject)typeDeclaration);
                    }
                }
            }
            if (((DataType)raw).isPredefined()) {
                ((DataType)copy).setPredefined(false);
            }
        }
        if (copy instanceof ConditionalPerformerType) {
            String dataId;
            DataType dataType = ((ConditionalPerformerType)raw).getData();
            if (dataType != null && (modelElement2 = this.getTargetModelElement(parent, (IIdentifiableModelElement)dataType)) != null) {
                ((ConditionalPerformerType)copy).setData((DataType)modelElement2);
            }
            if (!StringUtils.isEmpty((String)(dataId = AttributeUtil.getAttributeValue((IExtensibleElement)((IExtensibleElement)raw), (String)"carnot:engine:conditionalPerformer:realmData")))) {
                AttributeUtil.setAttribute((IExtensibleElement)((IExtensibleElement)copy), (String)"carnot:engine:conditionalPerformer:realmData", (String)dataId);
            }
        }
        if (copy instanceof OrganizationType) {
            IIdentifiableModelElement modelElement6;
            EList participants = ((OrganizationType)raw).getParticipant();
            RoleType teamLead = ((OrganizationType)raw).getTeamLead();
            if (teamLead != null && (modelElement6 = this.getTargetModelElement(parent, (IIdentifiableModelElement)teamLead)) != null) {
                ((OrganizationType)copy).setTeamLead((RoleType)modelElement6);
            }
            ((OrganizationType)copy).getParticipant().clear();
            int i4 = 0;
            while (i4 < participants.size()) {
                IIdentifiableModelElement modelElement7;
                IModelParticipant rawParticipant = ((ParticipantType)participants.get(i4)).getParticipant();
                if (rawParticipant != null && (modelElement7 = this.getTargetModelElement(parent, (IIdentifiableModelElement)rawParticipant)) != null) {
                    ParticipantType participantType = CarnotWorkflowModelFactory.eINSTANCE.createParticipantType();
                    participantType.setParticipant((IModelParticipant)modelElement7);
                    ((OrganizationType)copy).getParticipant().add((Object)participantType);
                }
                ++i4;
            }
            ((OrganizationType)copy).getOrganizationSymbols().clear();
        }
        if (copy instanceof ContextType && (rawApplicationContextType = ((ContextType)raw).getType()) != null && (modelElement2 = this.getTargetModelElement(parent, (IIdentifiableModelElement)rawApplicationContextType)) != null) {
            ((ContextType)copy).setType((ApplicationContextTypeType)modelElement2);
        }
        if (copy instanceof ApplicationType) {
            ApplicationTypeType rawApplicationType = ((ApplicationType)raw).getType();
            if (rawApplicationType != null && (modelElement2 = this.getTargetModelElement(parent, (IIdentifiableModelElement)rawApplicationType)) != null) {
                ((ApplicationType)copy).setType((ApplicationTypeType)modelElement2);
            }
            DataTypeType structuredDataType = ModelUtils.getDataType((IModelElement)((IModelElement)copy), (String)"struct");
            EList accessPoints = ((ApplicationType)copy).getAccessPoint();
            int i5 = 0;
            while (i5 < accessPoints.size()) {
                DataTypeType type;
                IIdentifiableModelElement modelElement8;
                AccessPointType accessPoint = (AccessPointType)accessPoints.get(i5);
                if (accessPoint.getType().getId().equals("struct")) {
                    accessPoint.setType(structuredDataType);
                }
                if ((modelElement8 = this.getTargetModelElement(parent, (IIdentifiableModelElement)(type = accessPoint.getType()))) != null) {
                    accessPoint.setType((DataTypeType)modelElement8);
                }
                ++i5;
            }
        }
        if (copy instanceof DataMappingType) {
            DataType targetDataType = ((DataMappingType)raw).getData();
            modelElement2 = null;
            if (targetDataType != null) {
                modelElement2 = this.getTargetModelElement(parent, (IIdentifiableModelElement)targetDataType);
                if (modelElement2 != null) {
                    ((DataMappingType)copy).setData((DataType)modelElement2);
                } else {
                    return false;
                }
            }
        }
        return true;
    }

    protected IIdentifiableModelElement getTargetModelElement(EObject parent, IIdentifiableModelElement rawModelElement) {
        IIdentifiableModelElement modelElement = null;
        Map.Entry entry = MergerUtil.getEntryFromMap(this.changedCache, (EObject)rawModelElement);
        if (entry != null) {
            modelElement = (IIdentifiableModelElement)((EObject)entry.getValue());
        } else if (rawModelElement instanceof ActivityType || rawModelElement instanceof TransitionType || rawModelElement instanceof TriggerType) {
            EObject parentModel = parent;
            while (parentModel != null && !(parentModel instanceof ProcessDefinitionType)) {
                parentModel = parentModel.eContainer();
            }
            if (parentModel == null) {
                return null;
            }
            modelElement = (IIdentifiableModelElement)CopyPasteUtil.getSameElement((EObject)rawModelElement, parentModel);
        } else {
            modelElement = (IIdentifiableModelElement)CopyPasteUtil.getSameModelElement((EObject)rawModelElement, this.targetModel, this.changedCache);
        }
        return modelElement;
    }

    protected boolean openDialog(Map.Entry entry) {
        EObject raw = (EObject)entry.getKey();
        EObject copy = (EObject)entry.getValue();
        EClass eClass = copy.eClass();
        Object parent = raw.eContainer();
        parent = copy instanceof LaneSymbol && !this.isSameModel ? DiagramUtil.getDefaultPool((DiagramType)this.targetDiagram) : CopyPasteUtil.getSameModelElement(parent, this.targetModel, null);
        if (this.isDiagram && (parent instanceof ProcessDefinitionType || raw instanceof ActivityType && parent == null || raw instanceof TransitionType && parent == null || raw instanceof TriggerType && parent == null)) {
            parent = this.storage.getTargetProcess();
        }
        HashMap eClassNameIdCache = new HashMap();
        Cloneable localNameIdCache = null;
        eClassNameIdCache = (HashMap)this.nameIdCache.get(parent);
        if (copy instanceof DiagramType) {
            String name = ((DiagramType)copy).getName();
            NameIdDialog nameIdDialog = new NameIdDialog(null, name, (List)((Object)(localNameIdCache = (ArrayList)eClassNameIdCache.get(eClass))));
            if (nameIdDialog.open() == 0) {
                ((DiagramType)copy).setName(nameIdDialog.getName());
                ((ArrayList)localNameIdCache).add(nameIdDialog.getNameCache());
                eClassNameIdCache.put(eClass, localNameIdCache);
                this.nameIdCache.put(parent, eClassNameIdCache);
                return true;
            }
            return false;
        }
        if (copy instanceof IIdentifiableElement) {
            String name;
            String id = ((IIdentifiableElement)copy).getId();
            NameIdDialog nameIdDialog = new NameIdDialog(null, id, name = ((IIdentifiableElement)copy).getName(), (HashMap)(localNameIdCache = (HashMap)eClassNameIdCache.get(eClass)));
            if (nameIdDialog.open() == 0) {
                ((IIdentifiableElement)copy).setId(nameIdDialog.getId());
                ((IIdentifiableElement)copy).setName(nameIdDialog.getName());
                ((HashMap)localNameIdCache).put(nameIdDialog.getId(), nameIdDialog.getName());
                eClassNameIdCache.put(eClass, localNameIdCache);
                this.nameIdCache.put(parent, eClassNameIdCache);
                return true;
            }
            return false;
        }
        if (copy instanceof TypeDeclarationType) {
            String name;
            String id = ((TypeDeclarationType)copy).getId();
            NameIdDialog nameIdDialog = new NameIdDialog(null, id, name = ((TypeDeclarationType)copy).getName(), (HashMap)(localNameIdCache = (HashMap)eClassNameIdCache.get(eClass)));
            if (nameIdDialog.open() == 0) {
                ((TypeDeclarationType)copy).setId(nameIdDialog.getId());
                ((TypeDeclarationType)copy).setName(nameIdDialog.getName());
                ((HashMap)localNameIdCache).put(nameIdDialog.getId(), nameIdDialog.getName());
                eClassNameIdCache.put(eClass, localNameIdCache);
                this.nameIdCache.put(parent, eClassNameIdCache);
                return true;
            }
            return false;
        }
        return false;
    }

    protected boolean referenceOrValue() {
        NameIDCache nameIdCacheObject = new NameIDCache(this.storage, this.changedCache, this.nameIdCache, this.referenceValueInput);
        ReferenceValueDialog copyKindDialog = new ReferenceValueDialog(null, this.referenceValueInput, nameIdCacheObject);
        if (1 == copyKindDialog.open()) {
            return false;
        }
        List contentList = this.referenceValueInput.getContainer().getAllContent();
        int i = 0;
        while (i < contentList.size()) {
            ContentDecorator entry = (ContentDecorator)contentList.get(i);
            if (!entry.isChecked()) {
                String name;
                MergerUtil.MergerEntry dialogEntry = (MergerUtil.MergerEntry)entry.getContent();
                EObject raw = dialogEntry.getKey();
                EObject copy = dialogEntry.getValue();
                EClass eClass = copy.eClass();
                EObject parent = raw.eContainer();
                parent = CopyPasteUtil.getSameModelElement(parent, this.targetModel, null);
                if (this.isDiagram && parent instanceof ProcessDefinitionType) {
                    parent = this.storage.getTargetProcess();
                }
                HashMap eClassNameIdCache = new HashMap();
                Cloneable localNameIdCache = null;
                eClassNameIdCache = (HashMap)this.nameIdCache.get(parent);
                if (copy instanceof DiagramType) {
                    name = ((DiagramType)copy).getName();
                    localNameIdCache = (ArrayList)eClassNameIdCache.get(eClass);
                    localNameIdCache.add(name);
                    eClassNameIdCache.put(eClass, localNameIdCache);
                    this.nameIdCache.put(parent, eClassNameIdCache);
                } else if (copy instanceof IIdentifiableElement) {
                    String id = ((IIdentifiableElement)copy).getId();
                    name = ((IIdentifiableElement)copy).getName();
                    localNameIdCache = (HashMap)eClassNameIdCache.get(eClass);
                    ((HashMap)localNameIdCache).put(id, name);
                    eClassNameIdCache.put(eClass, localNameIdCache);
                    this.nameIdCache.put(parent, eClassNameIdCache);
                }
                this.changedCache.put(dialogEntry.getKey(), dialogEntry.getValue());
            }
            ++i;
        }
        return true;
    }

    public boolean modelChanged() {
        return this.modelChanged;
    }

    protected void checkForDialog(ModelType targetModel) {
        HashMap<EObject, EObject> tmpGlobalElements = new HashMap<EObject, EObject>();
        Iterator it = this.globalElements.entrySet().iterator();
        while (it.hasNext()) {
            MergerUtil.MergerEntry dialogEntry;
            IIdentifiableModelElement modelElement = null;
            Map.Entry entry = it.next();
            EObject raw = (EObject)entry.getKey();
            EObject copy = (EObject)entry.getValue();
            if (raw instanceof IModelParticipant) {
                modelElement = (IIdentifiableModelElement)CopyPasteUtil.getSameModelElement(raw, targetModel, null);
                if (modelElement == null) continue;
                tmpGlobalElements.put(raw, copy);
                dialogEntry = new MergerUtil.MergerEntry(raw, copy);
                this.container.getParticipants().getContent().add(new ContentDecorator(dialogEntry));
                this.showDialog = true;
                continue;
            }
            if (raw instanceof ApplicationType) {
                modelElement = (IIdentifiableModelElement)CopyPasteUtil.getSameModelElement(raw, targetModel, null);
                if (modelElement == null) continue;
                tmpGlobalElements.put(raw, copy);
                dialogEntry = new MergerUtil.MergerEntry(raw, copy);
                this.container.getApplications().getContent().add(new ContentDecorator(dialogEntry));
                this.showDialog = true;
                continue;
            }
            if (!(raw instanceof DataType) || (modelElement = (IIdentifiableModelElement)CopyPasteUtil.getSameModelElement(raw, targetModel, null)) == null) continue;
            tmpGlobalElements.put(raw, copy);
            dialogEntry = new MergerUtil.MergerEntry(raw, copy);
            this.container.getDataTypes().getContent().add(new ContentDecorator(dialogEntry));
            this.showDialog = true;
        }
        if (!tmpGlobalElements.isEmpty()) {
            for (Map.Entry entry : tmpGlobalElements.entrySet()) {
                EObject raw = (EObject)entry.getKey();
                this.globalElements.remove(raw);
            }
        }
    }

    protected void collectElements() {
        EObject raw;
        HashMap<Object, EObject> typeTypes = new HashMap<Object, EObject>();
        HashSet<String> tempStructuredData = new HashSet<String>();
        HashMap tempStructuredDatas = new HashMap();
        HashMap tempEventActionTypeTypes = new HashMap();
        HashMap tempQualityControlCodes = new HashMap();
        this.externalReferences = false;
        this.mergeElements.putAll(this.globalElements);
        this.mergeElements.putAll(this.processes);
        this.mergeElements.putAll(this.diagrams);
        for (Map.Entry entry : this.elements.entrySet()) {
            raw = (EObject)entry.getKey();
            if (raw instanceof TypeDeclarationType) {
                this.structuredData.add(((TypeDeclarationType)raw).getId());
                tempStructuredData.add(((TypeDeclarationType)raw).getId());
                tempStructuredDatas.put(entry.getKey(), entry.getValue());
            }
            if (raw instanceof EventActionTypeType) {
                tempEventActionTypeTypes.put(entry.getKey(), entry.getValue());
            }
            if (this.isSameModel || !(raw instanceof Code) || MergerUtil.containsQC(this.targetModel, (Code)raw) != null) continue;
            if (this.targetModel.getQualityControl() == null) {
                this.targetModel.setQualityControl(CarnotWorkflowModelFactory.eINSTANCE.createQualityControlType());
            }
            this.targetModel.getQualityControl().getCode().add((Object)((Code)entry.getValue()));
            tempQualityControlCodes.put(entry.getKey(), entry.getValue());
        }
        if (!tempQualityControlCodes.isEmpty()) {
            for (Map.Entry entry : tempQualityControlCodes.entrySet()) {
                raw = (EObject)entry.getKey();
                this.elements.remove(raw);
            }
        }
        if (!tempEventActionTypeTypes.isEmpty()) {
            for (Map.Entry entry : tempEventActionTypeTypes.entrySet()) {
                raw = (EObject)entry.getKey();
                IIdentifiableModelElement modelElement = (IIdentifiableModelElement)CopyPasteUtil.getSameModelElement(raw, this.targetModel, this.changedCache);
                if (modelElement == null) continue;
                this.elements.remove(raw);
            }
        }
        if (!tempStructuredDatas.isEmpty()) {
            for (Map.Entry entry : tempStructuredDatas.entrySet()) {
                raw = (EObject)entry.getKey();
                this.elements.remove(raw);
            }
        }
        this.mergeElements.putAll(this.elements);
        for (Map.Entry entry : this.mergeElements.entrySet()) {
            String structuredDataId;
            DataTypeType targetType;
            raw = (EObject)entry.getKey();
            if (raw instanceof DataType && ((DataType)raw).getExternalReference() != null) {
                this.externalReferences = true;
            }
            if (raw instanceof ActivityType && ((ActivityType)raw).getExternalRef() != null) {
                this.externalReferences = true;
            }
            if (raw instanceof ProcessDefinitionType) {
                if (((ProcessDefinitionType)raw).getExternalRef() != null) {
                    this.externalReferences = true;
                }
                for (ActivityType checkActivity : ((ProcessDefinitionType)raw).getActivity()) {
                    if (checkActivity.getExternalRef() == null) continue;
                    this.externalReferences = true;
                }
            }
            if (raw instanceof ApplicationType) {
                ApplicationTypeType targetType2;
                EList contextList = ((ApplicationType)raw).getContext();
                int i = 0;
                while (i < contextList.size()) {
                    ApplicationContextTypeType targetType3;
                    ContextType context = (ContextType)contextList.get(i);
                    ApplicationContextTypeType contextType = context.getType();
                    if (contextType != null && (targetType3 = (ApplicationContextTypeType)CopyPasteUtil.getSameModelElement((EObject)contextType, this.targetModel, null)) == null && !typeTypes.containsKey(contextType)) {
                        typeTypes.put(contextType, this.copier.copy((EObject)contextType));
                    }
                    ++i;
                }
                EList accessPoints = ((ApplicationType)raw).getAccessPoint();
                int i2 = 0;
                while (i2 < accessPoints.size()) {
                    AccessPointType accessPoint = (AccessPointType)accessPoints.get(i2);
                    DataTypeType accessPointType = accessPoint.getType();
                    DataTypeType accessPointTargetType = (DataTypeType)CopyPasteUtil.getSameModelElement((EObject)accessPointType, this.targetModel, null);
                    if (accessPointTargetType == null && !typeTypes.containsKey(accessPointType)) {
                        typeTypes.put(accessPointType, this.copier.copy((EObject)accessPointType));
                    }
                    ++i2;
                }
                ApplicationTypeType type = ((ApplicationType)raw).getType();
                if (type == null || (targetType2 = (ApplicationTypeType)CopyPasteUtil.getSameModelElement((EObject)type, this.targetModel, null)) != null || typeTypes.containsKey(type)) continue;
                typeTypes.put(type, this.copier.copy((EObject)type));
                continue;
            }
            if (!(raw instanceof DataType)) continue;
            DataTypeType type = ((DataType)raw).getType();
            if (type != null && (targetType = (DataTypeType)CopyPasteUtil.getSameModelElement((EObject)type, this.targetModel, null)) == null && !typeTypes.containsKey(type)) {
                typeTypes.put(type, this.copier.copy((EObject)type));
            }
            if (type.getId().equals("struct")) {
                structuredDataId = AttributeUtil.getAttributeValue((IExtensibleElement)((IExtensibleElement)raw), (String)"carnot:engine:dataType");
                if (StringUtils.isEmpty((String)structuredDataId)) continue;
                tempStructuredData.add(structuredDataId);
                continue;
            }
            if (!GenericUtils.isDMSDataType((DataType)raw) || StringUtils.isEmpty((String)(structuredDataId = AttributeUtil.getAttributeValue((IExtensibleElement)((IExtensibleElement)raw), (String)DmsConstants.RESOURCE_METADATA_SCHEMA_ATT)))) continue;
            tempStructuredData.add(structuredDataId);
        }
        if (!tempStructuredData.isEmpty()) {
            HashSet internalStructuredData = new HashSet();
            ModelType sourceModel = this.storage.getOriginalModelCopy();
            for (String id : tempStructuredData) {
                MergerUtil.checkAllXSDImportReferences(sourceModel, id, this.xsdFiles, internalStructuredData);
            }
            tempStructuredData.addAll(internalStructuredData);
            internalStructuredData = new HashSet();
            for (String id : tempStructuredData) {
                MergerUtil.checkAllTypeDeclarationReferences(sourceModel, id, this.xsdFiles, internalStructuredData);
            }
        }
        if (!this.isSameModel) {
            this.mergeElements.putAll(typeTypes);
            this.structuredData = tempStructuredData;
        } else {
            typeTypes.clear();
        }
    }

    public void mergeConfigurationVariables() {
        if (!this.isSameModel) {
            List<ModelVariable> findMergedVariables;
            VariableContext targetContext = VariableContextHelper.getInstance().getContext(this.targetModel);
            List changedtargetVariables = null;
            if (targetContext != null) {
                targetContext.refreshVariables((EObject)this.targetModel);
                changedtargetVariables = targetContext.getVariables();
            }
            if (this.targetVariables != null && changedtargetVariables != null && (findMergedVariables = MergerUtil.findMergedVariables(this.targetVariables, changedtargetVariables)).size() > 0) {
                ModelType sourceModel = this.storage.getOriginalModelCopy();
                VariableContext sourceContext = VariableContextHelper.getInstance().getContext(sourceModel);
                List sourceVariables = null;
                if (sourceContext != null) {
                    sourceContext.refreshVariables((EObject)sourceModel);
                    sourceVariables = sourceContext.getVariables();
                }
                if (sourceVariables != null) {
                    for (ModelVariable findMergedVariable : findMergedVariables) {
                        ModelVariable findModelVariable = MergerUtil.findModelVariable(sourceVariables, findMergedVariable);
                        if (findModelVariable == null) continue;
                        findMergedVariable.setDescription(findModelVariable.getDescription());
                        findMergedVariable.setDefaultValue(findModelVariable.getDefaultValue());
                    }
                    targetContext.saveVariables();
                }
            }
        }
    }

    public boolean mergeGlobal() {
        if (!this.xsdFiles.isEmpty() && this.targetProject != null) {
            boolean notFound = false;
            for (String filename : this.xsdFiles) {
                if (GenericUtils.getFile(this.targetProject, filename) != null) continue;
                notFound = true;
                break;
            }
            if (!notFound) {
                this.xsdFiles.clear();
            }
        }
        if (!this.isSameModel && this.externalReferences) {
            MessageBox messageBox = new MessageBox(Display.getDefault().getActiveShell(), 40);
            messageBox.setText(Diagram_Messages.TXT_CONTAINS_EXTERNAL_REF);
            messageBox.setMessage(Diagram_Messages.MSG_PASTE_NOT_POSSIBLE);
            messageBox.open();
            return false;
        }
        if (!this.xsdFiles.isEmpty()) {
            String message = Diagram_Messages.FileCopyMessage_Text;
            Iterator iterator = this.xsdFiles.iterator();
            while (iterator.hasNext()) {
                message = String.valueOf(message) + iterator.next();
                message = String.valueOf(message) + "\n";
            }
            MessageBox messageBox = new MessageBox(Display.getDefault().getActiveShell(), 40);
            messageBox.setText(Diagram_Messages.FileCopyMessage_Title);
            messageBox.setMessage(message);
            messageBox.open();
            return false;
        }
        this.targetDeclarations = this.targetModel.getTypeDeclarations();
        if (!this.structuredData.isEmpty()) {
            TypeDeclarationType raw;
            TypeDeclarationType newDeclaration;
            ModelType sourceModel = this.storage.getOriginalModelCopy();
            TypeDeclarationsType typeDeclarationsType = sourceModel.getTypeDeclarations();
            for (String id : this.structuredData) {
                TypeDeclarationType td = typeDeclarationsType.getTypeDeclaration(id);
                if (td == null) continue;
                newDeclaration = XpdlFactory.eINSTANCE.createTypeDeclarationType();
                newDeclaration.setId(td.getId());
                newDeclaration.setName(td.getName());
                this.typeDeclarationElements.put(td, newDeclaration);
            }
            for (Map.Entry<TypeDeclarationType, TypeDeclarationType> entry : this.typeDeclarationElements.entrySet()) {
                raw = entry.getKey();
                TypeDeclarationType copy = entry.getValue();
                if (MergerUtil.getEntryFromMap(this.changedCache, (EObject)raw) != null || !this.checkElementInModel(entry)) continue;
                if (!this.openDialog(entry)) {
                    this.modelChanged = false;
                    return false;
                }
                this.structuredDataChangedCache.put(raw.getId(), copy.getId());
                this.changedCache.put((EObject)entry.getKey(), (EObject)entry.getValue());
            }
            for (Map.Entry<TypeDeclarationType, TypeDeclarationType> entry : this.typeDeclarationElements.entrySet()) {
                ExternalReferenceType copy;
                raw = entry.getKey();
                newDeclaration = entry.getValue();
                XpdlTypeType type = raw.getDataType();
                if (type instanceof SchemaTypeType) {
                    XSDTypeDefinition typeDefinition;
                    XSDElementDeclaration element;
                    List xsdImports;
                    XSDSchema schema = ((SchemaTypeType)type).getSchema();
                    XSDSchema clone = (XSDSchema)schema.cloneConcreteComponent(true, false);
                    Document doc = clone.updateDocument();
                    if (schema.getElement() != null) {
                        Element clonedElement = (Element)doc.importNode(schema.getElement(), true);
                        doc.appendChild(clonedElement);
                        clone.setElement(clonedElement);
                    }
                    if ((xsdImports = TypeDeclarationUtils.getImports((XSDSchema)clone)) != null) {
                        for (XSDImport xsdImport : xsdImports) {
                            int idx;
                            String xsdNameSpace = xsdImport.getNamespace();
                            String elementName = xsdNameSpace.substring(idx = xsdNameSpace.lastIndexOf("/") + 1, xsdNameSpace.length());
                            String newElementName = (String)this.structuredDataChangedCache.get(elementName);
                            if (newElementName == null) {
                                newElementName = elementName;
                            } else {
                                xsdImport.setSchemaLocation("urn:internal:" + newElementName);
                            }
                            String newValue = TypeDeclarationUtils.computeTargetNamespace((String)this.targetModel.getId(), (String)newElementName);
                            xsdImport.setNamespace(newValue);
                        }
                    }
                    SchemaTypeType schemaTypeType = XpdlFactory.eINSTANCE.createSchemaTypeType();
                    schemaTypeType.setSchema(clone);
                    newDeclaration.setSchemaType(schemaTypeType);
                    XSDNamedComponent component = TypeDeclarationUtils.findElementOrTypeDeclaration((TypeDeclarationType)newDeclaration, (String)raw.getId());
                    if (component != null) {
                        component.setName(newDeclaration.getId());
                    }
                    if (component instanceof XSDElementDeclaration && !(element = (XSDElementDeclaration)component).isElementDeclarationReference() && element.getAnonymousTypeDefinition() == null && (typeDefinition = element.getTypeDefinition()) != null && typeDefinition.getSchema() == clone) {
                        typeDefinition.setName(newDeclaration.getId());
                    }
                    clone.getTargetNamespace();
                    clone.setTargetNamespace(TypeDeclarationUtils.computeTargetNamespace((String)this.targetModel.getId(), (String)newDeclaration.getId()));
                    String prefix = TypeDeclarationUtils.computePrefix((String)newDeclaration.getId(), clone.getQNamePrefixToNamespaceMap().keySet());
                    clone.getQNamePrefixToNamespaceMap().put(prefix, clone.getTargetNamespace());
                    clone.setSchemaLocation("urn:internal:" + newDeclaration.getId());
                } else if (type instanceof ExternalReferenceType) {
                    copy = (ExternalReferenceType)this.copier.copy((EObject)type);
                    newDeclaration.setExternalReference(copy);
                }
                if (raw.getExtendedAttributes() != null) {
                    copy = (ExtendedAttributesType)this.copier.copy((EObject)raw.getExtendedAttributes());
                    newDeclaration.setExtendedAttributes((ExtendedAttributesType)copy);
                    ExtendedAttributeUtil.setAttribute((Extensible)newDeclaration, (String)"infinity:vcs:uuid", null);
                }
                this.targetDeclarations.getTypeDeclaration().add((Object)newDeclaration);
                this.modelChanged = true;
            }
            for (TypeDeclarationType td : this.typeDeclarationElements.values()) {
                XpdlTypeType type = td.getDataType();
                if (!(type instanceof SchemaTypeType)) continue;
                MergerUtil.updateTypeDefinition(td, this.targetModel, this.structuredDataChangedCache);
            }
        }
        if (this.showDialog) {
            if (!this.referenceOrValue()) {
                this.modelChanged = false;
                return false;
            }
            this.mergeElements.putAll(this.changedCache);
        }
        for (Map.Entry<EObject, EObject> entry : this.mergeElements.entrySet()) {
            if (this.mergeElement(entry)) continue;
            this.modelChanged = false;
            return false;
        }
        for (Map.Entry entry : this.mergeElements.entrySet()) {
            this.addModelElement(entry, false);
        }
        return true;
    }

    protected void collectProcessContent() {
        List tmpTransitions;
        ArrayList<ActivityType> tmpActivities = new ArrayList<ActivityType>();
        for (Map.Entry entry : this.processChildren.entrySet()) {
            ActivityType activity;
            EObject eObject = (EObject)entry.getKey();
            EObject value = (EObject)entry.getValue();
            if (!this.elements.containsKey(eObject)) {
                this.elements.put(eObject, value);
            }
            if (eObject instanceof ActivityType) {
                activity = (ActivityType)eObject;
                tmpActivities.add(activity);
            }
            if (this.isSameModel) continue;
            if (eObject instanceof ActivityType) {
                activity = (ActivityType)eObject;
                MergerUtil.getObjectsFromActivity(activity, this.globalElements, this.processes, this.elements, this.copier);
                continue;
            }
            if (!(eObject instanceof TriggerType)) continue;
            TriggerType trigger = (TriggerType)eObject;
            MergerUtil.getObjectsFromTrigger(trigger, this.globalElements, this.copier);
        }
        if (tmpActivities.isEmpty() && !(tmpTransitions = ConnectionUtils.getTransitions(tmpActivities)).isEmpty()) {
            Iterator iterator = tmpTransitions.iterator();
            while (iterator.hasNext()) {
                TransitionType transition;
                TransitionType raw = transition = (TransitionType)iterator.next();
                EObject value = this.copier.copy((EObject)transition);
                this.processChildren.put(raw, value);
                if (this.elements.containsKey(raw)) continue;
                this.elements.put(raw, value);
            }
        }
        if (!this.isSameModel) {
            EObject raw;
            HashMap allSubProcesses = new HashMap();
            for (Map.Entry<Object, Object> entry : this.processes.entrySet()) {
                raw = (EObject)entry.getKey();
                Map subProcesses = MergerUtil.collectSubProcesses((ProcessDefinitionType)raw, this.copier, this.processes);
                if (subProcesses == null) continue;
                MergerUtil.mergeProcesses(allSubProcesses, subProcesses);
            }
            MergerUtil.mergeProcesses(this.processes, allSubProcesses);
            for (Map.Entry<Object, Object> entry : this.processes.entrySet()) {
                raw = (EObject)entry.getKey();
                MergerUtil.checkAuthorizations(raw, this.globalElements, this.copier);
                MergerUtil.getObjectsFromProcess(raw, this.processElements, this.globalElements, this.copier);
                EList rawActivities = ((ProcessDefinitionType)raw).getActivity();
                if (rawActivities.isEmpty()) continue;
                for (ActivityType activity : rawActivities) {
                    if (this.activities == null || this.activities.containsKey(activity)) continue;
                    this.activities.put(activity, (ActivityType)this.copier.copy((EObject)activity));
                }
            }
            for (Map.Entry<Object, Object> entry : this.processElements.entrySet()) {
                raw = (EObject)entry.getKey();
                if (!(raw instanceof EventActionTypeType) || this.elements.containsKey(raw)) continue;
                this.elements.put(entry.getKey(), entry.getValue());
            }
            this.processElements = new HashMap();
        }
    }
}

