/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.core.editors.cap;

import java.util.Map;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.stardust.model.xpdl.carnot.IIdentifiableElement;
import org.eclipse.stardust.modeling.core.editors.cap.ICheck;
import org.eclipse.stardust.modeling.core.editors.cap.NameIDCache;

public class ContentDecorator
implements ICheck {
    private final String namePrefix = "Copy Of ";
    private final String idPrefix = "CopyOf";
    private String nameCopy;
    private String idCopy;
    private Integer duplicate = null;
    private Object content;
    private boolean checked = false;

    public ContentDecorator(Object content) {
        this.content = content;
        if (this.content instanceof Map.Entry) {
            content = ((Map.Entry)this.content).getValue();
        }
        if (content instanceof IIdentifiableElement) {
            this.nameCopy = ((IIdentifiableElement)content).getName();
            this.idCopy = ((IIdentifiableElement)content).getId();
        }
    }

    public boolean isChecked() {
        return this.checked;
    }

    public boolean isDuplicateId() {
        return this.duplicate != null && (this.duplicate == 3 || this.duplicate == 2);
    }

    public void setDuplicate(Integer duplicate) {
        this.duplicate = duplicate;
    }

    @Override
    public void setChecked(boolean checked, NameIDCache localNameIdCache) {
        this.checked = checked;
        Map.Entry entry = null;
        EObject copy = null;
        if (this.content instanceof Map.Entry) {
            entry = (Map.Entry)this.content;
            copy = (EObject)entry.getValue();
        }
        if (checked) {
            ((IIdentifiableElement)copy).setName(this.nameCopy);
            ((IIdentifiableElement)copy).setId(this.idCopy);
        } else if (!checked) {
            ((IIdentifiableElement)copy).setName("Copy Of " + this.nameCopy);
            ((IIdentifiableElement)copy).setId("CopyOf" + this.idCopy);
        }
    }

    public Object getContent() {
        return this.content;
    }
}

