/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.core.editors.cap;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.editparts.AbstractEditPart;
import org.eclipse.stardust.model.xpdl.carnot.AbstractEventSymbol;
import org.eclipse.stardust.model.xpdl.carnot.ActivitySymbolType;
import org.eclipse.stardust.model.xpdl.carnot.ActivityType;
import org.eclipse.stardust.model.xpdl.carnot.ApplicationType;
import org.eclipse.stardust.model.xpdl.carnot.CarnotWorkflowModelPackage;
import org.eclipse.stardust.model.xpdl.carnot.DataSymbolType;
import org.eclipse.stardust.model.xpdl.carnot.DataType;
import org.eclipse.stardust.model.xpdl.carnot.DiagramType;
import org.eclipse.stardust.model.xpdl.carnot.GatewaySymbol;
import org.eclipse.stardust.model.xpdl.carnot.IExtensibleElement;
import org.eclipse.stardust.model.xpdl.carnot.IGraphicalObject;
import org.eclipse.stardust.model.xpdl.carnot.IIdentifiableElement;
import org.eclipse.stardust.model.xpdl.carnot.IModelElement;
import org.eclipse.stardust.model.xpdl.carnot.IModelParticipant;
import org.eclipse.stardust.model.xpdl.carnot.INodeSymbol;
import org.eclipse.stardust.model.xpdl.carnot.LaneSymbol;
import org.eclipse.stardust.model.xpdl.carnot.ModelType;
import org.eclipse.stardust.model.xpdl.carnot.PoolSymbol;
import org.eclipse.stardust.model.xpdl.carnot.ProcessDefinitionType;
import org.eclipse.stardust.model.xpdl.carnot.ProcessSymbolType;
import org.eclipse.stardust.model.xpdl.carnot.PublicInterfaceSymbol;
import org.eclipse.stardust.model.xpdl.carnot.TriggerType;
import org.eclipse.stardust.model.xpdl.carnot.merge.MergeUtils;
import org.eclipse.stardust.model.xpdl.carnot.util.ModelUtils;
import org.eclipse.stardust.model.xpdl.xpdl2.TypeDeclarationType;
import org.eclipse.stardust.model.xpdl.xpdl2.TypeDeclarationsType;
import org.eclipse.stardust.modeling.core.editors.DiagramEditorPage;
import org.eclipse.stardust.modeling.core.editors.WorkflowModelEditor;
import org.eclipse.stardust.modeling.core.editors.cap.CreateSubprocess;
import org.eclipse.stardust.modeling.core.editors.cap.StoreObject;
import org.eclipse.stardust.modeling.core.editors.parts.diagram.AbstractNodeSymbolEditPart;
import org.eclipse.stardust.modeling.core.editors.parts.diagram.DiagramEditPart;
import org.eclipse.stardust.modeling.core.editors.parts.diagram.DiagramRootEditPart;
import org.eclipse.stardust.modeling.core.editors.parts.diagram.SymbolGroupEditPart;
import org.eclipse.stardust.modeling.core.editors.parts.tree.AbstractEObjectTreeEditPart;
import org.eclipse.stardust.modeling.core.editors.parts.tree.ChildCategoryNode;
import org.eclipse.stardust.modeling.core.editors.parts.tree.ModelTreeEditPart;
import org.eclipse.stardust.modeling.core.utils.GenericUtils;
import org.eclipse.stardust.modeling.core.utils.PoolLaneUtils;
import org.eclipse.xsd.XSDConcreteComponent;
import org.eclipse.xsd.XSDSchema;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class CopyPasteUtil {
    public static final String idPrefix = "CopyOf";
    public static final int SELECTION_OUTLINE = 1;
    public static final int SELECTION_GLOBAL_DIAGRAM = 2;
    public static final int SELECTION_MODEL_DIAGRAM = 3;
    public static final int SELECTION_PROCESS_DIAGRAM = 4;

    public static boolean validateSelectionForSubprocess(List selection) {
        ArrayList<ActivitySymbolType> activitySymbols = new ArrayList<ActivitySymbolType>();
        int i = 0;
        while (i < selection.size()) {
            Object element = selection.get(i);
            if (element instanceof SymbolGroupEditPart || element instanceof AbstractEObjectTreeEditPart || element instanceof IModelElement || element instanceof TypeDeclarationType) {
                return false;
            }
            if (!(element instanceof INodeSymbol) && !(element instanceof AbstractNodeSymbolEditPart)) {
                return false;
            }
            Object modelElement = null;
            if (element instanceof INodeSymbol) {
                modelElement = element;
            } else if (element instanceof AbstractNodeSymbolEditPart) {
                modelElement = ((AbstractEditPart)element).getModel();
            }
            if (modelElement instanceof ProcessSymbolType || modelElement instanceof PoolSymbol || modelElement instanceof LaneSymbol || modelElement instanceof AbstractEventSymbol) {
                return false;
            }
            if (ModelUtils.findContainingProcess((EObject)((EObject)modelElement)) == null) {
                return false;
            }
            if (modelElement instanceof ActivitySymbolType) {
                activitySymbols.add((ActivitySymbolType)modelElement);
            }
            ++i;
        }
        return CreateSubprocess.isValidActivityNetwork(activitySymbols);
    }

    public static Integer validateSelection(List selection, boolean cutAction) {
        boolean diagram = false;
        boolean modelDiagram = false;
        boolean processDiagram = false;
        boolean outline = false;
        boolean containsProcess = false;
        boolean containsDiagram = false;
        boolean containsLane = false;
        boolean containsOther = false;
        boolean isOutlineProcessChild = false;
        boolean isNotOutlineProcessChild = false;
        if (selection != null && selection.size() > 0) {
            int i = 0;
            while (i < selection.size()) {
                Object modelElement;
                Object element = selection.get(i);
                if (element instanceof PublicInterfaceSymbol) {
                    return null;
                }
                if (element instanceof SymbolGroupEditPart) {
                    return null;
                }
                if (element instanceof INodeSymbol) {
                    diagram = true;
                } else if (element instanceof AbstractNodeSymbolEditPart) {
                    diagram = true;
                } else if (element instanceof AbstractEObjectTreeEditPart) {
                    outline = true;
                } else if (element instanceof IModelElement) {
                    outline = true;
                } else if (element instanceof TypeDeclarationType) {
                    outline = true;
                } else {
                    return null;
                }
                if (outline) {
                    boolean match;
                    WorkflowModelEditor editor;
                    modelElement = null;
                    if (element instanceof AbstractEObjectTreeEditPart) {
                        modelElement = ((AbstractEditPart)element).getModel();
                    } else if (element instanceof IModelElement || element instanceof TypeDeclarationType) {
                        modelElement = element;
                    }
                    if (modelElement instanceof ChildCategoryNode.Spec) {
                        return null;
                    }
                    if (cutAction && (editor = GenericUtils.getWorkflowModelEditor(ModelUtils.findContainingModel((EObject)((EObject)modelElement)))) == null) {
                        return null;
                    }
                    if (modelElement instanceof ProcessDefinitionType) {
                        containsProcess = true;
                    }
                    if (modelElement instanceof DiagramType) {
                        containsDiagram = true;
                    }
                    boolean bl = match = modelElement instanceof DataType || modelElement instanceof TypeDeclarationType || modelElement instanceof IModelParticipant || modelElement instanceof ApplicationType || modelElement instanceof ProcessDefinitionType || modelElement instanceof ActivityType || modelElement instanceof TriggerType || modelElement instanceof DiagramType;
                    if (cutAction && modelElement instanceof DataType && ((DataType)modelElement).isPredefined()) {
                        return null;
                    }
                    if (modelElement instanceof ActivityType || modelElement instanceof TriggerType) {
                        isOutlineProcessChild = true;
                    } else {
                        isNotOutlineProcessChild = true;
                    }
                    if (!match) {
                        return null;
                    }
                    if (containsDiagram && containsProcess) {
                        return null;
                    }
                    if (isOutlineProcessChild && isNotOutlineProcessChild) {
                        return null;
                    }
                }
                if (diagram) {
                    DataType checkData;
                    WorkflowModelEditor editor;
                    modelElement = null;
                    if (element instanceof INodeSymbol) {
                        modelElement = element;
                    } else if (element instanceof AbstractNodeSymbolEditPart) {
                        modelElement = ((AbstractEditPart)element).getModel();
                    }
                    if (cutAction && (editor = GenericUtils.getWorkflowModelEditor(ModelUtils.findContainingModel((EObject)((EObject)modelElement)))) == null) {
                        return null;
                    }
                    if (modelElement instanceof PoolSymbol || modelElement instanceof LaneSymbol) {
                        return null;
                    }
                    if (ModelUtils.findContainingProcess((EObject)((EObject)modelElement)) == null) {
                        modelDiagram = true;
                    } else {
                        processDiagram = true;
                    }
                    if (modelElement instanceof LaneSymbol) {
                        containsLane = true;
                    } else {
                        containsOther = true;
                    }
                    if (containsLane && containsOther) {
                        return null;
                    }
                    if (cutAction && modelElement instanceof DataSymbolType && (checkData = ((DataSymbolType)modelElement).getData()) != null && checkData.isPredefined()) {
                        return null;
                    }
                }
                ++i;
            }
        }
        if (diagram || outline) {
            if (diagram) {
                if (modelDiagram) {
                    return new Integer(3);
                }
                if (processDiagram) {
                    return new Integer(4);
                }
            } else {
                return new Integer(1);
            }
        }
        return null;
    }

    public static boolean containsGateway(List selection) {
        if (selection != null && selection.size() > 0) {
            int i = 0;
            while (i < selection.size()) {
                Object element = selection.get(i);
                Object modelElement = null;
                if (element instanceof INodeSymbol) {
                    modelElement = element;
                } else if (element instanceof AbstractNodeSymbolEditPart) {
                    modelElement = ((AbstractEditPart)element).getModel();
                }
                if (modelElement != null && modelElement instanceof GatewaySymbol) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    public static List createCopySet(Integer isValid, List selectedObjects, WorkflowModelEditor editor, boolean copySymbols) {
        ArrayList<Object> contentList = new ArrayList<Object>();
        StoreObject storage = new StoreObject();
        ModelType sourceModel = null;
        ModelType originalModelCopy = null;
        DiagramType sourceDiagram = null;
        ProcessDefinitionType sourceProcess = null;
        if (isValid != 1) {
            DiagramEditorPage diagramEditorPage = (DiagramEditorPage)editor.getCurrentPage();
            Point location = diagramEditorPage.getMouseLocation().getCopy();
            storage.setLocation(location);
        }
        storage.setCopySymbols(copySymbols);
        int i = 0;
        while (i < selectedObjects.size()) {
            EList gatewaySymbols;
            EObject saveModelElement;
            Object entry = selectedObjects.get(i);
            EObject modelElement = (EObject)((AbstractEditPart)entry).getModel();
            if (sourceDiagram == null) {
                if (modelElement instanceof IGraphicalObject) {
                    sourceDiagram = ModelUtils.findContainingDiagram((IGraphicalObject)((IGraphicalObject)modelElement));
                } else {
                    boolean cfr_ignored_0 = modelElement instanceof DiagramType;
                }
            }
            if (sourceDiagram != null) {
                sourceProcess = ModelUtils.findContainingProcess(sourceDiagram);
            }
            if (sourceModel == null) {
                sourceModel = ModelUtils.findContainingModel((EObject)modelElement);
                EcoreUtil.Copier copier = new EcoreUtil.Copier(){
                    private static final long serialVersionUID = 1L;

                    public EObject copy(EObject object) {
                        if (object instanceof XSDConcreteComponent) {
                            XSDConcreteComponent original = (XSDConcreteComponent)object;
                            XSDConcreteComponent clone = original.cloneConcreteComponent(true, false);
                            XSDSchema schema = clone.getSchema();
                            Document doc = schema.updateDocument();
                            if (original.getElement() != null) {
                                Element clonedElement = (Element)doc.importNode(original.getElement(), true);
                                clone.setElement(clonedElement);
                            }
                            return clone;
                        }
                        return super.copy(object);
                    }
                };
                originalModelCopy = (ModelType)copier.copy((EObject)sourceModel);
                copier.copyReferences();
                ModelUtils.resolve((ModelType)sourceModel, (IExtensibleElement)sourceModel);
                ModelUtils.resolve((ModelType)originalModelCopy, (IExtensibleElement)originalModelCopy);
            }
            if ((saveModelElement = CopyPasteUtil.getSameModelElement(modelElement, originalModelCopy, null)) instanceof INodeSymbol) {
                Point location = new Point((double)((INodeSymbol)modelElement).getXPos(), (double)((INodeSymbol)modelElement).getYPos());
                EditPart hostEP = ((AbstractEditPart)entry).getParent();
                location = PoolLaneUtils.getAbsoluteLocation(hostEP, location, sourceDiagram);
                ((INodeSymbol)saveModelElement).setXPos((long)location.x);
                ((INodeSymbol)saveModelElement).setYPos((long)location.y);
            }
            if (saveModelElement instanceof ActivitySymbolType && !(gatewaySymbols = ((ActivitySymbolType)saveModelElement).getGatewaySymbols()).isEmpty()) {
                for (GatewaySymbol gatewaySymbol : gatewaySymbols) {
                    if (contentList.contains(gatewaySymbol)) continue;
                    EObject originalGatewaySymbol = CopyPasteUtil.getSameModelElement((EObject)gatewaySymbol, sourceModel, null);
                    EditPart editPart = editor.findEditPart(originalGatewaySymbol);
                    Point location = new Point((double)gatewaySymbol.getXPos(), (double)gatewaySymbol.getYPos());
                    EditPart hostEP = ((AbstractEditPart)editPart).getParent();
                    location = PoolLaneUtils.getAbsoluteLocation(hostEP, location, sourceDiagram);
                    gatewaySymbol.setXPos((long)location.x);
                    gatewaySymbol.setYPos((long)location.y);
                    contentList.add(gatewaySymbol);
                }
            }
            if (!contentList.contains(saveModelElement)) {
                contentList.add(saveModelElement);
            }
            ++i;
        }
        if (sourceDiagram != null) {
            storage.setSourceDiagram(sourceDiagram);
        }
        if (sourceProcess != null) {
            storage.setSourceProcess(sourceProcess);
        }
        storage.setOriginalModelCopy(originalModelCopy);
        storage.setSourceModel(sourceModel);
        contentList.add(storage);
        return contentList;
    }

    public static EObject getSameModelElement(EObject source, ModelType target, Map changedCache) {
        return MergeUtils.getSameModelElement((EObject)source, (ModelType)target, (Map)changedCache);
    }

    public static EObject getSameElement(EObject source, EObject model) {
        return MergeUtils.getSameElement((EObject)source, (EObject)model);
    }

    public static boolean isProcessChildOnly(List copySet) {
        int i = 0;
        while (i < copySet.size()) {
            EObject child = (EObject)copySet.get(i);
            if (!(child instanceof ActivityType) && !(child instanceof TriggerType)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean isTypeDeclarationOnly(List copySet) {
        int i = 0;
        while (i < copySet.size()) {
            EObject child = (EObject)copySet.get(i);
            if (!(child instanceof TypeDeclarationType)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean isDataOnly(List copySet) {
        int i = 0;
        while (i < copySet.size()) {
            EObject child = (EObject)copySet.get(i);
            if (!(child instanceof DataType)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean isParticipantOnly(List copySet) {
        int i = 0;
        while (i < copySet.size()) {
            EObject child = (EObject)copySet.get(i);
            if (!(child instanceof IModelParticipant)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean isApplicationOnly(List copySet) {
        int i = 0;
        while (i < copySet.size()) {
            EObject child = (EObject)copySet.get(i);
            if (!(child instanceof ApplicationType)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean isProcessDiagramOnly(List copySet, ProcessDefinitionType selectedProcess, ModelType originalModel) {
        int i = 0;
        while (i < copySet.size()) {
            EObject child = (EObject)copySet.get(i);
            if (!(child instanceof DiagramType)) {
                return false;
            }
            ProcessDefinitionType process = ModelUtils.findContainingProcess((EObject)child);
            if (process == null) {
                return false;
            }
            ProcessDefinitionType originalProcess = (ProcessDefinitionType)CopyPasteUtil.getSameModelElement((EObject)process, originalModel, null);
            if (!originalProcess.equals(selectedProcess)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean containsDiagram(List copySet) {
        int i = 0;
        while (i < copySet.size()) {
            EObject child = (EObject)copySet.get(i);
            if (child instanceof DiagramType) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static boolean containsProcessDiagram(List copySet) {
        int i = 0;
        while (i < copySet.size()) {
            DiagramType diagram;
            ProcessDefinitionType process;
            EObject child = (EObject)copySet.get(i);
            if (child instanceof DiagramType && (process = ModelUtils.findContainingProcess((EObject)(diagram = (DiagramType)child))) != null) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static boolean containsProcessChild(List copySet) {
        int i = 0;
        while (i < copySet.size()) {
            EObject child = (EObject)copySet.get(i);
            if (child instanceof ActivityType || child instanceof TriggerType) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static boolean isTypeDeclarationsNode(Object selection) {
        Object model;
        return selection instanceof EditPart && (model = ((EditPart)selection).getModel()) != null && model instanceof TypeDeclarationsType;
    }

    public static boolean isDataCategoryNode(Object selection) {
        return selection instanceof ChildCategoryNode && Arrays.asList(((ChildCategoryNode)selection).getChildrenFeatures()).contains(CarnotWorkflowModelPackage.eINSTANCE.getModelType_Data());
    }

    public static boolean isParticipantCategoryNode(Object selection) {
        if (selection instanceof ChildCategoryNode) {
            if (Arrays.asList(((ChildCategoryNode)selection).getChildrenFeatures()).contains(CarnotWorkflowModelPackage.eINSTANCE.getModelType_ConditionalPerformer())) {
                return true;
            }
            if (Arrays.asList(((ChildCategoryNode)selection).getChildrenFeatures()).contains(CarnotWorkflowModelPackage.eINSTANCE.getModelType_Organization())) {
                return true;
            }
            if (Arrays.asList(((ChildCategoryNode)selection).getChildrenFeatures()).contains(CarnotWorkflowModelPackage.eINSTANCE.getModelType_Role())) {
                return true;
            }
        }
        return false;
    }

    public static boolean isApplicationCategoryNode(Object selection) {
        return selection instanceof ChildCategoryNode && Arrays.asList(((ChildCategoryNode)selection).getChildrenFeatures()).contains(CarnotWorkflowModelPackage.eINSTANCE.getModelType_Application());
    }

    public static ProcessDefinitionType isProcessCategoryNode(Object selection) {
        Object model;
        if (selection instanceof EditPart && (model = ((EditPart)selection).getModel()) instanceof ProcessDefinitionType) {
            return (ProcessDefinitionType)model;
        }
        return null;
    }

    public static boolean isModelCategoryNode(Object selection) {
        return selection instanceof ModelTreeEditPart;
    }

    public static void replaceChangedNames(Map<EObject, EObject> changedCache, ModelType model) {
        for (Map.Entry<EObject, EObject> entry : changedCache.entrySet()) {
            EObject raw = entry.getKey();
            EObject copy = entry.getValue();
            EObject element = CopyPasteUtil.getSameModelElement(raw, model, changedCache);
            if (element == null) continue;
            if (copy instanceof DiagramType) {
                ((DiagramType)element).setName(((DiagramType)copy).getName());
                continue;
            }
            if (copy instanceof IIdentifiableElement) {
                ((IIdentifiableElement)element).setId(((IIdentifiableElement)copy).getId());
                ((IIdentifiableElement)element).setName(((IIdentifiableElement)copy).getName());
                continue;
            }
            if (!(copy instanceof TypeDeclarationType)) continue;
            ((TypeDeclarationType)element).setId(((TypeDeclarationType)copy).getId());
            ((TypeDeclarationType)element).setName(((TypeDeclarationType)copy).getName());
        }
    }

    public static IModelElement getRawSymbolFromList(List rawSymbols, INodeSymbol copy) {
        int i = 0;
        while (i < rawSymbols.size()) {
            IModelElement raw = (IModelElement)rawSymbols.get(i);
            if (raw.getElementOid() == copy.getElementOid()) {
                return raw;
            }
            ++i;
        }
        return null;
    }

    public static String getNewTypeDeclarationId(List allDeclarations, String currentId, String prefix) {
        StringBuffer generatedString = new StringBuffer(prefix);
        generatedString.append(currentId);
        while (allDeclarations.contains(generatedString.toString())) {
            generatedString.insert(0, prefix);
        }
        allDeclarations.add(generatedString.toString());
        return generatedString.toString();
    }

    public static ModelType getTargetModel(Object selectedObject) {
        if (selectedObject instanceof EditPart) {
            DiagramEditPart diagramEP = null;
            DiagramType diagram = null;
            if (selectedObject instanceof DiagramEditPart || selectedObject instanceof DiagramRootEditPart) {
                if (selectedObject instanceof DiagramEditPart) {
                    diagramEP = (DiagramEditPart)selectedObject;
                } else if (selectedObject instanceof DiagramRootEditPart) {
                    diagramEP = (DiagramEditPart)((DiagramRootEditPart)((Object)selectedObject)).getChildren().get(0);
                }
                if (diagramEP != null) {
                    diagram = (DiagramType)diagramEP.getModel();
                }
                if (diagram != null) {
                    return ModelUtils.findContainingModel((EObject)diagram);
                }
            }
            if (selectedObject instanceof ChildCategoryNode) {
                InvocationHandler handler;
                ChildCategoryNode.Spec spec = (ChildCategoryNode.Spec)((ChildCategoryNode)selectedObject).getModel();
                EObject target = spec.getTarget();
                if (target instanceof Proxy && (handler = Proxy.getInvocationHandler(target)) instanceof ModelUtils.EObjectInvocationHandler) {
                    EObject model = ((ModelUtils.EObjectInvocationHandler)handler).getModel();
                    return model instanceof ModelType ? (ModelType)model : null;
                }
                return target instanceof ModelType ? (ModelType)target : null;
            }
            if (selectedObject instanceof ModelTreeEditPart) {
                return (ModelType)((ModelTreeEditPart)selectedObject).getModel();
            }
            Object model = ((EditPart)selectedObject).getModel();
            if (model instanceof ProcessDefinitionType) {
                return ModelUtils.findContainingModel((EObject)((EObject)model));
            }
            if (model instanceof TypeDeclarationsType) {
                return (ModelType)((TypeDeclarationsType)model).eContainer();
            }
        }
        return null;
    }

    public static EObject getEObjectFromSelection(Object element) {
        Object modelElement = null;
        modelElement = element instanceof AbstractEObjectTreeEditPart ? ((AbstractEditPart)element).getModel() : (element instanceof AbstractNodeSymbolEditPart ? ((AbstractEditPart)element).getModel() : element);
        if (modelElement instanceof DiagramRootEditPart) {
            modelElement = (DiagramEditPart)((DiagramRootEditPart)((Object)modelElement)).getChildren().get(0);
        }
        if (modelElement instanceof DiagramEditPart) {
            modelElement = ((DiagramEditPart)modelElement).getModel();
        }
        if (modelElement instanceof ChildCategoryNode.Spec) {
            return null;
        }
        return (EObject)modelElement;
    }
}

