/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.core.editors.cap;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.stardust.model.xpdl.carnot.LaneSymbol;
import org.eclipse.stardust.modeling.core.editors.cap.MergerUtil;

public class LaneUtils {
    public static List createLaneHierarchyCopy(LaneSymbol symbol, EcoreUtil.Copier copier) {
        ArrayList<Object> allLanes = new ArrayList<Object>();
        HashMap<MergerUtil.MergerEntry, List> entries = new HashMap<MergerUtil.MergerEntry, List>();
        EList lanes = symbol.getChildLanes();
        if (lanes.isEmpty()) {
            return allLanes;
        }
        int i = 0;
        while (i < lanes.size()) {
            LaneSymbol laneSymbol = (LaneSymbol)lanes.get(i);
            MergerUtil.MergerEntry symbolEntry = new MergerUtil.MergerEntry((EObject)laneSymbol, copier.copy((EObject)laneSymbol));
            EList childLanes = laneSymbol.getChildLanes();
            if (childLanes.isEmpty()) {
                allLanes.add(symbolEntry);
            } else {
                List children = LaneUtils.createLaneHierarchyCopy(laneSymbol, copier);
                entries.put(symbolEntry, children);
            }
            ++i;
        }
        if (!entries.isEmpty()) {
            allLanes.add(entries);
        }
        return allLanes;
    }

    public static List createLaneHierarchy(LaneSymbol symbol) {
        ArrayList<Object> allLanes = new ArrayList<Object>();
        HashMap<LaneSymbol, List> entries = new HashMap<LaneSymbol, List>();
        EList lanes = symbol.getChildLanes();
        if (lanes.isEmpty()) {
            return allLanes;
        }
        if (!symbol.getNodes().isEmpty()) {
            return null;
        }
        int i = 0;
        while (i < lanes.size()) {
            LaneSymbol laneSymbol = (LaneSymbol)lanes.get(i);
            EList childLanes = laneSymbol.getChildLanes();
            if (childLanes.isEmpty()) {
                allLanes.add(laneSymbol);
            } else {
                List children = LaneUtils.createLaneHierarchy(laneSymbol);
                entries.put(laneSymbol, children);
            }
            ++i;
        }
        if (!entries.isEmpty()) {
            allLanes.add(entries);
        }
        return allLanes;
    }

    public static boolean containsLane(List checkHierarchy, LaneSymbol checkLane) {
        int i = 0;
        while (i < checkHierarchy.size()) {
            Object child = checkHierarchy.get(i);
            if (child instanceof LaneSymbol) {
                if (child.equals(checkLane)) {
                    return true;
                }
            } else {
                Map children = (Map)child;
                for (Map.Entry entry : children.entrySet()) {
                    LaneSymbol entryLane = (LaneSymbol)entry.getKey();
                    if (entryLane.equals(checkLane)) {
                        return true;
                    }
                    List entryHierarchy = (List)entry.getValue();
                    if (!LaneUtils.containsLane(entryHierarchy, checkLane)) continue;
                    return true;
                }
            }
            ++i;
        }
        return false;
    }
}

