/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.core.editors.cap;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.stardust.model.xpdl.carnot.IIdentifiableElement;
import org.eclipse.stardust.model.xpdl.carnot.ProcessDefinitionType;
import org.eclipse.stardust.modeling.core.editors.cap.ContentDecorator;
import org.eclipse.stardust.modeling.core.editors.cap.CopyPasteUtil;
import org.eclipse.stardust.modeling.core.editors.cap.InputContainer;
import org.eclipse.stardust.modeling.core.editors.cap.MergerUtil;
import org.eclipse.stardust.modeling.core.editors.cap.StoreObject;

public class NameIDCache {
    public static final int DUPLICATE_NAME = 1;
    public static final int DUPLICATE_ID = 2;
    public static final int DUPLICATE_BOTH = 3;
    private StoreObject storage;
    private Map nameIdCache;
    private Map changedCache;
    private InputContainer referenceValueInput;

    public NameIDCache(StoreObject storage, Map changedCache, Map nameIdCache, InputContainer referenceValueInput) {
        this.storage = storage;
        this.changedCache = changedCache;
        this.nameIdCache = new HashMap(nameIdCache);
        this.referenceValueInput = referenceValueInput;
    }

    public Integer checkElement(Map.Entry entry) {
        Integer returnValue = null;
        EObject raw = (EObject)entry.getKey();
        EObject copy = (EObject)entry.getValue();
        EClass eClass = copy.eClass();
        EObject parent = raw.eContainer();
        EObject checkParent = (EObject)this.changedCache.get(parent);
        if (checkParent != null) {
            parent = checkParent;
        }
        parent = CopyPasteUtil.getSameModelElement(parent, this.storage.getTargetModel(), null);
        String id = null;
        String name = null;
        if (copy instanceof IIdentifiableElement) {
            id = ((IIdentifiableElement)copy).getId();
            name = ((IIdentifiableElement)copy).getName();
        }
        if (this.storage.isDiagram() && parent instanceof ProcessDefinitionType) {
            parent = this.storage.getTargetProcess();
        }
        HashMap eClassNameIdCache = new HashMap();
        HashMap localNameIdCache = null;
        if (this.nameIdCache.containsKey(parent) && (eClassNameIdCache = (HashMap)this.nameIdCache.get(parent)).containsKey(eClass) && copy instanceof IIdentifiableElement) {
            boolean duplicateId = false;
            boolean duplicateName = false;
            localNameIdCache = (HashMap)eClassNameIdCache.get(eClass);
            for (Map.Entry cacheEntry : localNameIdCache.entrySet()) {
                String cacheId = (String)cacheEntry.getKey();
                String cacheName = (String)cacheEntry.getValue();
                if (id.equals(cacheId)) {
                    duplicateId = true;
                }
                if (!name.equals(cacheName)) continue;
                duplicateName = true;
            }
            if (duplicateId && duplicateName) {
                returnValue = new Integer(3);
            } else if (duplicateId) {
                returnValue = new Integer(2);
            } else if (duplicateName) {
                returnValue = new Integer(1);
            }
        }
        if (returnValue == null) {
            List contentList = this.referenceValueInput.getContainer().getAllContent();
            int i = 0;
            while (i < contentList.size()) {
                ContentDecorator containerEntry = (ContentDecorator)contentList.get(i);
                if (!containerEntry.isChecked()) {
                    MergerUtil.MergerEntry dialogEntry = (MergerUtil.MergerEntry)containerEntry.getContent();
                    EObject containerCopy = dialogEntry.getValue();
                    EClass containereClass = containerCopy.eClass();
                    if (!dialogEntry.equals(entry) && containerCopy instanceof IIdentifiableElement) {
                        String containerId = ((IIdentifiableElement)containerCopy).getId();
                        String containerName = ((IIdentifiableElement)containerCopy).getName();
                        if (eClass.equals(containereClass)) {
                            returnValue = id.equals(containerId) && name.equals(containerName) ? new Integer(3) : (id.equals(containerId) ? new Integer(2) : (name.equals(containerName) ? new Integer(1) : null));
                        }
                    }
                }
                ++i;
            }
        }
        return returnValue;
    }
}

