/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.core.editors.cap;

import java.util.List;
import java.util.Map;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.stardust.common.StringUtils;
import org.eclipse.stardust.model.xpdl.carnot.util.ModelUtils;
import org.eclipse.stardust.modeling.common.platform.validation.IQuickValidationStatus;
import org.eclipse.stardust.modeling.common.ui.jface.utils.FormBuilder;
import org.eclipse.stardust.modeling.common.ui.jface.utils.LabeledText;
import org.eclipse.stardust.modeling.core.Diagram_Messages;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class NameIdDialog
extends Dialog {
    private Map<String, String> nameIdCache;
    private List nameCache;
    private LabeledText idEntry;
    private LabeledText nameEntry;
    private String id;
    private String name;
    private boolean nameOnly = false;
    private String namePrefix = "Copy Of ";
    private String idPrefix = "CopyOf";
    private String dialogTitle = null;
    protected Button autoIdButton;
    private SelectionListener autoIdListener = new SelectionListener(){

        public void widgetDefaultSelected(SelectionEvent e) {
        }

        public void widgetSelected(SelectionEvent e) {
            boolean selection = ((Button)e.widget).getSelection();
            if (selection) {
                NameIdDialog.this.idEntry.getText().setEditable(false);
                String computedId = ModelUtils.computeId((String)NameIdDialog.this.nameEntry.getText().getText());
                NameIdDialog.this.idEntry.getText().setText(computedId);
            } else {
                NameIdDialog.this.idEntry.getText().setEditable(true);
            }
        }
    };
    private ModifyListener idListener = new ModifyListener(){

        public void modifyText(ModifyEvent e) {
            if (NameIdDialog.this.idEntry != null && NameIdDialog.this.nameEntry != null) {
                boolean enabled = false;
                enabled = NameIdDialog.this.validateUserInput();
                Button okButton = NameIdDialog.this.getButton(0);
                if (okButton != null) {
                    okButton.setEnabled(enabled);
                }
            }
        }
    };
    private ModifyListener nameListener = new ModifyListener(){

        public void modifyText(ModifyEvent e) {
            if (NameIdDialog.this.idEntry != null && NameIdDialog.this.nameEntry != null) {
                if (NameIdDialog.this.id != null && NameIdDialog.this.autoIdButton.getSelection()) {
                    String computedId = ModelUtils.computeId((String)NameIdDialog.this.nameEntry.getText().getText());
                    NameIdDialog.this.idEntry.getText().setText(computedId);
                }
                boolean enabled = false;
                enabled = NameIdDialog.this.validateUserInput();
                Button okButton = NameIdDialog.this.getButton(0);
                if (okButton != null) {
                    okButton.setEnabled(enabled);
                }
            }
        }
    };

    public NameIdDialog(Shell parent, String id, String name, Map<String, String> nameIdCache) {
        super(parent);
        this.nameIdCache = nameIdCache;
        this.id = id;
        this.name = name;
    }

    public NameIdDialog(Shell parent, String name, List nameCache) {
        super(parent);
        this.nameCache = nameCache;
        this.name = name;
        this.nameOnly = true;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        this.setDialogTitle();
        shell.setText(this.dialogTitle);
    }

    public void setNamePrefix(String prefix) {
        this.namePrefix = prefix;
    }

    public void setIdPrefix(String prefix) {
        this.idPrefix = prefix;
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public Map<String, String> getNameIdCache() {
        return this.nameIdCache;
    }

    public List getNameCache() {
        return this.nameCache;
    }

    protected Control createDialogArea(Composite parent) {
        Composite panel = (Composite)super.createDialogArea(parent);
        ((GridLayout)panel.getLayout()).numColumns = 2;
        this.nameEntry = FormBuilder.createLabeledText((Composite)panel, (String)Diagram_Messages.NameIdDialog_Name);
        this.idEntry = FormBuilder.createLabeledText((Composite)panel, (String)Diagram_Messages.NameIdDialog_ID);
        this.nameEntry.getText().addModifyListener(this.nameListener);
        String prefixName = this.generatePrefixString(true);
        this.autoIdButton = FormBuilder.createCheckBox((Composite)panel, (String)Diagram_Messages.BTN_AutoId, (int)2);
        boolean autoIdButtonValue = PlatformUI.getPreferenceStore().getBoolean("org.eclipse.stardust.modeling.common.projectnature.autoIdGeneration");
        this.autoIdButton.setSelection(autoIdButtonValue);
        if (autoIdButtonValue) {
            this.idEntry.getText().setEditable(false);
        }
        this.autoIdButton.addSelectionListener(this.autoIdListener);
        this.nameEntry.getText().setText(prefixName);
        if (this.id != null) {
            this.idEntry.getText().addModifyListener(this.idListener);
            String prefixId = this.generatePrefixString(false);
            this.idEntry.getText().setText(prefixId);
        } else {
            this.autoIdButton.setEnabled(false);
            this.idEntry.getText().setEnabled(false);
        }
        return panel;
    }

    private String generatePrefixString(boolean isName) {
        StringBuffer generatedString = null;
        generatedString = this.nameOnly || isName ? new StringBuffer(this.namePrefix) : new StringBuffer(this.idPrefix);
        if (this.nameOnly) {
            generatedString.append(this.name);
            while (this.nameCache.contains(generatedString.toString())) {
                generatedString.insert(0, this.namePrefix);
            }
            return generatedString.toString();
        }
        if (isName) {
            generatedString.append(this.name);
            while (this.nameIdCache.containsValue(generatedString.toString())) {
                generatedString.insert(0, this.namePrefix);
            }
        } else {
            generatedString.append(this.id);
            while (this.nameIdCache.containsKey(generatedString.toString())) {
                generatedString.insert(0, this.idPrefix);
            }
        }
        return generatedString.toString();
    }

    private void setDialogTitle() {
        boolean isDuplicateId = false;
        boolean isDuplicateName = false;
        if (this.id != null && this.nameIdCache.containsKey(this.id)) {
            isDuplicateId = true;
        }
        if (this.nameOnly && this.nameCache.contains(this.name) || !this.nameOnly && this.nameIdCache.containsValue(this.name)) {
            isDuplicateName = true;
        }
        if (isDuplicateId && isDuplicateName) {
            this.dialogTitle = new String(Diagram_Messages.NameIdDialog_Title_DuplicateNameID);
        } else if (isDuplicateId) {
            this.dialogTitle = new String(Diagram_Messages.NameIdDialog_Title_DuplicateID);
        } else if (isDuplicateName) {
            this.dialogTitle = new String(Diagram_Messages.NameIdDialog_Title_DuplicateName);
        }
    }

    private boolean validateUserInput() {
        boolean isEmptyId = false;
        boolean isDuplicateId = false;
        if (this.id != null) {
            this.idEntry.getLabel().setValidationStatus(IQuickValidationStatus.OK);
            isEmptyId = StringUtils.isEmpty((String)this.idEntry.getText().getText());
            isDuplicateId = false;
            if (isEmptyId) {
                this.idEntry.getLabel().setValidationStatus(IQuickValidationStatus.ERRORS);
                this.idEntry.getLabel().setToolTipText(Diagram_Messages.NameIdDialog_Warning_IdEmpty);
            } else if (this.nameIdCache.containsKey(this.idEntry.getText().getText())) {
                isDuplicateId = true;
                this.idEntry.getLabel().setValidationStatus(IQuickValidationStatus.ERRORS);
                this.idEntry.getLabel().setToolTipText(Diagram_Messages.NameIdDialog_Warning_IdExists);
            }
        }
        this.nameEntry.getLabel().setValidationStatus(IQuickValidationStatus.OK);
        boolean isEmptyName = StringUtils.isEmpty((String)this.nameEntry.getText().getText());
        if (isEmptyName) {
            this.nameEntry.getLabel().setValidationStatus(IQuickValidationStatus.WARNINGS);
            this.idEntry.getLabel().setToolTipText(Diagram_Messages.NameIdDialog_Warning_NameEmpty);
        } else if (this.nameOnly && this.nameCache.contains(this.nameEntry.getText().getText()) || !this.nameOnly && this.nameIdCache.containsValue(this.nameEntry.getText().getText())) {
            this.nameEntry.getLabel().setValidationStatus(IQuickValidationStatus.WARNINGS);
            this.idEntry.getLabel().setToolTipText(Diagram_Messages.NameIdDialog_Warning_NameExists);
        }
        return !isEmptyId && !isDuplicateId;
    }

    public void create() {
        super.create();
        boolean enabled = false;
        enabled = this.validateUserInput();
        Button okButton = this.getButton(0);
        if (okButton != null) {
            okButton.setEnabled(enabled);
        }
    }

    protected void okPressed() {
        this.id = this.idEntry.getText().getText();
        this.name = this.nameEntry.getText().getText();
        if (this.nameOnly) {
            this.nameCache.add(this.name);
        } else {
            this.nameIdCache.put(this.id, this.name);
        }
        super.okPressed();
    }
}

