/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.core.editors.cap;

import java.util.Map;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ITableColorProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.stardust.model.xpdl.carnot.IIdentifiableElement;
import org.eclipse.stardust.modeling.common.ui.jface.utils.FormBuilder;
import org.eclipse.stardust.modeling.core.Diagram_Messages;
import org.eclipse.stardust.modeling.core.editors.cap.ContentDecorator;
import org.eclipse.stardust.modeling.core.editors.cap.ICheck;
import org.eclipse.stardust.modeling.core.editors.cap.IContainerTypes;
import org.eclipse.stardust.modeling.core.editors.cap.InputContainer;
import org.eclipse.stardust.modeling.core.editors.cap.NameIDCache;
import org.eclipse.stardust.modeling.core.editors.ui.TableUtil;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;

public class ReferenceValueDialog
extends Dialog {
    private static final int MIN_WIDTH = 400;
    private static final int MIN_HEIGHT = 400;
    public static final Object[] EMPTY_ARRAY = new Object[0];
    public static final String NAME_COLUMN = "Name";
    public static final String ID_COLUMN = "ID";
    private CheckboxTreeViewer viewer;
    private InputContainer input;
    private boolean initFlag = true;
    private NameIDCache localNameIdCache;

    public ReferenceValueDialog(Shell shell, InputContainer referenceValueInput, NameIDCache localNameIdCache) {
        super(shell);
        this.setShellStyle(this.getShellStyle() | 0x10 | 0x400);
        this.input = referenceValueInput;
        this.localNameIdCache = localNameIdCache;
    }

    public Point getInitialSize() {
        return new Point(400, 400);
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(Diagram_Messages.ReferenceValueDialog_Title);
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = FormBuilder.createComposite((Composite)parent, (int)1);
        String info = Diagram_Messages.ReferenceValueDialog_Info;
        FormBuilder.createLabel((Composite)composite, (String)info, (int)1);
        Tree tree = new Tree(composite, 67616);
        tree.setHeaderVisible(true);
        tree.setLayoutData((Object)FormBuilder.createDefaultLimitedMultiLineWidgetGridData((int)200));
        FormBuilder.applyDefaultTextControlWidth((Control)tree);
        String[] columnProperties = new String[]{NAME_COLUMN, ID_COLUMN};
        this.viewer = new CheckboxTreeViewer(tree);
        this.viewer.setColumnProperties(columnProperties);
        TableUtil.createColumns(tree, columnProperties);
        TableUtil.setInitialColumnSizes(tree, new int[]{61, 39});
        this.viewer.setCellModifier((ICellModifier)new CellModifier(this, this.viewer));
        TextCellEditor[] editors = new TextCellEditor[]{new TextCellEditor((Composite)tree), new TextCellEditor((Composite)tree)};
        this.viewer.setCellEditors((CellEditor[])editors);
        this.viewer.setLabelProvider((IBaseLabelProvider)new TableLabelProvider());
        this.viewer.setContentProvider((IContentProvider)new ContentProvider());
        this.viewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                Object element = event.getElement();
                if (element instanceof ICheck) {
                    ((ICheck)element).setChecked(event.getChecked(), ReferenceValueDialog.this.localNameIdCache);
                }
                ReferenceValueDialog.this.viewer.setSubtreeChecked(element, event.getChecked());
                Object[] elements = ReferenceValueDialog.this.viewer.getCheckedElements();
                TreePath[] treePaths = ReferenceValueDialog.this.viewer.getExpandedTreePaths();
                ReferenceValueDialog.this.viewer.refresh();
                ReferenceValueDialog.this.viewer.expandAll();
                ReferenceValueDialog.this.viewer.setExpandedTreePaths(treePaths);
                ReferenceValueDialog.this.viewer.setCheckedElements(elements);
                Button okButton = ReferenceValueDialog.this.getButton(0);
                if (okButton != null) {
                    okButton.setEnabled(!ReferenceValueDialog.this.input.getContainer().hasDuplicateIds());
                }
            }
        });
        this.viewer.setUseHashlookup(true);
        this.input.getContainer().setChecked(true, null);
        this.viewer.setInput((Object)this.input);
        this.viewer.setAllChecked(true);
        this.viewer.expandAll();
        this.initFlag = false;
        return composite;
    }

    class CellModifier
    implements ICellModifier {
        ReferenceValueDialog dialog;

        public CellModifier(ReferenceValueDialog dialog, CheckboxTreeViewer viewer) {
            this.dialog = dialog;
        }

        public boolean canModify(Object element, String property) {
            return (ReferenceValueDialog.ID_COLUMN.equals(property) || ReferenceValueDialog.NAME_COLUMN.equals(property)) && element instanceof ContentDecorator && !((ContentDecorator)element).isChecked();
        }

        public Object getValue(Object element, String property) {
            if (element instanceof ContentDecorator) {
                Object content = ((ContentDecorator)element).getContent();
                if (content instanceof Map.Entry) {
                    content = ((Map.Entry)content).getValue();
                }
                if (content instanceof IIdentifiableElement) {
                    if (ReferenceValueDialog.ID_COLUMN.equals(property)) {
                        return ((IIdentifiableElement)content).getId();
                    }
                    if (ReferenceValueDialog.NAME_COLUMN.equals(property)) {
                        return ((IIdentifiableElement)content).getName();
                    }
                }
            }
            return null;
        }

        public void modify(Object element, String property, Object value) {
            Button okButton;
            if (value == null) {
                return;
            }
            ContentDecorator contentDecorator = null;
            if (element instanceof TreeItem) {
                contentDecorator = (ContentDecorator)((TreeItem)element).getData();
            }
            if (contentDecorator != null) {
                Object content = contentDecorator.getContent();
                if (content instanceof Map.Entry) {
                    content = ((Map.Entry)content).getValue();
                }
                if (content instanceof IIdentifiableElement) {
                    if (ReferenceValueDialog.ID_COLUMN.equals(property)) {
                        ((IIdentifiableElement)content).setId((String)value);
                    } else if (ReferenceValueDialog.NAME_COLUMN.equals(property)) {
                        ((IIdentifiableElement)content).setName((String)value);
                    }
                    ReferenceValueDialog.this.viewer.update((Object)contentDecorator, null);
                }
            }
            if ((okButton = ReferenceValueDialog.this.getButton(0)) != null) {
                okButton.setEnabled(!ReferenceValueDialog.this.input.getContainer().hasDuplicateIds());
            }
        }
    }

    class ContentProvider
    implements ITreeContentProvider {
        ContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            return this.getChildren(inputElement);
        }

        public Object[] getChildren(Object parentElement) {
            if (parentElement instanceof InputContainer) {
                return new Object[]{((InputContainer)parentElement).getContainer()};
            }
            if (parentElement instanceof IContainerTypes) {
                return ((IContainerTypes)parentElement).getContent().toArray();
            }
            return EMPTY_ARRAY;
        }

        public Object getParent(Object element) {
            return null;
        }

        public boolean hasChildren(Object element) {
            Object[] children = this.getChildren(element);
            return children.length > 0;
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    class TableLabelProvider
    implements ITableLabelProvider,
    ITableColorProvider {
        TableLabelProvider() {
        }

        public String getColumnText(Object element, int index) {
            if (element instanceof IContainerTypes) {
                if (index == 0) {
                    return ((IContainerTypes)element).getLabel();
                }
            } else if (element instanceof ContentDecorator) {
                Object content = ((ContentDecorator)element).getContent();
                if (content instanceof Map.Entry) {
                    content = ((Map.Entry)content).getValue();
                }
                if (content instanceof IIdentifiableElement) {
                    switch (index) {
                        case 0: {
                            return ((IIdentifiableElement)content).getName();
                        }
                        case 1: {
                            return ((IIdentifiableElement)content).getId();
                        }
                    }
                }
            }
            return "";
        }

        public Color getForeground(Object element, int index) {
            if (ReferenceValueDialog.this.initFlag) {
                ReferenceValueDialog.this.viewer.setChecked(element, true);
            }
            Map.Entry entry = null;
            ContentDecorator contentDecorator = null;
            boolean isName = false;
            if (element instanceof IContainerTypes) {
                return null;
            }
            if (element instanceof ContentDecorator) {
                contentDecorator = (ContentDecorator)element;
                Object content = contentDecorator.getContent();
                if (content instanceof Map.Entry) {
                    entry = (Map.Entry)content;
                    content = ((Map.Entry)content).getValue();
                }
                if (content instanceof IIdentifiableElement) {
                    boolean bl = isName = index == 0;
                }
                if (contentDecorator.isChecked()) {
                    contentDecorator.setDuplicate(null);
                    return ColorConstants.black;
                }
                if (entry != null) {
                    Integer result = ReferenceValueDialog.this.localNameIdCache.checkElement(entry);
                    contentDecorator.setDuplicate(result);
                    if (result != null) {
                        switch (result) {
                            case 2: {
                                if (isName) break;
                                return ColorConstants.red;
                            }
                            case 1: {
                                if (!isName) break;
                                return ColorConstants.red;
                            }
                            case 3: {
                                return ColorConstants.red;
                            }
                        }
                    }
                }
            }
            return ColorConstants.black;
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public Color getBackground(Object element, int columnIndex) {
            return null;
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void dispose() {
        }

        public void removeListener(ILabelProviderListener listener) {
        }
    }
}

