/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.core.editors.dnd;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.gef.EditDomain;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.UnexecutableCommand;
import org.eclipse.gef.requests.CreateRequest;
import org.eclipse.stardust.engine.core.pojo.data.Type;
import org.eclipse.stardust.model.xpdl.carnot.ActivityImplementationType;
import org.eclipse.stardust.model.xpdl.carnot.ActivityType;
import org.eclipse.stardust.model.xpdl.carnot.ApplicationType;
import org.eclipse.stardust.model.xpdl.carnot.CarnotWorkflowModelFactory;
import org.eclipse.stardust.model.xpdl.carnot.CarnotWorkflowModelPackage;
import org.eclipse.stardust.model.xpdl.carnot.DataType;
import org.eclipse.stardust.model.xpdl.carnot.DataTypeType;
import org.eclipse.stardust.model.xpdl.carnot.IExtensibleElement;
import org.eclipse.stardust.model.xpdl.carnot.IIdentifiableModelElement;
import org.eclipse.stardust.model.xpdl.carnot.IModelElement;
import org.eclipse.stardust.model.xpdl.carnot.ISymbolContainer;
import org.eclipse.stardust.model.xpdl.carnot.IdRef;
import org.eclipse.stardust.model.xpdl.carnot.ModelType;
import org.eclipse.stardust.model.xpdl.carnot.ProcessDefinitionType;
import org.eclipse.stardust.model.xpdl.carnot.SubProcessModeType;
import org.eclipse.stardust.model.xpdl.carnot.spi.SpiExtensionRegistry;
import org.eclipse.stardust.model.xpdl.carnot.util.AttributeUtil;
import org.eclipse.stardust.model.xpdl.carnot.util.ModelUtils;
import org.eclipse.stardust.model.xpdl.util.IObjectReference;
import org.eclipse.stardust.model.xpdl.xpdl2.ExternalReferenceType;
import org.eclipse.stardust.model.xpdl.xpdl2.TypeDeclarationType;
import org.eclipse.stardust.model.xpdl.xpdl2.TypeDeclarationsType;
import org.eclipse.stardust.model.xpdl.xpdl2.XpdlFactory;
import org.eclipse.stardust.model.xpdl.xpdl2.XpdlPackage;
import org.eclipse.stardust.model.xpdl.xpdl2.util.TypeDeclarationUtils;
import org.eclipse.stardust.modeling.common.ui.IdFactory;
import org.eclipse.stardust.modeling.core.Diagram_Messages;
import org.eclipse.stardust.modeling.core.editors.WorkflowModelEditor;
import org.eclipse.stardust.modeling.core.editors.dnd.ModelElementSymbolCreationFactory;
import org.eclipse.stardust.modeling.core.editors.dnd.ModelElementTransfer;
import org.eclipse.stardust.modeling.core.editors.dnd.SymbolCreationFactory;
import org.eclipse.stardust.modeling.core.editors.parts.diagram.commands.CommandHolder;
import org.eclipse.stardust.modeling.core.editors.parts.diagram.commands.CompoundDiagramCommand;
import org.eclipse.stardust.modeling.core.editors.parts.diagram.commands.CreateMetaTypeCommand;
import org.eclipse.stardust.modeling.core.editors.parts.diagram.commands.CreateModelElementCommand;
import org.eclipse.stardust.modeling.core.editors.parts.diagram.commands.CreateSymbolCommand;
import org.eclipse.stardust.modeling.core.utils.GenericUtils;
import org.eclipse.stardust.modeling.repository.common.ConnectionManager;
import org.eclipse.stardust.modeling.repository.common.IObjectDescriptor;
import org.eclipse.stardust.modeling.repository.common.ui.ConnectionEditUtils;
import org.eclipse.stardust.modeling.repository.common.util.ImportUtils;
import org.eclipse.ui.PlatformUI;

public class CreateSymbolRequest
extends CreateRequest {
    private WorkflowModelEditor editor;

    public CreateSymbolRequest(WorkflowModelEditor editor, ModelElementTransfer transfer, EditDomain editDomain) {
        this.editor = editor;
        Object transferElement = transfer.getObject();
        SymbolCreationFactory factory = null;
        factory = ModelElementSymbolCreationFactory.getFactory(transferElement);
        factory.setEditor(editor);
        if (transferElement instanceof IIdentifiableModelElement || transferElement instanceof IObjectDescriptor) {
            factory.setTransferredModelElement(transferElement);
        }
        factory.setEditDomain(editDomain);
        this.setFactory(factory);
        Map extendedData = this.getExtendedData();
        extendedData.put(ModelElementTransfer.TYPE_NAME, transferElement);
    }

    public void setSymbolContainer(ISymbolContainer container) {
        if (this.getFactory() instanceof SymbolCreationFactory) {
            SymbolCreationFactory factory = (SymbolCreationFactory)this.getFactory();
            factory.setSymbolContainer(container);
        }
    }

    public ISymbolContainer getSymbolContainer() {
        return ((SymbolCreationFactory)this.getFactory()).getSymbolContainer();
    }

    public void setLocation(Point location) {
        super.setLocation(location);
        if (this.getFactory() instanceof SymbolCreationFactory) {
            SymbolCreationFactory factory = (SymbolCreationFactory)this.getFactory();
            factory.setLocation(location);
        }
    }

    public boolean isEnabled() {
        return ((SymbolCreationFactory)this.getFactory()).isEnabled();
    }

    private void setFactoryForProcess(final IObjectDescriptor descriptor, final ProcessDefinitionType process) {
        final String subprocessName = process == null ? descriptor.getLabel() : process.getName();
        IdFactory id = new IdFactory("Activity", ActivityImplementationType.SUBPROCESS_LITERAL + Diagram_Messages.BASENAME_P2_Activity){

            public String getName() {
                return PlatformUI.getPreferenceStore().getBoolean("org.eclipse.stardust.modeling.common.projectnature.autoSubprocessNameGeneration") ? subprocessName : super.getName();
            }
        };
        CompoundDiagramCommand command = new CompoundDiagramCommand();
        final ModelType model = this.editor.getWorkflowModel();
        ConnectionManager cm = this.editor.getConnectionManager();
        final ProcessDefinitionType[] remoteProcess = new ProcessDefinitionType[]{process};
        if (process == null) {
            try {
                if (descriptor instanceof IObjectReference && ConnectionEditUtils.mustLink((IObjectDescriptor)descriptor, (ConnectionManager)cm)) {
                    remoteProcess[0] = (ProcessDefinitionType)((IObjectReference)descriptor).getEObject();
                } else {
                    Command cmd = ConnectionEditUtils.linkObject((ModelType)model, (IObjectDescriptor[])new IObjectDescriptor[]{descriptor}, (ConnectionManager)cm);
                    if (cmd != null) {
                        command.add(cmd);
                    } else {
                        command.add((Command)UnexecutableCommand.INSTANCE);
                    }
                }
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        }
        command.add(new CreateModelElementCommand(1, id, CarnotWorkflowModelPackage.eINSTANCE.getActivityType()){

            @Override
            protected IModelElement createModelElement() {
                ActivityType activity = (ActivityType)super.createModelElement();
                if (activity != null) {
                    boolean isLink;
                    activity.setImplementation(ActivityImplementationType.SUBPROCESS_LITERAL);
                    EList list = model.getProcessDefinition();
                    ProcessDefinitionType subprocess = remoteProcess[0];
                    boolean bl = isLink = subprocess != null && process == null;
                    if (subprocess == null) {
                        subprocess = (ProcessDefinitionType)ModelElementSymbolCreationFactory.findMatchingItem(descriptor, list.iterator());
                    }
                    if (subprocess != null) {
                        if (isLink) {
                            AttributeUtil.setAttribute((IExtensibleElement)activity, (String)"carnot:connection:uri", (String)descriptor.getURI().toString());
                            ModelType processModel = ModelUtils.findContainingModel((EObject)subprocess);
                            if (processModel != null) {
                                IdRef idRef = CarnotWorkflowModelFactory.eINSTANCE.createIdRef();
                                idRef.setRef(subprocess.getId());
                                idRef.setPackageRef(ImportUtils.getPackageRef((IObjectDescriptor)descriptor, (ModelType)model, (ModelType)processModel));
                                activity.setExternalRef(idRef);
                                activity.setSubProcessMode(SubProcessModeType.SYNC_SEPARATE_LITERAL);
                            }
                        } else {
                            activity.setImplementationProcess(subprocess);
                        }
                    }
                }
                return activity;
            }
        });
        command.add(new CreateSymbolCommand(0, id, CarnotWorkflowModelPackage.eINSTANCE.getActivitySymbolType()));
        this.setFactory(new CommandHolder(id, command, CarnotWorkflowModelPackage.eINSTANCE.getActivitySymbolType()));
    }

    public void setFactoryForDescriptor(IObjectDescriptor descriptor) {
        Object type = descriptor.getType();
        if (CarnotWorkflowModelPackage.eINSTANCE.getProcessDefinitionType().equals(type)) {
            this.setFactoryForProcess(descriptor, null);
        }
        if (XpdlPackage.eINSTANCE.getTypeDeclarationType().equals(type)) {
            this.setFactoryForData(descriptor);
        }
        if (CarnotWorkflowModelPackage.eINSTANCE.getApplicationType().equals(type)) {
            this.setFactoryForApplication(descriptor);
        }
    }

    private void setFactoryForApplication(final IObjectDescriptor descriptor) {
        IdFactory id = new IdFactory("Activity", ActivityImplementationType.APPLICATION_LITERAL + Diagram_Messages.BASENAME_P2_Activity);
        CompoundDiagramCommand command = new CompoundDiagramCommand();
        final ModelType model = this.editor.getWorkflowModel();
        ConnectionManager cm = this.editor.getConnectionManager();
        final ApplicationType[] remoteApplication = new ApplicationType[1];
        try {
            if (descriptor instanceof IObjectReference && ConnectionEditUtils.mustLink((IObjectDescriptor)descriptor, (ConnectionManager)cm)) {
                remoteApplication[0] = (ApplicationType)((IObjectReference)descriptor).getEObject();
            } else {
                Command cmd = ConnectionEditUtils.linkObject((ModelType)model, (IObjectDescriptor[])new IObjectDescriptor[]{descriptor}, (ConnectionManager)cm);
                if (cmd != null) {
                    command.add(cmd);
                }
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        command.add(new CreateModelElementCommand(1, id, CarnotWorkflowModelPackage.eINSTANCE.getActivityType()){

            @Override
            protected IModelElement createModelElement() {
                ActivityType activity = (ActivityType)super.createModelElement();
                if (activity != null) {
                    boolean isLink;
                    activity.setImplementation(ActivityImplementationType.APPLICATION_LITERAL);
                    EList list = model.getApplication();
                    ApplicationType application = remoteApplication[0];
                    boolean bl = isLink = application != null;
                    if (application == null) {
                        application = (ApplicationType)ModelElementSymbolCreationFactory.findMatchingItem(descriptor, list.iterator());
                    }
                    if (application != null) {
                        if (isLink) {
                            AttributeUtil.setAttribute((IExtensibleElement)activity, (String)"carnot:connection:uri", (String)descriptor.getURI().toString());
                            ModelType processModel = ModelUtils.findContainingModel((EObject)application);
                            if (processModel != null) {
                                IdRef idRef = CarnotWorkflowModelFactory.eINSTANCE.createIdRef();
                                idRef.setRef(application.getId());
                                idRef.setPackageRef(ImportUtils.getPackageRef((IObjectDescriptor)descriptor, (ModelType)model, (ModelType)processModel));
                                activity.setExternalRef(idRef);
                            }
                        } else {
                            activity.setApplication(application);
                        }
                    }
                }
                return activity;
            }
        });
        command.add(new CreateSymbolCommand(0, id, CarnotWorkflowModelPackage.eINSTANCE.getActivitySymbolType()));
        this.setFactory(new CommandHolder(id, command, CarnotWorkflowModelPackage.eINSTANCE.getActivitySymbolType()));
    }

    private void setFactoryForData(final IObjectDescriptor descriptor) {
        DataTypeType[] struct;
        final boolean javaEnumeration = TypeDeclarationUtils.isEnumeration((TypeDeclarationType)((TypeDeclarationType)((IObjectReference)descriptor).getEObject()), (boolean)true);
        CompoundDiagramCommand command = new CompoundDiagramCommand();
        final ModelType model = this.editor.getWorkflowModel();
        ConnectionManager cm = this.editor.getConnectionManager();
        String name = Diagram_Messages.TXT_STRUCTURED_DATA;
        if (javaEnumeration) {
            name = Diagram_Messages.TXT_PRIMITIVE_DATA;
        }
        if ((struct = new DataTypeType[]{(DataTypeType)ModelUtils.findIdentifiableElement((List)model.getDataType(), (String)"struct")})[0] == null) {
            Map dataExtensions = SpiExtensionRegistry.instance().getExtensions("dataTypes");
            IConfigurationElement config = (IConfigurationElement)dataExtensions.get("struct");
            if (javaEnumeration) {
                config = (IConfigurationElement)dataExtensions.get("primitive");
            }
            if (config != null) {
                name = config.getAttribute("name");
                CreateMetaTypeCommand cmdCreateMetaType = new CreateMetaTypeCommand(config, CarnotWorkflowModelPackage.eINSTANCE.getDataTypeType(), new EStructuralFeature[0]){

                    @Override
                    protected IModelElement createModelElement() {
                        struct[0] = (DataTypeType)super.createModelElement();
                        return struct[0];
                    }

                    protected Object clone() throws CloneNotSupportedException {
                        return super.clone();
                    }
                };
                command.add(cmdCreateMetaType);
            }
        }
        final TypeDeclarationType[] remoteDeclaration = new TypeDeclarationType[1];
        try {
            if (descriptor instanceof IObjectReference && ConnectionEditUtils.mustLink((IObjectDescriptor)descriptor, (ConnectionManager)cm)) {
                remoteDeclaration[0] = (TypeDeclarationType)((IObjectReference)descriptor).getEObject();
            } else {
                Command cmd = ConnectionEditUtils.linkObject((ModelType)model, (IObjectDescriptor[])new IObjectDescriptor[]{descriptor}, (ConnectionManager)cm);
                if (cmd != null) {
                    command.add(cmd);
                }
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        IdFactory id = new IdFactory("struct", name);
        if (javaEnumeration) {
            id = new IdFactory("primitive", name);
        }
        command.add(new CreateModelElementCommand(2, id, CarnotWorkflowModelPackage.eINSTANCE.getDataType()){

            @Override
            protected IModelElement createModelElement() {
                DataType data = (DataType)super.createModelElement();
                if (data != null) {
                    TypeDeclarationType decl;
                    if (!javaEnumeration) {
                        data.setType(struct[0]);
                    } else {
                        AttributeUtil.setReference((IExtensibleElement)data, (String)"carnot:engine:dataType", (EObject)((TypeDeclarationType)((IObjectReference)descriptor).getEObject()));
                        data.setType(GenericUtils.getDataTypeType(model, "primitive"));
                        AttributeUtil.setAttribute((IExtensibleElement)data, (String)"carnot:engine:type", (String)"org.eclipse.stardust.engine.core.pojo.data.Type", (String)Type.Enumeration.getId());
                    }
                    AttributeUtil.setAttribute((IExtensibleElement)data, (String)"carnot:engine:path:separator", (String)"/");
                    AttributeUtil.setBooleanAttribute((IExtensibleElement)data, (String)"carnot:engine:data:bidirectional", (Boolean)true);
                    TypeDeclarationsType declarations = model.getTypeDeclarations();
                    EList list = Collections.emptyList();
                    if (declarations != null) {
                        list = declarations.getTypeDeclaration();
                    }
                    if ((decl = remoteDeclaration[0]) == null) {
                        decl = (TypeDeclarationType)ModelElementSymbolCreationFactory.findMatchingItem(descriptor, list.iterator());
                        if (decl != null) {
                            AttributeUtil.setAttribute((IExtensibleElement)data, (String)"carnot:engine:dataType", (String)decl.getId());
                        }
                    } else {
                        AttributeUtil.setAttribute((IExtensibleElement)data, (String)"carnot:connection:uri", (String)descriptor.getURI().toString());
                        ExternalReferenceType reference = XpdlFactory.eINSTANCE.createExternalReferenceType();
                        ModelType processModel = ModelUtils.findContainingModel((EObject)decl);
                        if (processModel != null) {
                            reference.setLocation(ImportUtils.getPackageRef((IObjectDescriptor)descriptor, (ModelType)model, (ModelType)processModel).getId());
                        }
                        reference.setXref(remoteDeclaration[0].getId());
                        data.setExternalReference(reference);
                    }
                }
                return data;
            }
        });
        command.add(new CreateSymbolCommand(0, id, CarnotWorkflowModelPackage.eINSTANCE.getDataSymbolType()));
        this.setFactory(new CommandHolder(id, command, CarnotWorkflowModelPackage.eINSTANCE.getDataSymbolType()));
    }

    public void setFactoryForProcess(ProcessDefinitionType process) {
        this.setFactoryForProcess(null, process);
    }
}

