/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.core.editors.dnd;

import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.TreeEditPart;
import org.eclipse.gef.dnd.AbstractTransferDragSourceListener;
import org.eclipse.stardust.model.xpdl.carnot.IIdentifiableModelElement;
import org.eclipse.stardust.model.xpdl.carnot.INodeSymbol;
import org.eclipse.stardust.model.xpdl.xpdl2.TypeDeclarationType;
import org.eclipse.stardust.modeling.core.editors.dnd.ModelElementSymbolCreationFactory;
import org.eclipse.stardust.modeling.core.editors.dnd.ModelElementTransfer;
import org.eclipse.stardust.modeling.repository.common.IObjectDescriptor;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.Transfer;

public class ModelElementTransferDragSourceListener
extends AbstractTransferDragSourceListener {
    IIdentifiableModelElement element = null;

    public ModelElementTransferDragSourceListener(EditPartViewer viewer) {
        super(viewer, (Transfer)ModelElementTransfer.getInstance());
    }

    public void dragSetData(DragSourceEvent event) {
        event.data = this.getModelElement();
    }

    public void dragFinished(DragSourceEvent event) {
        this.element = null;
        ModelElementTransfer.getInstance().setObject(null);
    }

    public void dragStart(DragSourceEvent event) {
        Object element = this.getModelElement();
        if (element == null) {
            event.doit = false;
        }
        if (element instanceof INodeSymbol || ModelElementSymbolCreationFactory.getSymbolEClass(element) == null) {
            event.doit = false;
        }
        ModelElementTransfer.getInstance().setObject(element);
    }

    public Transfer getTransfer() {
        return super.getTransfer();
    }

    private Object getModelElement() {
        Object selection = null;
        EditPart editPart = (EditPart)this.getViewer().getSelectedEditParts().get(0);
        if (editPart instanceof TreeEditPart) {
            selection = editPart.getModel();
        }
        return selection instanceof IIdentifiableModelElement || selection instanceof IObjectDescriptor || selection instanceof TypeDeclarationType ? selection : null;
    }
}

