/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.core.editors.figures;

import java.util.List;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.gef.ConnectionEditPart;
import org.eclipse.gef.DragTracker;
import org.eclipse.gef.handles.BendpointMoveHandle;
import org.eclipse.stardust.modeling.core.editors.parts.diagram.policies.DiagramConnectionBendpointTracker;
import org.eclipse.swt.graphics.Color;

public class BendpointSelectionMoveHandle
extends BendpointMoveHandle {
    private boolean selected = false;
    private List selectedHandles;

    public BendpointSelectionMoveHandle(ConnectionEditPart connEP, int bendPointIndex, int i) {
        super(connEP, bendPointIndex, i);
    }

    protected Color getFillColor() {
        return this.selected ? ColorConstants.red : ColorConstants.black;
    }

    protected Color getBorderColor() {
        return this.selected ? ColorConstants.white : ColorConstants.white;
    }

    protected DragTracker createDragTracker() {
        DiagramConnectionBendpointTracker tracker = new DiagramConnectionBendpointTracker((ConnectionEditPart)this.getOwner(), this.selectedHandles, this){

            protected boolean handleButtonUp(int button) {
                if (!BendpointSelectionMoveHandle.this.selected && this.getCurrentInput().isControlKeyDown()) {
                    BendpointSelectionMoveHandle.this.selectedHandles.add(this.handle);
                    BendpointSelectionMoveHandle.this.selected = true;
                } else if (BendpointSelectionMoveHandle.this.selected && this.getCurrentInput().isControlKeyDown()) {
                    BendpointSelectionMoveHandle.this.selectedHandles.remove((Object)this.handle);
                    BendpointSelectionMoveHandle.this.selected = false;
                }
                BendpointSelectionMoveHandle.this.repaint();
                return super.handleButtonUp(button);
            }
        };
        tracker.setType("move bendpoint");
        tracker.setDefaultCursor(this.getCursor());
        return tracker;
    }

    public void setSelected(boolean selected) {
        this.selected = selected;
    }

    public boolean isSelected() {
        return this.selected;
    }

    public void setSelectedHandles(List selectedHandles) {
        this.selectedHandles = selectedHandles;
    }
}

