/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.core.editors.figures;

import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.stardust.common.CompareHelper;
import org.eclipse.stardust.modeling.core.editors.figures.AbstractLabeledIconFigure;
import org.eclipse.stardust.modeling.core.editors.figures.IconFigure;
import org.eclipse.stardust.modeling.core.editors.figures.MyBorderLayout;

public class EventFigure
extends AbstractLabeledIconFigure {
    public static final int EVENT_FLOW_START = 1;
    public static final int EVENT_FLOW_INTERMEDIATE = 2;
    public static final int EVENT_FLOW_END = 3;
    public static final int EVENT_TYPE_NONE = 0;
    public static final int EVENT_TYPE_MESSAGE = 1;
    public static final int EVENT_TYPE_TIMER = 2;
    public static final int EVENT_TYPE_ERROR = 3;
    public static final int EVENT_TYPE_CANCEL = 4;
    public static final int EVENT_TYPE_COMPENSATION = 5;
    public static final int EVENT_TYPE_RULE = 6;
    public static final int EVENT_TYPE_LINK = 7;
    public static final int EVENT_TYPE_MULTIPLE = 8;
    public static final int EVENT_TYPE_TERMINATE = 9;
    private String iconPath;
    private IconFigure typeIndicator;
    private int kind;

    public EventFigure(int kind, String iconPath) {
        super(EventFigure.getIconFromKind(kind, iconPath));
        this.kind = kind;
        this.getShape().setLayoutManager((LayoutManager)new MyBorderLayout());
        this.setIconPath(iconPath);
        this.setOutline(false);
    }

    @Override
    public void setText(String text) {
        boolean empty;
        boolean bl = empty = text == null || text.length() == 0;
        if (empty) {
            Label label = this.getLabel();
            if (label.getParent() != null) {
                this.doRemoveLabel(label);
            }
        } else {
            Label label = this.getLabel();
            if (label.getParent() == null) {
                label.setParent((IFigure)this);
                this.doAddLabel(label);
            }
            super.setText(text);
        }
    }

    @Override
    public void setIconPath(String iconPath) {
        if (!CompareHelper.areEqual((Object)this.iconPath, (Object)iconPath)) {
            if (this.typeIndicator != null) {
                this.getShape().remove((IFigure)this.typeIndicator);
                this.typeIndicator = null;
            }
            if (iconPath != null) {
                super.setIconPath(EventFigure.getIconFromKind(this.kind, iconPath));
                this.typeIndicator = new IconFigure(iconPath);
                if (this.getShape().getLayoutManager() == null) {
                    this.getShape().setLayoutManager((LayoutManager)new MyBorderLayout());
                }
                this.getShape().add((IFigure)this.typeIndicator, (Object)MyBorderLayout.CENTER);
            }
            this.iconPath = iconPath;
        }
    }

    private static String getIconFromKind(int kind, String iconPath) {
        if (kind == 3) {
            return "icons/full/obj16/end_event_with_border.gif";
        }
        if (iconPath == null) {
            return "icons/full/obj16/start_event_with_border.gif";
        }
        return "icons/full/obj16/start_event_border.gif";
    }
}

