/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.core.editors.figures;

import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Ellipse;
import org.eclipse.draw2d.RotatableDecoration;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Transform;

public class MessageFlowSourceDecoration
extends Ellipse
implements RotatableDecoration {
    private Point location = new Point();
    private Transform transform = new Transform();

    public MessageFlowSourceDecoration() {
        this.setSize(7, 7);
        this.setFill(true);
        this.setBackgroundColor(ColorConstants.white);
        this.setOutline(true);
        this.setForegroundColor(ColorConstants.black);
    }

    public void setLocation(Point p) {
        this.location.setLocation(p);
        this.transform.setTranslation((double)p.x, (double)p.y);
        this.applyRotation();
    }

    public void setReferencePoint(Point ref) {
        Point pt = Point.SINGLETON;
        pt.setLocation(ref);
        pt.negate().translate(this.location);
        this.transform.setRotation(Math.atan2(pt.y, pt.x));
        this.applyRotation();
    }

    private void applyRotation() {
        Dimension size = this.getSize().getNegated();
        Point centerDislocation = new Point(size.width / 2, 0);
        Point center = this.transform.getTransformed(centerDislocation);
        super.setLocation(center.translate(size.width / 2, size.height / 2));
    }
}

