/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.core.editors.figures.anchors;

import org.eclipse.draw2d.ChopboxAnchor;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.stardust.modeling.core.editors.figures.GatewayFigure;

public class TransitionConnectionAnchor
extends ChopboxAnchor {
    public static final String LEFT = "left";
    public static final String CENTER = "center";
    public static final String RIGHT = "right";
    public static final String TOP = "top";
    public static final String BOTTOM = "bottom";
    private String type;

    public TransitionConnectionAnchor(IFigure owner, Point location) {
        this(owner, TransitionConnectionAnchor.computeType(owner, location));
    }

    public TransitionConnectionAnchor(IFigure owner, String anchor) {
        super(owner);
        this.type = anchor;
    }

    public Point getLocation(Point reference) {
        IFigure owner = this.getOwner();
        Rectangle bounds = owner.getBounds();
        if (owner instanceof GatewayFigure) {
            bounds = new Rectangle(bounds);
            bounds.width = 2 * ((bounds.width + 1) / 2) - 1;
            bounds.height = 2 * ((bounds.height + 1) / 2) - 1;
        }
        Point center = bounds.getCenter();
        owner.translateToAbsolute((Translatable)center);
        Point left = bounds.getLeft();
        owner.translateToAbsolute((Translatable)left);
        Point right = bounds.getRight();
        owner.translateToAbsolute((Translatable)right);
        Point top = bounds.getTop();
        owner.translateToAbsolute((Translatable)top);
        Point bottom = bounds.getBottom();
        owner.translateToAbsolute((Translatable)bottom);
        if (LEFT.equals(this.getType())) {
            return left;
        }
        if (RIGHT.equals(this.getType())) {
            return right;
        }
        if (TOP.equals(this.getType())) {
            return top;
        }
        if (BOTTOM.equals(this.getType())) {
            return bottom;
        }
        boolean bx = reference.x < center.x;
        boolean by = reference.y < center.y;
        int dx = Math.abs(reference.x - center.x);
        int dy = Math.abs(reference.y - center.y);
        if (dy > dx) {
            return by ? top : bottom;
        }
        return bx ? left : right;
    }

    public String getType() {
        return this.type;
    }

    private static String computeType(IFigure owner, Point location) {
        Rectangle bounds = owner.getBounds();
        Point center = bounds.getCenter();
        owner.translateToAbsolute((Translatable)center);
        Point left = bounds.getLeft();
        owner.translateToAbsolute((Translatable)left);
        Point right = bounds.getRight();
        owner.translateToAbsolute((Translatable)right);
        Point top = bounds.getTop();
        owner.translateToAbsolute((Translatable)top);
        Point bottom = bounds.getBottom();
        owner.translateToAbsolute((Translatable)bottom);
        if (location.y >= top.y && location.y <= bottom.y) {
            int lx = (center.x + left.x) / 2;
            if (lx - left.x > 20) {
                lx = left.x + 20;
            }
            if (location.x < lx) {
                return LEFT;
            }
            lx = (center.x + right.x) / 2;
            if (right.x - lx > 20) {
                lx = right.x - 20;
            }
            if (location.x > lx) {
                return RIGHT;
            }
        }
        if (location.x >= left.x && location.x <= right.x) {
            int ly = (center.y + top.y) / 2;
            if (ly - top.y > 20) {
                ly = top.y + 20;
            }
            if (location.y < ly) {
                return TOP;
            }
            ly = (center.y + bottom.y) / 2;
            if (bottom.y - ly > 20) {
                ly = bottom.y - 20;
            }
            if (location.y > ly) {
                return BOTTOM;
            }
        }
        return CENTER;
    }
}

