/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.core.editors.parts.diagram;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.draw2d.IFigure;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.gef.CompoundSnapToHelper;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.SnapToGeometry;
import org.eclipse.gef.SnapToGuides;
import org.eclipse.gef.SnapToHelper;
import org.eclipse.gef.editpolicies.SnapFeedbackPolicy;
import org.eclipse.stardust.model.xpdl.carnot.INodeSymbol;
import org.eclipse.stardust.model.xpdl.carnot.ISwimlaneSymbol;
import org.eclipse.stardust.modeling.core.decoration.DecorationUtils;
import org.eclipse.stardust.modeling.core.editors.WorkflowModelEditor;
import org.eclipse.stardust.modeling.core.editors.figures.AbstractSwimlaneFigure;
import org.eclipse.stardust.modeling.core.editors.parts.diagram.AbstractNodeSymbolEditPart;
import org.eclipse.stardust.modeling.core.editors.parts.diagram.policies.DiagramComponentEditPolicy;
import org.eclipse.stardust.modeling.core.editors.tools.SnapCenterToGrid;
import org.eclipse.ui.PlatformUI;

public abstract class AbstractSwimlaneEditPart
extends AbstractNodeSymbolEditPart {
    public AbstractSwimlaneEditPart(WorkflowModelEditor editor, ISwimlaneSymbol swimlane) {
        super(editor, (INodeSymbol)swimlane);
    }

    public ISwimlaneSymbol getSwimlaneModel() {
        return (ISwimlaneSymbol)this.getModel();
    }

    public AbstractSwimlaneFigure getSwimlaneFigure() {
        return (AbstractSwimlaneFigure)this.getFigure();
    }

    @Override
    public IFigure createFeedbackFigure() {
        return null;
    }

    @Override
    protected void createEditPolicies() {
        this.installEditPolicy("ComponentEditPolicy", (EditPolicy)new DiagramComponentEditPolicy());
        this.installEditPolicy("Snap Feedback", (EditPolicy)new SnapFeedbackPolicy());
    }

    protected List getModelChildren() {
        return this.getSwimlaneModel().getChildLanes();
    }

    @Override
    public void handleNotification(Notification notification) {
        switch (notification.getFeatureID(ISwimlaneSymbol.class)) {
            case 18: {
                this.refreshChildren();
                break;
            }
            default: {
                super.handleNotification(notification);
            }
        }
    }

    protected void addChildVisual(EditPart childEditPart, int index) {
        super.addChildVisual(childEditPart, index);
        DecorationUtils.applyDecorations(childEditPart, this.decorators);
    }

    protected void removeChildVisual(EditPart childEditPart) {
        DecorationUtils.removeDecorations(childEditPart, this.decorators);
        super.removeChildVisual(childEditPart);
    }

    @Override
    protected void refreshVisuals() {
        super.refreshVisuals();
        this.getSwimlaneFigure().setName(this.getSwimlaneModel().getName());
    }

    @Override
    public Object getAdapter(Class key) {
        Object result = null;
        if (SnapToHelper.class.equals((Object)key)) {
            ArrayList<Object> snapStrategies = new ArrayList<Object>(3);
            if (Boolean.TRUE.equals(this.getViewer().getProperty("SnapToGeometry.isEnabled"))) {
                snapStrategies.add(new SnapToGeometry((GraphicalEditPart)this));
            }
            if (PlatformUI.getPreferenceStore().getBoolean("org.eclipse.stardust.modeling.common.projectnature.snapGridMode")) {
                if (Boolean.TRUE.equals(this.getViewer().getProperty("ruler$visibility"))) {
                    snapStrategies.add(new SnapToGuides((GraphicalEditPart)this));
                }
                if (Boolean.TRUE.equals(this.getViewer().getProperty("SnapToGrid.isEnabled"))) {
                    snapStrategies.add((Object)new SnapCenterToGrid((GraphicalEditPart)this));
                }
            }
            if (1 == snapStrategies.size()) {
                return snapStrategies.get(0);
            }
            if (1 < snapStrategies.size()) {
                result = new CompoundSnapToHelper(snapStrategies.toArray(new SnapToHelper[snapStrategies.size()]));
            }
        } else {
            result = super.getAdapter(key);
        }
        return result;
    }
}

