/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.core.editors.parts.diagram;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.draw2d.DelegatingLayout;
import org.eclipse.draw2d.FreeformLayer;
import org.eclipse.draw2d.Layer;
import org.eclipse.draw2d.LayeredPane;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.emf.ecore.util.FeatureMap;
import org.eclipse.gef.AutoexposeHelper;
import org.eclipse.gef.DragTracker;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.UnexecutableCommand;
import org.eclipse.gef.editparts.GridLayer;
import org.eclipse.gef.editparts.ScalableFreeformRootEditPart;
import org.eclipse.gef.editpolicies.ComponentEditPolicy;
import org.eclipse.stardust.model.xpdl.carnot.DiagramType;
import org.eclipse.stardust.model.xpdl.carnot.IModelElement;
import org.eclipse.stardust.model.xpdl.carnot.INodeSymbol;
import org.eclipse.stardust.model.xpdl.carnot.LaneSymbol;
import org.eclipse.stardust.model.xpdl.carnot.PoolSymbol;
import org.eclipse.stardust.modeling.core.editors.parts.diagram.DiagramGridLayer;
import org.eclipse.stardust.modeling.core.editors.parts.diagram.commands.ReloadConnectionCommandFactory;
import org.eclipse.stardust.modeling.core.editors.tools.AutoexposeMarqueeDragTracker;
import org.eclipse.stardust.modeling.core.editors.tools.DiagramViewportAutoexposeHelper;

public class DiagramRootEditPart
extends ScalableFreeformRootEditPart {
    protected GridLayer createGridLayer() {
        return new DiagramGridLayer();
    }

    protected LayeredPane createPrintableLayers() {
        LayeredPane layeredPane = super.createPrintableLayers();
        FreeformLayer decorationLayer = new FreeformLayer();
        decorationLayer.setLayoutManager((LayoutManager)new DelegatingLayout());
        layeredPane.addLayerAfter((Layer)decorationLayer, (Object)"BPMN Decoration Layer", (Object)"Connection Layer");
        return layeredPane;
    }

    public Object getAdapter(Class adapter) {
        if (adapter == AutoexposeHelper.class) {
            return new DiagramViewportAutoexposeHelper((GraphicalEditPart)this);
        }
        if (adapter == IModelElement.class) {
            return this.getContents().getModel();
        }
        return super.getAdapter(adapter);
    }

    public DragTracker getDragTracker(Request request) {
        DiagramRootEditPart editPart = this;
        return new AutoexposeMarqueeDragTracker((EditPart)editPart){
            private final /* synthetic */ EditPart val$editPart;
            {
                this.val$editPart = editPart;
            }

            @Override
            protected boolean handleButtonDown(int button) {
                DiagramRootEditPart.this.getViewer().select(this.val$editPart);
                return super.handleButtonDown(button);
            }
        };
    }

    protected void createEditPolicies() {
        this.installEditPolicy("ComponentEditPolicy", (EditPolicy)new ComponentEditPolicy(){

            public boolean understandsRequest(Request req) {
                if ("org.eclipse.stardust.modeling.core.reloadConnections".equals(req.getType())) {
                    return true;
                }
                return super.understandsRequest(req);
            }
        });
    }

    public Command getCommand(Request req) {
        if ("org.eclipse.stardust.modeling.core.reloadConnections".equals(req.getType())) {
            return this.getReloadConnectionsCommand();
        }
        return super.getCommand(req);
    }

    private Command getReloadConnectionsCommand() {
        UnexecutableCommand command = UnexecutableCommand.INSTANCE;
        DiagramType diagram = (DiagramType)(this.getContents().getModel() instanceof DiagramType ? this.getContents().getModel() : null);
        if (diagram != null) {
            List symbols = this.getAllSymbols(diagram);
            command = ReloadConnectionCommandFactory.INSTANCE.createReloadConnectionCmd(symbols);
        }
        return command;
    }

    private List getAllSymbols(DiagramType diagram) {
        ArrayList<INodeSymbol> allSymbols = new ArrayList<INodeSymbol>();
        FeatureMap.ValueListIterator iter = diagram.getNodes().valueListIterator();
        while (iter.hasNext()) {
            INodeSymbol symbol = (INodeSymbol)iter.next();
            allSymbols.add(symbol);
        }
        for (PoolSymbol pool : diagram.getPoolSymbols()) {
            FeatureMap.ValueListIterator iterator = pool.getNodes().valueListIterator();
            while (iterator.hasNext()) {
                INodeSymbol symbol = (INodeSymbol)iterator.next();
                allSymbols.add(symbol);
            }
            for (LaneSymbol lane : pool.getLanes()) {
                FeatureMap.ValueListIterator iter2 = lane.getNodes().valueListIterator();
                while (iter2.hasNext()) {
                    INodeSymbol symbol = (INodeSymbol)iter2.next();
                    allSymbols.add(symbol);
                }
            }
        }
        return allSymbols;
    }
}

