/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.core.editors.parts.diagram;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.RectangleFigure;
import org.eclipse.draw2d.XYLayout;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.util.FeatureMap;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.stardust.model.xpdl.carnot.CarnotWorkflowModelPackage;
import org.eclipse.stardust.model.xpdl.carnot.GroupSymbolType;
import org.eclipse.stardust.model.xpdl.carnot.INodeSymbol;
import org.eclipse.stardust.modeling.core.editors.WorkflowModelEditor;
import org.eclipse.stardust.modeling.core.editors.parts.diagram.AbstractNodeSymbolEditPart;
import org.eclipse.stardust.modeling.core.editors.parts.diagram.policies.SymbolContainerEditPolicy;
import org.eclipse.stardust.modeling.core.editors.parts.diagram.policies.SymbolGroupLayoutEditPolicy;

public class SymbolGroupEditPart
extends AbstractNodeSymbolEditPart {
    public SymbolGroupEditPart(WorkflowModelEditor editor, GroupSymbolType model) {
        super(editor, (INodeSymbol)model);
    }

    @Override
    protected void createEditPolicies() {
        super.createEditPolicies();
        this.installEditPolicy("ContainerEditPolicy", (EditPolicy)new SymbolContainerEditPolicy());
        this.installEditPolicy("LayoutEditPolicy", (EditPolicy)new SymbolGroupLayoutEditPolicy());
    }

    protected List getModelChildren() {
        ArrayList result = new ArrayList();
        FeatureMap.ValueListIterator i = this.getGroupSymbol().getNodes().valueListIterator();
        while (i.hasNext()) {
            result.add(i.next());
        }
        return result;
    }

    public List getChildren() {
        if (super.getChildren().isEmpty()) {
            return super.getChildren();
        }
        return super.getChildren();
    }

    protected IFigure createFigure() {
        RectangleFigure figure = new RectangleFigure();
        figure.setOpaque(false);
        figure.setFill(false);
        figure.setOutline(false);
        figure.setLayoutManager((LayoutManager)new XYLayout());
        return figure;
    }

    @Override
    protected void refreshVisuals() {
        super.refreshVisuals();
        Point offset = new Point((double)this.getGroupSymbol().getXPos(), (double)this.getGroupSymbol().getYPos());
        Rectangle groupBounds = null;
        GraphicalEditPart parent = (GraphicalEditPart)this.getParent();
        FeatureMap.ValueListIterator i = this.getGroupSymbol().getNodes().valueListIterator();
        while (i.hasNext()) {
            INodeSymbol node = (INodeSymbol)i.next();
            Point loc = new Point((double)node.getXPos(), (double)node.getYPos());
            Dimension dim = new Dimension(-1, -1);
            if (node.isSetWidth()) {
                dim.width = node.getWidth();
            }
            if (node.isSetHeight()) {
                dim.height = node.getHeight();
            }
            Rectangle nodeBounds = new Rectangle(loc, dim);
            if (groupBounds != null) {
                if (!nodeBounds.isEmpty()) {
                    groupBounds = groupBounds.getUnion(nodeBounds);
                    continue;
                }
                groupBounds.union(nodeBounds.getTopLeft());
                continue;
            }
            groupBounds = nodeBounds;
        }
        if (parent != null && groupBounds != null) {
            groupBounds.translate(offset);
            groupBounds.setSize(-1, -1);
            parent.setLayoutConstraint((EditPart)this, this.getFigure(), groupBounds);
        }
    }

    public void refreshGroupChildren() {
        for (EditPart element : this.getChildren()) {
            element.refresh();
        }
    }

    @Override
    public void handleNotification(Notification notification) {
        int type = notification.getEventType();
        int featureId = notification.getFeatureID(CarnotWorkflowModelPackage.class);
        for (EditPart element : this.getChildren()) {
            if (element instanceof SymbolGroupEditPart) {
                ((SymbolGroupEditPart)element).handleNotification(notification);
            }
            element.refresh();
        }
        if (type == 3 || type == 4) {
            switch (featureId) {
                case 27: {
                    for (EditPart element : this.getChildren()) {
                        element.refresh();
                    }
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 15: 
                case 16: 
                case 17: 
                case 32: {
                    this.refreshChildren();
                    break;
                }
                default: {
                    super.handleNotification(notification);
                    break;
                }
            }
        } else {
            super.handleNotification(notification);
        }
    }

    private GroupSymbolType getGroupSymbol() {
        return (GroupSymbolType)this.getModel();
    }
}

