/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.core.editors.parts.diagram.actions;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.change.ChangeDescription;
import org.eclipse.emf.ecore.change.util.ChangeRecorder;
import org.eclipse.gef.EditDomain;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gef.ui.actions.SelectionAction;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.stardust.common.reflect.Reflect;
import org.eclipse.stardust.model.xpdl.carnot.ModelType;
import org.eclipse.stardust.model.xpdl.carnot.merge.LinkAttribute;
import org.eclipse.stardust.model.xpdl.carnot.util.ModelUtils;
import org.eclipse.stardust.model.xpdl.xpdl2.ExternalPackage;
import org.eclipse.stardust.model.xpdl.xpdl2.ExternalPackages;
import org.eclipse.stardust.model.xpdl.xpdl2.XpdlFactory;
import org.eclipse.stardust.modeling.common.ui.jface.utils.FormBuilder;
import org.eclipse.stardust.modeling.core.Diagram_Messages;
import org.eclipse.stardust.modeling.core.editors.WorkflowModelEditor;
import org.eclipse.stardust.modeling.core.editors.parts.tree.ModelTreeEditPart;
import org.eclipse.stardust.modeling.repository.common.Connection;
import org.eclipse.stardust.modeling.repository.common.ConnectionManager;
import org.eclipse.stardust.modeling.repository.common.IObjectDescriptor;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.IWorkbenchPart;

public class AddExternalReferenceAction
extends SelectionAction {
    private ModelType modelType;
    private ConnectionManager connectionManager;
    private WorkflowModelEditor editor;
    private Connection selectedConnection;

    public AddExternalReferenceAction(WorkflowModelEditor part) {
        super((IWorkbenchPart)part);
        this.setId("org.eclipse.stardust.modeling.repository.common.addReferences");
        this.setText(Diagram_Messages.POPUP_FILECONNECTION_ADD_EXTERNAL_MODEL_REFERENCE);
        this.modelType = (ModelType)part.getModel();
        if (this.modelType != null) {
            this.connectionManager = (ConnectionManager)this.modelType.getConnectionManager();
        }
        this.editor = part;
    }

    protected boolean calculateEnabled() {
        Object model;
        if (this.modelType == null) {
            return false;
        }
        this.selectedConnection = null;
        if (this.getSelectedObjects().size() == 0 || this.getSelectedObjects().size() > 1) {
            return false;
        }
        if (this.getSelectedObjects().get(0) instanceof EditPart && ((model = ((EditPart)this.getSelectedObjects().get(0)).getModel()) instanceof ExternalPackages || model instanceof Connection)) {
            if (model instanceof Connection) {
                this.selectedConnection = (Connection)model;
                String byReference = this.selectedConnection.getAttribute("importByReference");
                if (!"true".equals(byReference)) {
                    return false;
                }
                List uris = ModelUtils.getURIsForExternalPackages((ModelType)this.modelType);
                String uri = "cnx://" + this.selectedConnection.getId() + "/";
                Iterator i = uris.iterator();
                while (i.hasNext()) {
                    if (!uri.equals(i.next())) continue;
                    return false;
                }
            }
            return true;
        }
        return false;
    }

    public void run() {
        Shell shell = Display.getDefault().getActiveShell();
        FileConnectionSelectionDialog dialog = new FileConnectionSelectionDialog(shell);
        if (this.selectedConnection == null && dialog.open() == 0) {
            this.selectedConnection = dialog.getSelectedConnection();
        }
        if (this.selectedConnection != null) {
            String uri = "cnx://" + this.selectedConnection.getId() + "/";
            EObject o = this.connectionManager.find(uri);
            ModelType referencedModel = (ModelType)Reflect.getFieldValue((Object)o, (String)"eObject");
            if (!ModelUtils.externalPackageExists((ModelType)this.modelType, (ModelType)referencedModel)) {
                EditDomain domain = this.editor.getEditDomain();
                CompoundCommand command = new CompoundCommand();
                ChangeRecorder targetRecorder = new ChangeRecorder();
                targetRecorder.beginRecording(Collections.singleton(this.modelType.eContainer()));
                this.createExternalPackage((IObjectDescriptor)o, this.modelType, referencedModel);
                final ChangeDescription change = targetRecorder.endRecording();
                targetRecorder.dispose();
                Command cmd = new Command(){

                    public void execute() {
                    }

                    public void undo() {
                        change.applyAndReverse();
                    }

                    public void redo() {
                        change.applyAndReverse();
                    }
                };
                command.add(cmd);
                domain.getCommandStack().execute((Command)command);
            } else {
                MessageBox messageBox = new MessageBox(Display.getDefault().getActiveShell(), 264);
                messageBox.setText(Diagram_Messages.TXT_REFERENCE_EXISTS);
                messageBox.setMessage(Diagram_Messages.MSG_AN_EXTERNAL_REF_TO_THE_MD_REF_BY_THE_SEL_FILE_CONNECTION_ALREADY_EXISTS);
                messageBox.open();
            }
            try {
                this.refreshTree();
            }
            catch (Throwable throwable) {}
        }
    }

    private void refreshTree() {
        Tree tree = (Tree)Reflect.getFieldValue((Object)((Object)this.editor.getOutlinePage().getOutlineTreeEditor()), (String)"tree");
        if (tree != null && tree.getItems().length > 0 && tree.getItem(0) != null && tree.getItem(0).getData() instanceof ModelTreeEditPart) {
            ModelTreeEditPart editPart = (ModelTreeEditPart)tree.getItem(0).getData();
            editPart.refresh();
        }
    }

    private ExternalPackage createExternalPackage(IObjectDescriptor descriptor, ModelType targetModel, ModelType sourceModel) {
        ExternalPackage pkg;
        XpdlFactory xFactory = XpdlFactory.eINSTANCE;
        String packageRef = sourceModel.getId();
        ExternalPackages packages = targetModel.getExternalPackages();
        if (packages == null) {
            packages = xFactory.createExternalPackages();
            targetModel.setExternalPackages(packages);
        }
        if ((pkg = packages.getExternalPackage(packageRef)) == null) {
            pkg = xFactory.createExternalPackage();
            pkg.setId(packageRef);
            pkg.setName(sourceModel.getName());
            pkg.setHref(packageRef);
            LinkAttribute linkAttribute = new LinkAttribute(descriptor.getURI().trimSegments(2), false, false, "carnot:connection:uri");
            linkAttribute.setLinkInfo((EObject)pkg, false);
            packages.getExternalPackage().add((Object)pkg);
        }
        return pkg;
    }

    class ConnectionLabelProvider
    extends LabelProvider {
        ConnectionLabelProvider() {
        }

        public String getText(Object element) {
            Connection c = (Connection)element;
            return c.getName();
        }
    }

    public class FileConnectionSelectionDialog
    extends Dialog {
        Connection selectedConnection;
        private ComboViewer fileConnectionCombo;

        public FileConnectionSelectionDialog(Shell parentShell) {
            super(parentShell);
        }

        public Connection getSelectedConnection() {
            return this.selectedConnection;
        }

        protected Control createDialogArea(Composite parent) {
            Composite control = (Composite)super.createDialogArea(parent);
            Composite composite = FormBuilder.createComposite((Composite)control, (int)2);
            FormBuilder.createLabel((Composite)composite, (String)Diagram_Messages.LBL_FILE_CONNECTION);
            this.fileConnectionCombo = new ComboViewer(FormBuilder.createCombo((Composite)composite));
            this.fileConnectionCombo.setLabelProvider((IBaseLabelProvider)new ConnectionLabelProvider());
            Iterator i = AddExternalReferenceAction.this.connectionManager.getConnections();
            while (i.hasNext()) {
                this.fileConnectionCombo.add(i.next());
            }
            this.fileConnectionCombo.addSelectionChangedListener(new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    IStructuredSelection structuredSelection = (IStructuredSelection)event.getSelection();
                    FileConnectionSelectionDialog.this.selectedConnection = (Connection)structuredSelection.getFirstElement();
                }
            });
            return control;
        }

        protected Control createContents(Composite parent) {
            Control control = super.createContents(parent);
            this.getButton(0).setText(Diagram_Messages.BUT_TXT_OK);
            return control;
        }

        protected void configureShell(Shell newShell) {
            super.configureShell(newShell);
            newShell.setText(Diagram_Messages.TXT_FILE_CONNECTION_SELECTION);
        }
    }
}

