/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.core.editors.parts.diagram.actions;

import java.util.List;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.Tool;
import org.eclipse.gef.palette.ConnectionCreationToolEntry;
import org.eclipse.gef.palette.PaletteContainer;
import org.eclipse.gef.palette.PaletteEntry;
import org.eclipse.gef.palette.PaletteRoot;
import org.eclipse.gef.palette.ToolEntry;
import org.eclipse.gef.ui.actions.SelectionAction;
import org.eclipse.stardust.model.xpdl.carnot.INodeSymbol;
import org.eclipse.stardust.modeling.core.DiagramPlugin;
import org.eclipse.stardust.modeling.core.Diagram_Messages;
import org.eclipse.stardust.modeling.core.editors.DiagramEditorPage;
import org.eclipse.stardust.modeling.core.editors.DynamicConnectionCommand;
import org.eclipse.stardust.modeling.core.editors.WorkflowModelEditor;
import org.eclipse.stardust.modeling.core.editors.parts.diagram.AbstractNodeSymbolEditPart;
import org.eclipse.stardust.modeling.core.editors.tools.CarnotConnectionCreationTool;
import org.eclipse.ui.IWorkbenchPart;

public class ConnectAction
extends SelectionAction {
    public static final String CONNECT_LABEL = Diagram_Messages.ConnectAction_Label;
    public static final String CONNECT_TOOLTIP = Diagram_Messages.ConnectAction_ToolTip;

    public ConnectAction(WorkflowModelEditor editor) {
        super((IWorkbenchPart)editor);
        this.initUI();
    }

    protected boolean calculateEnabled() {
        INodeSymbol source = this.extractSymbol(0);
        if (source != null) {
            INodeSymbol target = this.extractSymbol(1);
            DynamicConnectionCommand cmd = new DynamicConnectionCommand(null);
            cmd.setSourceSymbol(source);
            cmd.setTargetSymbol(target);
            return cmd.canExecute();
        }
        return false;
    }

    private INodeSymbol extractSymbol(int i) {
        EditPart part;
        Object model;
        Object item;
        List selection = this.getSelectedObjects();
        if (selection.size() > 0 && selection.size() < 3 && i < selection.size() && (item = selection.get(i)) instanceof EditPart && (model = (part = (EditPart)item).getModel()) instanceof INodeSymbol) {
            return (INodeSymbol)model;
        }
        return null;
    }

    public void run() {
        WorkflowModelEditor editor = (WorkflowModelEditor)this.getWorkbenchPart();
        INodeSymbol source = this.extractSymbol(0);
        INodeSymbol target = this.extractSymbol(1);
        if (target == null) {
            DiagramEditorPage page = (DiagramEditorPage)editor.getCurrentPage();
            PaletteRoot palette = page.getPaletteRoot();
            ConnectionCreationToolEntry entry = this.findToolEntry((PaletteContainer)palette, "org.eclipse.stardust.modeling.core.connect");
            if (entry != null) {
                page.getPaletteViewer().setActiveTool((ToolEntry)entry);
                Tool tool = page.getEditDomain().getActiveTool();
                if (tool instanceof CarnotConnectionCreationTool) {
                    CarnotConnectionCreationTool cct = (CarnotConnectionCreationTool)tool;
                    List selection = this.getSelectedObjects();
                    AbstractNodeSymbolEditPart part = (AbstractNodeSymbolEditPart)selection.get(0);
                    cct.startConnection(part);
                }
            }
        } else {
            DynamicConnectionCommand cmd = new DynamicConnectionCommand(editor);
            cmd.setSourceSymbol(source);
            cmd.setTargetSymbol(target);
            this.execute(cmd);
        }
    }

    private ConnectionCreationToolEntry findToolEntry(PaletteContainer palette, String name) {
        for (PaletteEntry entry : palette.getChildren()) {
            ConnectionCreationToolEntry toolEntry;
            if (entry instanceof ConnectionCreationToolEntry && "org.eclipse.stardust.modeling.core.connect".equals(entry.getId())) {
                return (ConnectionCreationToolEntry)entry;
            }
            if (!(entry instanceof PaletteContainer) || (toolEntry = this.findToolEntry((PaletteContainer)entry, name)) == null) continue;
            return toolEntry;
        }
        return null;
    }

    protected void initUI() {
        this.setId("org.eclipse.stardust.modeling.core.connect");
        this.setText(CONNECT_LABEL);
        this.setToolTipText(CONNECT_TOOLTIP);
        this.setImageDescriptor(DiagramPlugin.getImageDescriptor("icons/full/obj16/connection.gif"));
        this.setAccelerator(67);
    }
}

