/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.core.editors.parts.diagram.actions;

import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.ui.actions.SelectionAction;
import org.eclipse.stardust.model.xpdl.carnot.CarnotWorkflowModelPackage;
import org.eclipse.stardust.model.xpdl.carnot.DiagramModeType;
import org.eclipse.stardust.model.xpdl.carnot.DiagramType;
import org.eclipse.stardust.model.xpdl.carnot.IModelElement;
import org.eclipse.stardust.model.xpdl.carnot.ModelType;
import org.eclipse.stardust.model.xpdl.carnot.OrientationType;
import org.eclipse.stardust.model.xpdl.carnot.PoolSymbol;
import org.eclipse.stardust.model.xpdl.carnot.ProcessDefinitionType;
import org.eclipse.stardust.model.xpdl.carnot.util.DiagramUtil;
import org.eclipse.stardust.modeling.core.DiagramPlugin;
import org.eclipse.stardust.modeling.core.Diagram_Messages;
import org.eclipse.stardust.modeling.core.createUtils.CreationUtils;
import org.eclipse.stardust.modeling.core.editors.parts.diagram.commands.CreateModelElementCommand;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;

public class CreateDiagramAction
extends SelectionAction {
    public CreateDiagramAction(IWorkbenchPart part) {
        super(part);
        this.setId("org.eclipse.stardust.modeling.core.createDiagram");
        this.setText(Diagram_Messages.TXT_NewDiagram);
        this.setImageDescriptor(DiagramPlugin.getImageDescriptor("icons/full/obj16/diagram.gif"));
    }

    protected boolean calculateEnabled() {
        return this.getSelectedObjects().size() == 1 && (this.getProcess() != null || this.getModel() != null);
    }

    public void run() {
        ProcessDefinitionType process = this.getProcess();
        DiagramType[] newDiagram = new DiagramType[1];
        Command cmd = null;
        if (process != null) {
            cmd = this.createProcessDiagramCommand(newDiagram);
        } else if (this.getModel() != null) {
            cmd = this.createModelDiagramCommand(newDiagram);
        }
        if (cmd != null) {
            this.execute(cmd);
            CreationUtils.showInOutlineAndEdit((EObject)newDiagram[0]);
        }
    }

    private Command createProcessDiagramCommand(final DiagramType[] newObject) {
        CreateModelElementCommand createDiagramCommand = new CreateModelElementCommand(1, null, CarnotWorkflowModelPackage.eINSTANCE.getDiagramType()){

            @Override
            protected IModelElement createModelElement() {
                DiagramType diagram = (DiagramType)super.createModelElement();
                diagram.setName(CreateDiagramAction.this.createDiagramName((List)this.getProcess().getDiagram()));
                diagram.setOrientation(OrientationType.VERTICAL_LITERAL.toString().equals(PlatformUI.getPreferenceStore().getString("org.eclipse.stardust.modeling.common.projectnature.modelingDirection")) ? OrientationType.VERTICAL_LITERAL : OrientationType.HORIZONTAL_LITERAL);
                DiagramModeType defaultMode = PlatformUI.getPreferenceStore().getBoolean("org.eclipse.stardust.modeling.common.projectnature.classicMode") ? DiagramModeType.MODE_400_LITERAL : DiagramModeType.MODE_450_LITERAL;
                diagram.setMode(defaultMode);
                newObject[0] = diagram;
                PoolSymbol pool = DiagramUtil.createDefaultPool(null);
                diagram.getPoolSymbols().add((Object)pool);
                return diagram;
            }
        };
        createDiagramCommand.setParent((EObject)this.getProcess());
        return createDiagramCommand;
    }

    private CreateModelElementCommand createModelDiagramCommand(final DiagramType[] newObject) {
        CreateModelElementCommand command = new CreateModelElementCommand(2, null, CarnotWorkflowModelPackage.eINSTANCE.getDiagramType()){

            @Override
            protected IModelElement createModelElement() {
                DiagramType diagram = (DiagramType)super.createModelElement();
                diagram.setName(CreateDiagramAction.this.createDiagramName((List)this.getModel().getDiagram()));
                newObject[0] = diagram;
                return diagram;
            }
        };
        command.setParent((EObject)this.getModel());
        return command;
    }

    private ProcessDefinitionType getProcess() {
        Object model;
        Object selection = this.getSelectedObjects().get(0);
        if (selection instanceof EditPart && (model = ((EditPart)selection).getModel()) instanceof ProcessDefinitionType) {
            return (ProcessDefinitionType)model;
        }
        return null;
    }

    private ModelType getModel() {
        Object model;
        Object selection = this.getSelectedObjects().get(0);
        if (selection instanceof EditPart && (model = ((EditPart)selection).getModel()) instanceof ModelType) {
            return (ModelType)model;
        }
        return null;
    }

    private String createDiagramName(List diagrams) {
        String searchName = Diagram_Messages.DIAGRAM_NAME_Diagram;
        int counter = 1;
        for (DiagramType o : diagrams) {
            String existingName = o.getName();
            if (!existingName.startsWith(searchName)) continue;
            try {
                String sn = existingName.substring(searchName.length()).trim();
                int number = Integer.parseInt(sn);
                if (number < counter) continue;
                counter = number + 1;
            }
            catch (NumberFormatException numberFormatException) {}
        }
        String name = String.valueOf(searchName) + counter;
        return name;
    }
}

