/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.core.editors.parts.diagram.actions;

import java.util.Arrays;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.ui.actions.SelectionAction;
import org.eclipse.stardust.model.xpdl.carnot.ApplicationContextTypeType;
import org.eclipse.stardust.model.xpdl.carnot.ApplicationType;
import org.eclipse.stardust.model.xpdl.carnot.CarnotWorkflowModelFactory;
import org.eclipse.stardust.model.xpdl.carnot.CarnotWorkflowModelPackage;
import org.eclipse.stardust.model.xpdl.carnot.ContextType;
import org.eclipse.stardust.model.xpdl.carnot.IModelElement;
import org.eclipse.stardust.model.xpdl.carnot.ModelType;
import org.eclipse.stardust.model.xpdl.carnot.util.ModelUtils;
import org.eclipse.stardust.modeling.common.ui.IdFactory;
import org.eclipse.stardust.modeling.core.DiagramPlugin;
import org.eclipse.stardust.modeling.core.Diagram_Messages;
import org.eclipse.stardust.modeling.core.createUtils.CreationUtils;
import org.eclipse.stardust.modeling.core.editors.WorkflowModelEditor;
import org.eclipse.stardust.modeling.core.editors.parts.diagram.commands.CompoundDiagramCommand;
import org.eclipse.stardust.modeling.core.editors.parts.diagram.commands.CreateMetaTypeCommand;
import org.eclipse.stardust.modeling.core.editors.parts.diagram.commands.CreateModelElementCommand;
import org.eclipse.stardust.modeling.core.editors.parts.tree.ChildCategoryNode;
import org.eclipse.ui.IWorkbenchPart;

public class CreateInteractiveApplicationAction
extends SelectionAction {
    private IConfigurationElement config;
    private ApplicationType intApplication;

    public CreateInteractiveApplicationAction(IConfigurationElement config, WorkflowModelEditor part) {
        super((IWorkbenchPart)part);
        this.config = config;
        this.setId("org.eclipse.stardust.modeling.core.createInteractiveApplication." + config.getAttribute("id"));
        this.setText(config.getAttribute("name"));
        this.setImageDescriptor(DiagramPlugin.getImageDescriptor(config));
    }

    protected boolean calculateEnabled() {
        return this.getSelectedObjects().size() == 1 && (this.getModel() != null || this.isApplicationCategoryNode());
    }

    private boolean isApplicationCategoryNode() {
        Object selection = this.getSelectedObjects().get(0);
        return selection instanceof ChildCategoryNode && Arrays.asList(((ChildCategoryNode)selection).getChildrenFeatures()).contains(CarnotWorkflowModelPackage.eINSTANCE.getModelType_Application());
    }

    public void run() {
        this.execute(this.createCommand());
        CreationUtils.showInOutlineAndEdit((EObject)this.intApplication);
    }

    private Command createCommand() {
        IdFactory idFactory = new IdFactory("interactive", Diagram_Messages.BASENAME_InteractiveApplication);
        CompoundDiagramCommand command = new CompoundDiagramCommand();
        command.add(new CreateMetaTypeCommand(this.config, CarnotWorkflowModelPackage.eINSTANCE.getApplicationContextTypeType(), new EStructuralFeature[]{CarnotWorkflowModelPackage.eINSTANCE.getApplicationContextTypeType_HasMappingId(), CarnotWorkflowModelPackage.eINSTANCE.getApplicationContextTypeType_HasApplicationPath()}));
        command.add(new CreateModelElementCommand(2, idFactory, CarnotWorkflowModelPackage.eINSTANCE.getApplicationType()){

            @Override
            protected IModelElement createModelElement() {
                ApplicationType application = (ApplicationType)super.createModelElement();
                application.setInteractive(true);
                CarnotWorkflowModelFactory factory = CarnotWorkflowModelFactory.eINSTANCE;
                ContextType context = factory.createContextType();
                context.setType(CreateInteractiveApplicationAction.getApplicationContextType(this.getModel(), CreateInteractiveApplicationAction.this.config.getAttribute("id")));
                application.getContext().add((Object)context);
                CreateInteractiveApplicationAction.this.intApplication = application;
                return application;
            }
        });
        command.setParent((EObject)(this.getModel() == null ? ((EditPart)this.getSelectedObjects().get(0)).getParent().getModel() : this.getModel()));
        return command;
    }

    private static ApplicationContextTypeType getApplicationContextType(ModelType model, String id) {
        return (ApplicationContextTypeType)ModelUtils.findIdentifiableElement((EObject)model, (EStructuralFeature)CarnotWorkflowModelPackage.eINSTANCE.getModelType_ApplicationContextType(), (String)id);
    }

    private ModelType getModel() {
        Object model;
        Object selection = this.getSelectedObjects().get(0);
        if (selection instanceof EditPart && (model = ((EditPart)selection).getModel()) instanceof ModelType) {
            return (ModelType)model;
        }
        return null;
    }
}

