/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.core.editors.parts.diagram.actions;

import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.gef.EditDomain;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.jface.action.Action;
import org.eclipse.stardust.model.xpdl.carnot.CarnotWorkflowModelPackage;
import org.eclipse.stardust.model.xpdl.carnot.DiagramModeType;
import org.eclipse.stardust.model.xpdl.carnot.DiagramType;
import org.eclipse.stardust.model.xpdl.carnot.PoolSymbol;
import org.eclipse.stardust.model.xpdl.carnot.util.DiagramUtil;
import org.eclipse.stardust.modeling.core.editors.DiagramEditorPage;
import org.eclipse.stardust.modeling.core.editors.WorkflowModelEditor;
import org.eclipse.stardust.modeling.core.editors.WorkflowModelEditorPaletteFactory;
import org.eclipse.stardust.modeling.core.editors.parts.diagram.DiagramEditPart;
import org.eclipse.stardust.modeling.core.editors.parts.diagram.commands.DelegatingCommand;
import org.eclipse.stardust.modeling.core.editors.parts.diagram.commands.SetValueCmd;
import org.eclipse.stardust.modeling.core.utils.PoolLaneUtils;
import org.eclipse.ui.PlatformUI;

public class DiagramModeAction
extends Action {
    private static final CarnotWorkflowModelPackage CWM_PKG = CarnotWorkflowModelPackage.eINSTANCE;
    private DiagramType diagram;
    private EditDomain domain;
    private DiagramModeType actualMode;

    public DiagramModeAction(String mode, DiagramType diagram, EditDomain domain, boolean classicMode) {
        super(mode);
        this.diagram = diagram;
        this.domain = domain;
        this.actualMode = classicMode ? DiagramModeType.MODE_400_LITERAL : DiagramModeType.MODE_450_LITERAL;
    }

    public void run() {
        PoolSymbol poolSymbol;
        CompoundCommand command = new CompoundCommand();
        WorkflowModelEditor editor = (WorkflowModelEditor)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor();
        final DiagramEditorPage diagramEditorPage = (DiagramEditorPage)editor.getCurrentPage();
        if (this.actualMode.equals((Object)DiagramModeType.MODE_450_LITERAL) && (poolSymbol = DiagramUtil.getDefaultPool((DiagramType)this.diagram)) != null && !poolSymbol.getNodes().isEmpty()) {
            int[] checkNegative = new int[2];
            PoolLaneUtils.checkForNegativePositions(poolSymbol, checkNegative);
            if (checkNegative[0] < 0 || checkNegative[1] < 0) {
                checkNegative[0] = -checkNegative[0];
                checkNegative[1] = -checkNegative[1];
                EditPart editPart = diagramEditorPage.findEditPart(this.diagram);
                command.add((Command)PoolLaneUtils.moveAllChildren(editPart, checkNegative));
            }
        }
        SetValueCmd cmd = new SetValueCmd((EObject)this.diagram, (EStructuralFeature)CWM_PKG.getDiagramType_Mode(), this.actualMode){

            @Override
            public void redo() {
                super.redo();
                this.updatePalette(this.getValue());
            }

            @Override
            public void undo() {
                super.undo();
                this.updatePalette(this.getUndoValue());
            }

            public void updatePalette(Object value) {
                WorkflowModelEditorPaletteFactory.setDiagramModeType((DiagramModeType)value);
                WorkflowModelEditorPaletteFactory.updatePalette(diagramEditorPage);
                WorkflowModelEditorPaletteFactory.setDiagramModeType(null);
            }
        };
        command.add((Command)cmd);
        command.add((Command)new DelegatingCommand(){

            @Override
            public Command createDelegate() {
                CompoundCommand cmd = new CompoundCommand();
                PoolSymbol poolSymbol = DiagramUtil.getDefaultPool((DiagramType)DiagramModeAction.this.diagram);
                EditPart editPart = diagramEditorPage.findEditPart(DiagramModeAction.this.diagram);
                Rectangle newSize = PoolLaneUtils.checkPoolSize((DiagramEditPart)editPart);
                if (newSize != null) {
                    cmd.add((Command)new SetValueCmd((EObject)poolSymbol, (EStructuralFeature)CWM_PKG.getINodeSymbol_Width(), (Object)new Integer(newSize.width)));
                    cmd.add((Command)new SetValueCmd((EObject)poolSymbol, (EStructuralFeature)CWM_PKG.getINodeSymbol_Height(), (Object)new Integer(newSize.height)));
                    return cmd;
                }
                return null;
            }
        });
        this.domain.getCommandStack().execute((Command)command);
    }

    public DiagramModeType getDiagramMode() {
        return this.actualMode;
    }
}

